package com.manning.aip.mymoviesdatabase.data;

import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import android.util.Log;

import com.manning.aip.mymoviesdatabase.Constants;
import com.manning.aip.mymoviesdatabase.R;
import com.manning.aip.mymoviesdatabase.model.Category;

//
// SQLiteOpenHelper   
//
public class OpenHelper extends SQLiteOpenHelper {

   private static final int DATABASE_VERSION = 1;
   
   private Context context;

   public OpenHelper(final Context context) {
      super(context, DataConstants.DATABASE_NAME, null, DATABASE_VERSION);
      this.context = context;
   }

   @Override
   public void onOpen(final SQLiteDatabase db) {
      super.onOpen(db);
      if (!db.isReadOnly()) {
    	 // Wersje SQLite'a starsze ni 3.6.19 nie obsuguj kluczy obcych. Nie
         // robi tego take wersje skompilowane z opcj SQLITE_OMIT_FOREIGN_KEY
         // http://www.sqlite.org/foreignkeys.html#fk_enable
         // 
         // Naley wczy obsug kluczy obcych, jeli jest to moliwe 
     	 // (i tak powinna by wczona, jednak warto si upewni).          
         db.execSQL("PRAGMA foreign_keys=ON;");

         // Sprawdzanie, czy klucze obce s wczone. Jeli zapytanie nie zwraca danych, nie 
         // naley nawet PRBOWA korzystaz takich kluczy.
         Cursor c = db.rawQuery("PRAGMA foreign_keys", null);
         if (c.moveToFirst()) {
            int result = c.getInt(0);
            Log.i(Constants.LOG_TAG, "Obsuga kluczy obcych (1 = tak, 0 = nie): " + result);
         } else {
            // Mona zastosowa to podejcie w metodzie onCreate i na przykad nie uywa  
         	// kluczy obcych, jeli nie s dostpne.
            Log.i(Constants.LOG_TAG, "SQLite foreign key support NOT AVAILABLE");
            // W razie koniecznoci tu mona przeczy si na kod 
            // oparty na wyzwalaczach.
         }
         if (!c.isClosed()) {
            c.close();
         }
      }
   }

   @Override
   public void onCreate(final SQLiteDatabase db) {
      Log.i(Constants.LOG_TAG, "Tworzenie bazy w metodzie onCreate klasy DataHelper.OpenHelper " + DataConstants.DATABASE_NAME);

      CategoryTable.onCreate(db);
      // Tworzenie kategorii (to jeden z moliwych sposobw; dobrze sprawdza si , jeli danych
      // jest mao). To tylko demonstracja techniki - w aplikacji meneder kategorii nie jest potrzebny.
      CategoryDao categoryDao = new CategoryDao(db);
      String[] categories = context.getResources().getStringArray(R.array.tmdb_categories);
      for (String cat : categories) {
         categoryDao.save(new Category(0, cat));
      }

      MovieTable.onCreate(db);

      MovieCategoryTable.onCreate(db);
   }

   @Override
   public void onUpgrade(final SQLiteDatabase db, final int oldVersion, final int newVersion) {
      Log
               .i(Constants.LOG_TAG, "SQLiteOpenHelper onUpgrade - oldVersion:" + oldVersion + " newVersion:"
                        + newVersion);

      MovieCategoryTable.onUpgrade(db, oldVersion, newVersion);

      MovieTable.onUpgrade(db, oldVersion, newVersion);

      CategoryTable.onUpgrade(db, oldVersion, newVersion);
   }
}
