package com.manning.aip.mymoviesdatabase;

import android.content.SharedPreferences;
import android.content.SharedPreferences.OnSharedPreferenceChangeListener;
import android.os.Bundle;
import android.preference.CheckBoxPreference;
import android.preference.PreferenceActivity;
import android.preference.PreferenceManager;

public class Preferences extends PreferenceActivity {

   private CheckBoxPreference showSplash;

   @Override
   protected void onCreate(final Bundle savedInstanceState) {
      super.onCreate(savedInstanceState);

      addPreferencesFromResource(R.layout.preferences);

      // Uchwyt do ustawie nie jest uzyskiwany za pomoc metody findViewById!
      showSplash = (CheckBoxPreference) getPreferenceScreen().findPreference("showsplash");

      setCheckBoxSummary(showSplash);

      // Naley wykrywa zdarzenia zmiany preferencji, co 
      // pozwala zaktualizowa obecnie wybran opcj.
      SharedPreferences prefs = PreferenceManager.getDefaultSharedPreferences(this);
      prefs.registerOnSharedPreferenceChangeListener(new OnSharedPreferenceChangeListener() {
         public void onSharedPreferenceChanged(SharedPreferences prefs, String key) {
            if (key.equals("showsplash")) {
               setCheckBoxSummary(showSplash);
            }
         }
      });
   }

   private void setCheckBoxSummary(CheckBoxPreference pref) {
      if (pref.isChecked()) {
         pref.setSummary("Wczony");
      } else {
         pref.setSummary("Wyczony");
      }
   }
}