package com.manning.aip.mymoviesdatabase;

import android.app.Application;
import android.content.Context;
import android.content.SharedPreferences;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.NetworkInfo.State;
import android.preference.PreferenceManager;

import com.manning.aip.mymoviesdatabase.data.DataManager;
import com.manning.aip.mymoviesdatabase.data.DataManagerImpl;
import com.manning.aip.mymoviesdatabase.util.ImageCache;

public class MyMoviesApp extends Application {

   private ConnectivityManager cMgr;
   private DataManager dataManager;
   private ImageCache imageCache;
   private SharedPreferences prefs;

   //
   // Procedury pobierajce i ustawiajce.
   //   
   public SharedPreferences getPrefs() {
      return this.prefs;
   }

   public DataManager getDataManager() {
      return this.dataManager;
   }

   public ImageCache getImageCache() {
      return this.imageCache;
   }

   //
   // Obsuga cyklu ycia.
   //
   @Override
   public void onCreate() {
      super.onCreate();
      cMgr = (ConnectivityManager) this.getSystemService(Context.CONNECTIVITY_SERVICE);
      prefs = PreferenceManager.getDefaultSharedPreferences(this);
      dataManager = new DataManagerImpl(this);
      imageCache = new ImageCache();
   }

   @Override
   public void onTerminate() {
      // Brak gwarancji wywoania.
      super.onTerminate();
   }

   //
   // Metody narzdziowe i pomocnicze.
   //
   public boolean connectionPresent() {
      NetworkInfo netInfo = cMgr.getActiveNetworkInfo();
      if ((netInfo != null) && (netInfo.getState() != null)) {
         return netInfo.getState().equals(State.CONNECTED);
      }
      return false;
   }
}