package com.manning.aip.dealdroid;

import android.app.Application;
import android.content.Context;
import android.content.SharedPreferences;
import android.content.SharedPreferences.Editor;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.NetworkInfo.State;
import android.preference.PreferenceManager;
import android.util.Log;

import com.manning.aip.dealdroid.model.Item;
import com.manning.aip.dealdroid.model.Section;
import com.manning.aip.dealdroid.xml.DailyDealsFeedParser;
import com.manning.aip.dealdroid.xml.DailyDealsXmlPullFeedParser;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DealDroidApp extends Application {

   private ConnectivityManager cMgr;
   private DailyDealsFeedParser parser;
   private List<Section> sectionList;
   private Map<Long, Bitmap> imageCache;
   private Item currentItem;
   private SharedPreferences prefs;

   //
   // Procedury ustawiajce i pobierajce.
   //
   public DailyDealsFeedParser getParser() {
      return this.parser;
   }

   public List<Section> getSectionList() {
      return this.sectionList;
   }

   public void setSectionList(List<Section> sectionList) {
      this.sectionList = sectionList;
   }

   public Map<Long, Bitmap> getImageCache() {
      return this.imageCache;
   }

   public Item getCurrentItem() {
      return this.currentItem;
   }

   public void setCurrentItem(Item currentItem) {
      this.currentItem = currentItem;
   }

   public SharedPreferences getPrefs() {
      return this.prefs;
   }

   //
   // Obsuga cyklu ycia.
   //
   @Override
   public void onCreate() {
      super.onCreate();
      this.cMgr = (ConnectivityManager) this.getSystemService(Context.CONNECTIVITY_SERVICE);
      this.parser = new DailyDealsXmlPullFeedParser();
      this.sectionList = new ArrayList<Section>(6);
      this.imageCache = new HashMap<Long, Bitmap>();
      this.prefs = PreferenceManager.getDefaultSharedPreferences(this);
   }

   @Override
   public void onTerminate() {
      // Brak gwarancji, e zostanie wywoana.
      super.onTerminate();
   }

   //
   // Stan wczeniejszej oferty (uywany przez usug).
   //
   public List<Long> getPreviousDealIds() {
      List<Long> previousDealIds = new ArrayList<Long>();
      previousDealIds.add(prefs.getLong(Constants.DEAL1, 0));
      previousDealIds.add(prefs.getLong(Constants.DEAL2, 0));
      previousDealIds.add(prefs.getLong(Constants.DEAL3, 0));
      previousDealIds.add(prefs.getLong(Constants.DEAL4, 0));
      previousDealIds.add(prefs.getLong(Constants.DEAL5, 0));
      return previousDealIds;
   }

   public void setPreviousDealIds(List<Long> previousDealIds) {
      // Bd nigdy nie powinien wystpi, jeli jednak 
	  // si zdarzy, warto szybko zgosi problem.
      if ((previousDealIds == null) || previousDealIds.isEmpty() || previousDealIds.size() > 5) {
         throw new IllegalArgumentException("Bd - previousDealIds ma warto null, jest pusta lub wiksza ni 5");
      }
      Editor editor = prefs.edit();
      editor.putLong(Constants.DEAL1, previousDealIds.get(0));
      editor.putLong(Constants.DEAL2, previousDealIds.get(1));
      editor.putLong(Constants.DEAL3, previousDealIds.get(2));
      editor.putLong(Constants.DEAL4, previousDealIds.get(3));
      // Pniej dodalimy obsug pitej oferty. Niektrzy uytkownicy maj w pliku tylko
      // cztery oferty.
      // Pewnego dnia eBay udostpnia pi ofert; zwykle s cztery oferty.
      if (previousDealIds.size() == 4) {
         previousDealIds.add(0L);
      }
      editor.putLong(Constants.DEAL5, previousDealIds.get(4));
      editor.commit();
   }

   public List<Long> parseItemsIntoDealIds(List<Item> items) {
      List<Long> idList = new ArrayList<Long>();
      if ((items != null) && !items.isEmpty()) {
         for (Item item : items) {
            idList.add(item.getItemId());
         }
      }
      return idList;
   }

   //
   // Metody pomocnicze (uywane przez wicej ni jedn inn aktywno, 
   // dlatego umieszczono je tutaj. Mona umieci je take w klasie narzdziowej).
   //
   public Bitmap retrieveBitmap(String urlString) {
      Log.d(Constants.LOG_TAG, "Pobieranie rysunku:" + urlString);
      Bitmap bitmap = null;
      try {
         URL url = new URL(urlString);
         // UWAGA - nie ograniczaj si do wywoania "url.openStream()".  
         // Jest to skrcony odpowiednik wywoania openConnection().getInputStream(), ktry nie ustawia limitu czasu.
         // Warto domylna to nieskonczono, dlatego aplikacja czeka wtedy bez koca na serwer, jeli ten nie dziaa.
         // Kilka dodatkowych wierszy pozwala utworzy poprawne rozwizanie.         
         URLConnection conn = url.openConnection();     
         conn.setConnectTimeout(3000);
         conn.setReadTimeout(5000);         
         bitmap = BitmapFactory.decodeStream(conn.getInputStream());
      } catch (MalformedURLException e) {
         Log.e(Constants.LOG_TAG, "Wyjtek w czasie pobierania obrazu - bdny adres URL", e);
      } catch (IOException e) {
         Log.e(Constants.LOG_TAG, "Wyjtek w czasie pobierania obrazu - bd wejcia-wyjcia", e);
      }
      return bitmap;
   }

   public boolean connectionPresent() {
      NetworkInfo netInfo = cMgr.getActiveNetworkInfo();
      if ((netInfo != null) && (netInfo.getState() != null)) {
         return netInfo.getState().equals(State.CONNECTED);
      } 
      return false;
   }
}