/*
 * Decompiled with CFR 0.152.
 */
package com.android.monkeyrunner.controller;

import com.android.monkeyrunner.MonkeyManager;
import com.google.common.collect.Sets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.util.Collection;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VariableFrame
extends JFrame {
    private static final Logger LOG = Logger.getLogger(VariableFrame.class.getName());
    private static final ExecutorService EXECUTOR = Executors.newCachedThreadPool();
    private MonkeyManager monkeyManager;

    private static <E> E getNthElement(Set<E> set, int offset) {
        int current = 0;
        for (E elem : set) {
            if (current == offset) {
                return elem;
            }
            ++current;
        }
        return null;
    }

    public VariableFrame() {
        super("Variables");
        this.setDefaultCloseOperation(1);
        this.setLayout(new BoxLayout(this.getContentPane(), 1));
        final VariableTableModel tableModel = new VariableTableModel();
        JButton refreshButton = new JButton("Refresh");
        this.add(refreshButton);
        refreshButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                tableModel.refresh();
            }
        });
        JTable table = new JTable(tableModel);
        this.add(table);
        tableModel.addTableModelListener(new TableModelListener(){

            public void tableChanged(TableModelEvent e) {
                VariableFrame.this.pack();
            }
        });
        this.addWindowListener(new WindowAdapter(){

            public void windowOpened(WindowEvent e) {
                tableModel.refresh();
            }
        });
        this.pack();
    }

    public void init(MonkeyManager monkeyManager) {
        this.monkeyManager = monkeyManager;
    }

    private class VariableTableModel
    extends AbstractTableModel {
        private final TreeSet<VariableHolder> set = Sets.newTreeSet();

        private VariableTableModel() {
        }

        public void refresh() {
            Collection<String> variables;
            try {
                variables = VariableFrame.this.monkeyManager.listVariable();
            }
            catch (IOException e) {
                LOG.log(Level.SEVERE, "Error getting list of variables", e);
                return;
            }
            for (final String variable : variables) {
                EXECUTOR.execute(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        String value;
                        try {
                            value = VariableFrame.this.monkeyManager.getVariable(variable);
                        }
                        catch (IOException e) {
                            LOG.log(Level.SEVERE, "Error getting variable value for " + variable, e);
                            return;
                        }
                        if (value == null) {
                            value = "";
                        }
                        TreeSet treeSet = VariableTableModel.this.set;
                        synchronized (treeSet) {
                            VariableTableModel.this.set.add(new VariableHolder(variable, value));
                            SwingUtilities.invokeLater(new Runnable(){

                                public void run() {
                                    VariableTableModel.this.fireTableDataChanged();
                                }
                            });
                        }
                    }
                });
            }
        }

        public int getColumnCount() {
            return 2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int getRowCount() {
            TreeSet<VariableHolder> treeSet = this.set;
            synchronized (treeSet) {
                return this.set.size();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object getValueAt(int rowIndex, int columnIndex) {
            VariableHolder nthElement;
            TreeSet<VariableHolder> treeSet = this.set;
            synchronized (treeSet) {
                nthElement = (VariableHolder)VariableFrame.getNthElement(this.set, rowIndex);
            }
            if (columnIndex == 0) {
                return nthElement.getKey();
            }
            return nthElement.getValue();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class VariableHolder
    implements Comparable<VariableHolder> {
        private final String key;
        private final String value;

        public VariableHolder(String key, String value) {
            this.key = key;
            this.value = value;
        }

        public String getKey() {
            return this.key;
        }

        public String getValue() {
            return this.value;
        }

        @Override
        public int compareTo(VariableHolder o) {
            return this.key.compareTo(o.key);
        }
    }
}

