/*
 * Decompiled with CFR 0.152.
 */
package com.manning.aip.dealdroid;

import android.app.Application;
import android.content.Context;
import android.content.SharedPreferences;
import android.graphics.Bitmap;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.preference.PreferenceManager;
import com.manning.aip.dealdroid.model.Item;
import com.manning.aip.dealdroid.model.Section;
import com.manning.aip.dealdroid.xml.DailyDealsFeedParser;
import com.manning.aip.dealdroid.xml.DailyDealsXmlPullFeedParser;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DealsApp
extends Application {
    public DailyDealsFeedParser parser;
    public List<Section> sectionList;
    public Map<Long, Bitmap> imageCache;
    public Section currentSection;
    public Item currentItem;
    public SharedPreferences prefs;

    public void onCreate() {
        super.onCreate();
        this.parser = new DailyDealsXmlPullFeedParser();
        this.sectionList = new ArrayList<Section>(6);
        this.imageCache = new HashMap<Long, Bitmap>();
        this.prefs = PreferenceManager.getDefaultSharedPreferences((Context)this);
    }

    public List<Long> getPreviousDealIdsFromPrefs() {
        ArrayList<Long> previousDealIds = new ArrayList<Long>();
        previousDealIds.add(this.prefs.getLong("deal1", 0L));
        previousDealIds.add(this.prefs.getLong("deal2", 0L));
        previousDealIds.add(this.prefs.getLong("deal3", 0L));
        previousDealIds.add(this.prefs.getLong("deal4", 0L));
        return previousDealIds;
    }

    public void setPreviousDealIdsToPrefs(List<Long> previousDealIds) {
        if (previousDealIds != null) {
            previousDealIds.size();
        }
        SharedPreferences.Editor editor = this.prefs.edit();
        editor.putLong("deal1", previousDealIds.get(0).longValue());
        editor.putLong("deal2", previousDealIds.get(1).longValue());
        editor.putLong("deal3", previousDealIds.get(2).longValue());
        editor.putLong("deal4", previousDealIds.get(3).longValue());
        editor.commit();
    }

    public List<Long> parseItemsIntoDealIds(List<Item> items) {
        ArrayList<Long> idList = new ArrayList<Long>();
        if (items != null && !items.isEmpty()) {
            for (Item item : items) {
                idList.add(item.itemId);
            }
        }
        return idList;
    }

    public boolean connectionPresent() {
        ConnectivityManager cMgr = (ConnectivityManager)this.getSystemService("connectivity");
        if (cMgr != null) {
            NetworkInfo netInfo = cMgr.getActiveNetworkInfo();
            if (netInfo != null && netInfo.getState() != null) {
                return netInfo.getState().equals((Object)NetworkInfo.State.CONNECTED);
            }
            return false;
        }
        return false;
    }
}

