/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.android.robotium.solo;

import android.widget.CheckedTextView;
import android.widget.CompoundButton;
import android.widget.Spinner;
import android.widget.TextView;
import com.jayway.android.robotium.solo.RobotiumUtils;
import com.jayway.android.robotium.solo.ViewFetcher;
import com.jayway.android.robotium.solo.Waiter;
import java.util.ArrayList;
import junit.framework.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Checker {
    private final ViewFetcher viewFetcher;
    private final Waiter waiter;

    public Checker(ViewFetcher viewFetcher, Waiter waiter) {
        this.viewFetcher = viewFetcher;
        this.waiter = waiter;
    }

    public <T extends CompoundButton> boolean isButtonChecked(Class<T> expectedClass, int index) {
        this.waiter.waitForView(expectedClass, index);
        ArrayList<T> list = this.viewFetcher.getCurrentViews(expectedClass);
        list = RobotiumUtils.removeInvisibleViews(list);
        if (index < 0 || index > list.size() - 1) {
            Assert.assertTrue((String)("No " + expectedClass.getSimpleName() + " with index " + index + " is found"), (boolean)false);
        }
        return ((CompoundButton)list.get(index)).isChecked();
    }

    public <T extends CompoundButton> boolean isButtonChecked(Class<T> expectedClass, String text) {
        this.waiter.waitForView(expectedClass, 0);
        ArrayList<T> list = this.viewFetcher.getCurrentViews(expectedClass);
        for (CompoundButton button : list) {
            if (!button.getText().equals(text) || !button.isChecked()) continue;
            return true;
        }
        return false;
    }

    public boolean isCheckedTextChecked(String text) {
        this.waiter.waitForText(text, 0, 10000L, true, true);
        ArrayList<CheckedTextView> list = this.viewFetcher.getCurrentViews(CheckedTextView.class);
        for (CheckedTextView checkedText : list) {
            if (!checkedText.getText().equals(text) || !checkedText.isChecked()) continue;
            return true;
        }
        return false;
    }

    public boolean isSpinnerTextSelected(String text) {
        this.waiter.waitForView(Spinner.class, 0);
        ArrayList<Spinner> spinnerList = this.viewFetcher.getCurrentViews(Spinner.class);
        for (int i = 0; i < spinnerList.size(); ++i) {
            if (!this.isSpinnerTextSelected(i, text)) continue;
            return true;
        }
        return false;
    }

    public boolean isSpinnerTextSelected(int spinnerIndex, String text) {
        Spinner spinner;
        TextView textView;
        this.waiter.waitForView(Spinner.class, spinnerIndex);
        ArrayList<Spinner> spinnerList = this.viewFetcher.getCurrentViews(Spinner.class);
        if (spinnerList.size() < spinnerIndex + 1) {
            Assert.assertTrue((String)("No spinner with index " + spinnerIndex + " is found! "), (boolean)false);
        }
        return (textView = (TextView)(spinner = spinnerList.get(spinnerIndex)).getChildAt(0)).getText().equals(text);
    }
}

