/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.android.robotium.solo;

import android.app.Instrumentation;
import android.os.SystemClock;
import android.view.MotionEvent;
import android.view.View;
import android.widget.ListView;
import android.widget.ScrollView;
import com.jayway.android.robotium.solo.ActivityUtils;
import com.jayway.android.robotium.solo.RobotiumUtils;
import com.jayway.android.robotium.solo.Sleeper;
import com.jayway.android.robotium.solo.ViewFetcher;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Scroller {
    private final Instrumentation inst;
    private final ActivityUtils activityUtils;
    private final ViewFetcher viewFetcher;
    private final Sleeper sleeper;
    private int scrollAmount = 0;

    public Scroller(Instrumentation inst, ActivityUtils activityUtils, ViewFetcher viewFetcher, Sleeper sleeper) {
        this.inst = inst;
        this.activityUtils = activityUtils;
        this.viewFetcher = viewFetcher;
        this.sleeper = sleeper;
    }

    public void drag(float fromX, float toX, float fromY, float toY, int stepCount) {
        long downTime = SystemClock.uptimeMillis();
        long eventTime = SystemClock.uptimeMillis();
        float y = fromY;
        float x = fromX;
        float yStep = (toY - fromY) / (float)stepCount;
        float xStep = (toX - fromX) / (float)stepCount;
        MotionEvent event = MotionEvent.obtain((long)downTime, (long)eventTime, (int)0, (float)fromX, (float)fromY, (int)0);
        try {
            this.inst.sendPointerSync(event);
        }
        catch (SecurityException ignored) {
            // empty catch block
        }
        for (int i = 0; i < stepCount; ++i) {
            eventTime = SystemClock.uptimeMillis();
            event = MotionEvent.obtain((long)downTime, (long)eventTime, (int)2, (float)(x += xStep), (float)(y += yStep), (int)0);
            try {
                this.inst.sendPointerSync(event);
                continue;
            }
            catch (SecurityException ignored) {
                // empty catch block
            }
        }
        eventTime = SystemClock.uptimeMillis();
        event = MotionEvent.obtain((long)downTime, (long)eventTime, (int)1, (float)toX, (float)toY, (int)0);
        try {
            this.inst.sendPointerSync(event);
        }
        catch (SecurityException ignored) {
            // empty catch block
        }
    }

    private boolean scrollScrollView(Direction direction, ArrayList<ScrollView> scrollViews) {
        int yStart = 0;
        int yEnd = 0;
        int[] xy = new int[2];
        int x = this.activityUtils.getCurrentActivity(false).getWindowManager().getDefaultDisplay().getWidth() / 2;
        ScrollView scroll = this.getView(ScrollView.class, scrollViews, 0);
        scroll.getLocationOnScreen(xy);
        if (direction == Direction.DOWN) {
            yStart = xy[1] + scroll.getHeight() - 20;
            yEnd = xy[1] + 30;
        } else if (direction == Direction.UP) {
            yStart = xy[1] + 20;
            yEnd = xy[1] + scroll.getHeight() - 30;
        }
        this.scrollAmount = scroll.getScrollY();
        this.drag(x, x, this.getDragablePosition(yStart, direction), yEnd, 40);
        return this.scrollAmount != scroll.getScrollY();
    }

    private int getDragablePosition(int y, Direction direction) {
        ArrayList touchItems = new ArrayList();
        int[] xyView = new int[2];
        View[] views = this.viewFetcher.getWindowDecorViews();
        View decorView = this.viewFetcher.getRecentDecorView(views);
        if (decorView != null) {
            touchItems = decorView.getTouchables();
        }
        for (View view : touchItems) {
            view.getLocationOnScreen(xyView);
            while (y > xyView[1] && y < xyView[1] + view.getHeight()) {
                if (direction == Direction.DOWN) {
                    y -= 5;
                    continue;
                }
                y += 5;
            }
        }
        return y;
    }

    public boolean scroll(Direction direction) {
        ArrayList<View> viewList = this.viewFetcher.getViews(null);
        ArrayList<ListView> listViews = RobotiumUtils.filterViews(ListView.class, viewList);
        if (listViews.size() > 0) {
            return this.scrollList(0, direction, listViews);
        }
        ArrayList<ScrollView> scrollViews = RobotiumUtils.filterViews(ScrollView.class, viewList);
        if (scrollViews.size() > 0) {
            return this.scrollScrollView(direction, scrollViews);
        }
        return false;
    }

    public boolean scrollList(int listIndex, Direction direction, ArrayList<ListView> listViews) {
        int[] xy = new int[2];
        ListView listView = this.getView(ListView.class, listViews, listIndex);
        listView.getLocationOnScreen(xy);
        while (listView == null && this.scrollScrollView(direction, null)) {
            this.sleeper.sleep();
            listView = this.getView(ListView.class, listViews, listIndex);
        }
        if (direction == Direction.DOWN) {
            if (listView.getLastVisiblePosition() >= listView.getCount() - 1) {
                this.scrollListToLine(listView, listView.getLastVisiblePosition());
                return false;
            }
            this.scrollListToLine(listView, listView.getLastVisiblePosition());
        } else if (direction == Direction.UP) {
            if (listView.getFirstVisiblePosition() < 2) {
                this.scrollListToLine(listView, 0);
                return false;
            }
            int lines = listView.getLastVisiblePosition() - listView.getFirstVisiblePosition();
            int lineToScrollTo = listView.getFirstVisiblePosition() - lines;
            if (lineToScrollTo < 0) {
                lineToScrollTo = 0;
            }
            this.scrollListToLine(listView, lineToScrollTo);
        }
        this.sleeper.sleep();
        return true;
    }

    private final <T extends View> T getView(Class<T> classToFilterBy, ArrayList<T> views, int index) {
        View viewToReturn = null;
        if (views == null) {
            views = this.viewFetcher.getCurrentViews(classToFilterBy);
        }
        try {
            viewToReturn = (View)views.get(index);
        }
        catch (Exception ignored) {
            // empty catch block
        }
        return (T)viewToReturn;
    }

    private void scrollListToLine(final ListView listView, final int line) {
        this.activityUtils.getCurrentActivity(false).runOnUiThread(new Runnable(){

            public void run() {
                listView.setSelection(line);
            }
        });
    }

    public void scrollToSide(Side side) {
        int screenHeight = this.activityUtils.getCurrentActivity().getWindowManager().getDefaultDisplay().getHeight();
        int screenWidth = this.activityUtils.getCurrentActivity(false).getWindowManager().getDefaultDisplay().getWidth();
        float x = (float)screenWidth / 2.0f;
        float y = (float)screenHeight / 2.0f;
        if (side == Side.LEFT) {
            this.drag(0.0f, x, y, y, 40);
        } else if (side == Side.RIGHT) {
            this.drag(x, 0.0f, y, y, 40);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Side {
        LEFT,
        RIGHT;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Direction {
        UP,
        DOWN;

    }
}

