/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.android.robotium.solo;

import android.app.Instrumentation;
import android.os.SystemClock;
import android.util.Log;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewConfiguration;
import android.widget.ListView;
import android.widget.TextView;
import com.jayway.android.robotium.solo.RobotiumUtils;
import com.jayway.android.robotium.solo.Scroller;
import com.jayway.android.robotium.solo.Sleeper;
import com.jayway.android.robotium.solo.ViewFetcher;
import com.jayway.android.robotium.solo.Waiter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.regex.Pattern;
import junit.framework.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Clicker {
    private final String LOG_TAG = "Robotium";
    private final ViewFetcher viewFetcher;
    private final Scroller scroller;
    private final Instrumentation inst;
    private final RobotiumUtils robotiumUtils;
    private final Sleeper sleeper;
    private final Waiter waiter;
    private int countMatches = 0;
    private final int TIMEOUT = 10000;

    public Clicker(ViewFetcher viewFetcher, Scroller scroller, RobotiumUtils robotiumUtils, Instrumentation inst, Sleeper sleeper, Waiter waiter) {
        this.viewFetcher = viewFetcher;
        this.scroller = scroller;
        this.robotiumUtils = robotiumUtils;
        this.inst = inst;
        this.sleeper = sleeper;
        this.waiter = waiter;
    }

    public void clickOnScreen(float x, float y) {
        long downTime = SystemClock.uptimeMillis();
        long eventTime = SystemClock.uptimeMillis();
        MotionEvent event = MotionEvent.obtain((long)downTime, (long)eventTime, (int)0, (float)x, (float)y, (int)0);
        MotionEvent event2 = MotionEvent.obtain((long)downTime, (long)eventTime, (int)1, (float)x, (float)y, (int)0);
        try {
            this.inst.sendPointerSync(event);
            this.inst.sendPointerSync(event2);
        }
        catch (SecurityException e) {
            Assert.assertTrue((String)"Click can not be completed! Something is in the way e.g. the keyboard.", (boolean)false);
        }
    }

    public void clickLongOnScreen(float x, float y, int time) {
        long downTime = SystemClock.uptimeMillis();
        long eventTime = SystemClock.uptimeMillis();
        MotionEvent event = MotionEvent.obtain((long)downTime, (long)eventTime, (int)0, (float)x, (float)y, (int)0);
        try {
            this.inst.sendPointerSync(event);
        }
        catch (SecurityException e) {
            Assert.assertTrue((String)"Click can not be completed! Something is in the way e.g. the keyboard.", (boolean)false);
        }
        this.inst.waitForIdleSync();
        eventTime = SystemClock.uptimeMillis();
        event = MotionEvent.obtain((long)downTime, (long)eventTime, (int)2, (float)(x + (float)(ViewConfiguration.getTouchSlop() / 2)), (float)(y + (float)(ViewConfiguration.getTouchSlop() / 2)), (int)0);
        this.inst.sendPointerSync(event);
        this.inst.waitForIdleSync();
        if (time > 0) {
            this.sleeper.sleep(time);
        } else {
            this.sleeper.sleep((int)((float)ViewConfiguration.getLongPressTimeout() * 1.5f));
        }
        eventTime = SystemClock.uptimeMillis();
        event = MotionEvent.obtain((long)downTime, (long)eventTime, (int)1, (float)x, (float)y, (int)0);
        this.inst.sendPointerSync(event);
        this.inst.waitForIdleSync();
        this.sleeper.sleep();
    }

    public void clickOnScreen(View view) {
        this.clickOnScreen(view, false, 0);
    }

    public void clickOnScreen(View view, boolean longClick, int time) {
        if (view == null) {
            Assert.assertTrue((String)"View is null and can therefore not be clicked!", (boolean)false);
        }
        int[] xy = new int[2];
        view.getLocationOnScreen(xy);
        int viewWidth = view.getWidth();
        int viewHeight = view.getHeight();
        float x = (float)xy[0] + (float)viewWidth / 2.0f;
        float y = (float)xy[1] + (float)viewHeight / 2.0f;
        if (longClick) {
            this.clickLongOnScreen(x, y, time);
        } else {
            this.clickOnScreen(x, y);
        }
    }

    public void clickLongOnTextAndPress(String text, int index) {
        this.clickOnText(text, true, 0, true, 0);
        try {
            this.inst.sendKeyDownUpSync(20);
        }
        catch (SecurityException e) {
            Assert.assertTrue((String)"Can not press the context menu!", (boolean)false);
        }
        for (int i = 0; i < index; ++i) {
            this.sleeper.sleepMini();
            this.inst.sendKeyDownUpSync(20);
        }
        this.inst.sendKeyDownUpSync(66);
    }

    public void clickOnMenuItem(String text) {
        this.sleeper.sleep();
        this.inst.waitForIdleSync();
        try {
            this.robotiumUtils.sendKeyCode(82);
        }
        catch (SecurityException e) {
            Assert.assertTrue((String)"Can not open the menu!", (boolean)false);
        }
        this.clickOnText(text, false, 1, false, 0);
    }

    public void clickOnMenuItem(String text, boolean subMenu) {
        this.sleeper.sleep();
        this.inst.waitForIdleSync();
        TextView textMore = null;
        int[] xy = new int[2];
        int x = 0;
        int y = 0;
        try {
            this.robotiumUtils.sendKeyCode(82);
        }
        catch (SecurityException e) {
            Assert.assertTrue((String)"Can not open the menu!", (boolean)false);
        }
        if (subMenu && this.viewFetcher.getCurrentViews(TextView.class).size() > 5 && !this.waiter.waitForText(text, 1, 1500L, false)) {
            for (TextView textView : this.viewFetcher.getCurrentViews(TextView.class)) {
                x = xy[0];
                y = xy[1];
                textView.getLocationOnScreen(xy);
                if (xy[0] <= x && xy[1] <= y) continue;
                textMore = textView;
            }
        }
        if (textMore != null) {
            this.clickOnScreen((View)textMore);
        }
        this.clickOnText(text, false, 1, false, 0);
    }

    public void clickOnText(String regex, boolean longClick, int match, boolean scroll, int time) {
        Pattern pattern = Pattern.compile(regex);
        this.waiter.waitForText(regex, 0, 10000L, scroll, true);
        TextView textToClick = null;
        ArrayList<TextView> textViewList = this.viewFetcher.getCurrentViews(TextView.class);
        textViewList = RobotiumUtils.removeInvisibleViews(textViewList);
        if (match == 0) {
            match = 1;
        }
        for (TextView textView : textViewList) {
            if (pattern.matcher(((Object)textView.getText()).toString()).find()) {
                ++this.countMatches;
            }
            if (this.countMatches != match) continue;
            this.countMatches = 0;
            textToClick = textView;
            break;
        }
        if (textToClick != null) {
            this.clickOnScreen((View)textToClick, longClick, time);
        } else if (scroll && this.scroller.scroll(Scroller.Direction.DOWN)) {
            this.clickOnText(regex, longClick, match, scroll, time);
        } else {
            if (this.countMatches > 0) {
                Assert.assertTrue((String)("There are only " + this.countMatches + " matches of " + regex), (boolean)false);
            } else {
                for (TextView textView : textViewList) {
                    Log.d((String)"Robotium", (String)(regex + " not found. Have found: " + textView.getText()));
                }
                Assert.assertTrue((String)("The text: " + regex + " is not found!"), (boolean)false);
            }
            this.countMatches = 0;
        }
    }

    public <T extends TextView> void clickOn(Class<T> viewClass, String nameRegex) {
        TextView view2;
        Pattern pattern = Pattern.compile(nameRegex);
        this.waiter.waitForText(nameRegex, 0, 10000L, true, true);
        ArrayList<T> views = this.viewFetcher.getCurrentViews(viewClass);
        views = RobotiumUtils.removeInvisibleViews(views);
        TextView viewToClick = null;
        Iterator<T> i$ = views.iterator();
        while (!(!i$.hasNext() || pattern.matcher(((Object)(view2 = (TextView)i$.next()).getText()).toString()).matches() && (viewToClick = view2).isShown())) {
        }
        if (viewToClick != null) {
            this.clickOnScreen((View)viewToClick);
        } else if (this.scroller.scroll(Scroller.Direction.DOWN)) {
            this.clickOn(viewClass, nameRegex);
        } else {
            for (TextView view2 : views) {
                Log.d((String)"Robotium", (String)(nameRegex + " not found. Have found: " + view2.getText()));
            }
            Assert.assertTrue((String)(viewClass.getSimpleName() + " with the text: " + nameRegex + " is not found!"), (boolean)false);
        }
    }

    public <T extends View> void clickOn(Class<T> viewClass, int index) {
        this.waiter.waitForView(viewClass, index);
        try {
            ArrayList<T> views = this.viewFetcher.getCurrentViews(viewClass);
            views = RobotiumUtils.removeInvisibleViews(views);
            this.clickOnScreen((View)views.get(index));
        }
        catch (IndexOutOfBoundsException e) {
            Assert.assertTrue((String)("There is no " + viewClass.getSimpleName() + " with index " + index), (boolean)false);
        }
    }

    public ArrayList<TextView> clickInList(int line) {
        return this.clickInList(line, 0);
    }

    public ArrayList<TextView> clickInList(int line, int index) {
        boolean foundList;
        if (line < 1) {
            line = 1;
        }
        if (!(foundList = this.waiter.waitForView(ListView.class, index))) {
            Assert.assertTrue((String)("No ListView with index " + index + " is available!"), (boolean)false);
        }
        ArrayList<TextView> textViews = null;
        try {
            ListView listView = this.viewFetcher.getCurrentViews(ListView.class).get(index);
            textViews = this.viewFetcher.getCurrentViews(TextView.class, (View)listView);
            textViews = RobotiumUtils.removeInvisibleViews(textViews);
        }
        catch (IndexOutOfBoundsException e) {
            Assert.assertTrue((String)"Index is not valid!", (boolean)false);
        }
        ArrayList<TextView> textViewGroup = new ArrayList<TextView>();
        int myLine = 0;
        if (textViews != null) {
            for (int i = 0; i < textViews.size(); ++i) {
                View view = this.viewFetcher.getListItemParent((View)textViews.get(i));
                try {
                    if (view.equals(this.viewFetcher.getListItemParent((View)textViews.get(i + 1)))) {
                        textViewGroup.add(textViews.get(i));
                        continue;
                    }
                    textViewGroup.add(textViews.get(i));
                    if (++myLine == line) break;
                    textViewGroup.clear();
                    continue;
                }
                catch (IndexOutOfBoundsException e) {
                    textViewGroup.add(textViews.get(i));
                }
            }
        }
        if (textViewGroup.size() != 0) {
            this.clickOnScreen((View)textViewGroup.get(textViewGroup.size() - 1));
        }
        return textViewGroup;
    }
}

