/*
 * Decompiled with CFR 0.152.
 */
package com.manning.aip.dealdroid.xml;

import android.util.Log;
import android.util.Xml;
import com.manning.aip.dealdroid.model.Item;
import com.manning.aip.dealdroid.model.Section;
import com.manning.aip.dealdroid.xml.DailyDealsFeedParser;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import org.xmlpull.v1.XmlPullParser;

public class DailyDealsXmlPullFeedParser
implements DailyDealsFeedParser {
    static final String FEED_URL = "http://deals.ebay.com/feeds/xml";
    static final String EBAY_DAILY_DEALS = "EbayDailyDeals";
    static final String MORE_DEALS = "MoreDeals";
    static final String MORE_DEALS_SECTION = "MoreDealsSection";
    static final String SECTION_TITLE = "SectionTitle";
    static final String ITEM = "Item";
    static final String ITEM_ID = "ItemId";
    static final String END_TIME = "EndTime";
    static final String PICTURE_URL = "PictureURL";
    static final String SMALL_PICTURE_URL = "SmallPictureURL";
    static final String PICTURE_175_URL = "Picture175URL";
    static final String TITLE = "Title";
    static final String DESCRIPTION = "Description";
    static final String DEAL_URL = "DealURL";
    static final String CONVERTED_CURRENT_PRICE = "ConvertedCurrentPrice";
    static final String PRIMARY_CATEGORY_NAME = "PrimaryCategoryName";
    static final String LOCATION = "Location";
    static final String QUANTITY = "Quantity";
    static final String QUANTITY_SOLD = "QuantitySold";
    static final String MSRP = "MSRP";
    static final String SAVINGS_RATE = "SavingsRate";
    static final String HOT = "Hot";
    final URL feedUrl;

    public DailyDealsXmlPullFeedParser() {
        try {
            this.feedUrl = new URL(FEED_URL);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
        Log.d((String)"DealDroid", (String)("Utworzono parser DailyDealsXmlPullFeedParser dla adresu:" + this.feedUrl));
    }

    protected InputStream getInputStream() {
        try {
            return this.feedUrl.openConnection().getInputStream();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public ArrayList<Section> parse() {
        ArrayList<Section> sections = null;
        XmlPullParser parser = Xml.newPullParser();
        try {
            Section currentSection = null;
            Item currentItem = null;
            parser.setInput(this.getInputStream(), null);
            int eventType = parser.getEventType();
            while (eventType != 1) {
                String name = null;
                switch (eventType) {
                    case 0: {
                        sections = new ArrayList<Section>();
                        break;
                    }
                    case 2: {
                        name = parser.getName();
                        if (name.equalsIgnoreCase(EBAY_DAILY_DEALS)) {
                            currentSection = new Section();
                            currentSection.title = "Daily Deals";
                        } else if (name.equalsIgnoreCase(SECTION_TITLE)) {
                            String title = parser.nextText();
                            currentSection = new Section();
                            currentSection.title = title;
                        } else if (name.equalsIgnoreCase(ITEM) && currentSection != null) {
                            currentItem = new Item();
                        }
                        if (name.equalsIgnoreCase(MORE_DEALS)) {
                            sections.add(Section.getInstance(currentSection));
                            currentSection = null;
                        }
                        if (currentSection == null || currentItem == null) break;
                        if (name.equalsIgnoreCase(ITEM_ID)) {
                            try {
                                currentItem.itemId = Long.valueOf(parser.nextText());
                            }
                            catch (NumberFormatException e) {
                                Log.e((String)"DealDroid", (String)"B\u0142\u0105d przetwarzania elementu itemId", (Throwable)e);
                            }
                            break;
                        }
                        if (name.equalsIgnoreCase(END_TIME)) {
                            try {
                                currentItem.endTime = Long.valueOf(parser.nextText());
                            }
                            catch (NumberFormatException e) {
                                Log.e((String)"DealDroid", (String)"B\u0142\u0105d przetwarzania elementu endTime", (Throwable)e);
                            }
                            break;
                        }
                        if (name.equalsIgnoreCase(PICTURE_URL)) {
                            currentItem.picUrl = parser.nextText();
                            break;
                        }
                        if (name.equalsIgnoreCase(SMALL_PICTURE_URL)) {
                            currentItem.smallPicUrl = parser.nextText();
                            break;
                        }
                        if (name.equalsIgnoreCase(PICTURE_175_URL)) {
                            currentItem.pic175Url = parser.nextText();
                            break;
                        }
                        if (name.equalsIgnoreCase(TITLE)) {
                            currentItem.title = parser.nextText();
                            break;
                        }
                        if (name.equalsIgnoreCase(DESCRIPTION)) {
                            currentItem.desc = parser.nextText();
                            break;
                        }
                        if (name.equalsIgnoreCase(DEAL_URL)) {
                            currentItem.dealUrl = parser.nextText();
                            break;
                        }
                        if (name.equalsIgnoreCase(CONVERTED_CURRENT_PRICE)) {
                            currentItem.convertedCurrentPrice = parser.nextText();
                            break;
                        }
                        if (name.equalsIgnoreCase(PRIMARY_CATEGORY_NAME)) {
                            currentItem.primaryCategoryName = parser.nextText();
                            break;
                        }
                        if (name.equalsIgnoreCase(LOCATION)) {
                            currentItem.location = parser.nextText();
                            break;
                        }
                        if (name.equalsIgnoreCase(QUANTITY)) {
                            try {
                                currentItem.quantity = Integer.valueOf(parser.nextText());
                            }
                            catch (NumberFormatException e) {
                                Log.e((String)"DealDroid", (String)"B\u0142\u0105d przetwarzania elementu quantity", (Throwable)e);
                            }
                            break;
                        }
                        if (name.equalsIgnoreCase(QUANTITY_SOLD)) {
                            try {
                                currentItem.quantitySold = Integer.valueOf(parser.nextText());
                            }
                            catch (NumberFormatException e) {
                                Log.e((String)"DealDroid", (String)"B\u0142\u0105d przetwarzania elementu quantitySold", (Throwable)e);
                            }
                            break;
                        }
                        if (name.equalsIgnoreCase(MSRP)) {
                            currentItem.msrp = parser.nextText();
                            break;
                        }
                        if (name.equalsIgnoreCase(SAVINGS_RATE)) {
                            currentItem.savingsRate = parser.nextText();
                            break;
                        }
                        if (!name.equalsIgnoreCase(HOT)) break;
                        currentItem.hot = Boolean.valueOf(parser.nextText());
                        break;
                    }
                    case 3: {
                        name = parser.getName();
                        if (name == null) break;
                        if (name.equalsIgnoreCase(MORE_DEALS_SECTION) && currentSection != null) {
                            sections.add(Section.getInstance(currentSection));
                            currentSection = null;
                            break;
                        }
                        if (!name.equalsIgnoreCase(ITEM) || currentItem == null) break;
                        currentSection.items.add(Item.getInstance(currentItem));
                        currentItem = null;
                    }
                }
                eventType = parser.next();
            }
        }
        catch (Exception e) {
            Log.e((String)"DealDroid", (String)"Wyj\u0105tek przy przetwarzaniu dokumentu XML", (Throwable)e);
            throw new RuntimeException(e);
        }
        return sections;
    }
}

