/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.android.robotium.solo;

import android.app.Activity;
import android.app.Instrumentation;
import android.content.IntentFilter;
import android.util.Log;
import com.jayway.android.robotium.solo.Sleeper;
import java.util.ArrayList;
import junit.framework.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ActivityUtils {
    private final Instrumentation inst;
    private Instrumentation.ActivityMonitor activityMonitor;
    private Activity activity;
    private final Sleeper sleeper;
    private ArrayList<Activity> activityList = new ArrayList();

    public ActivityUtils(Instrumentation inst, Activity activity, Sleeper sleeper) {
        this.inst = inst;
        this.activity = activity;
        this.sleeper = sleeper;
        this.setupActivityMonitor();
    }

    public ArrayList<Activity> getAllOpenedActivities() {
        return this.activityList;
    }

    private void setupActivityMonitor() {
        try {
            IntentFilter filter = null;
            this.activityMonitor = this.inst.addMonitor(filter, null, false);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setActivityOrientation(int orientation) {
        if (this.activity.equals(this.getCurrentActivity())) {
            this.sleeper.sleep();
        }
        Activity activity = this.getCurrentActivity(false);
        activity.setRequestedOrientation(orientation);
    }

    public Activity getCurrentActivity() {
        return this.getCurrentActivity(true);
    }

    public Activity getCurrentActivity(boolean shouldSleepFirst) {
        if (shouldSleepFirst) {
            this.sleeper.sleep();
            this.inst.waitForIdleSync();
        }
        Boolean found = false;
        if (this.activityMonitor != null && this.activityMonitor.getLastActivity() != null) {
            this.activity = this.activityMonitor.getLastActivity();
        }
        for (Activity storedActivity : this.activityList) {
            if (!storedActivity.getClass().getName().equals(this.activity.getClass().getName())) continue;
            found = true;
        }
        if (found.booleanValue()) {
            return this.activity;
        }
        this.activityList.add(this.activity);
        return this.activity;
    }

    public boolean waitForActivity(String name, int timeout) {
        long now = System.currentTimeMillis();
        long endTime = now + (long)timeout;
        while (!this.getCurrentActivity().getClass().getSimpleName().equals(name) && now < endTime) {
            now = System.currentTimeMillis();
        }
        return now < endTime;
    }

    public void goBackToActivity(String name) {
        boolean found = false;
        for (Activity activity : this.activityList) {
            if (!activity.getClass().getSimpleName().equals(name)) continue;
            found = true;
        }
        if (found) {
            while (!this.getCurrentActivity().getClass().getSimpleName().equals(name)) {
                try {
                    this.inst.sendKeyDownUpSync(4);
                }
                catch (SecurityException e) {
                    Assert.assertTrue((String)("Activity named " + name + " can not be returned to"), (boolean)false);
                }
            }
        } else {
            for (int i = 0; i < this.activityList.size(); ++i) {
                Log.d((String)"Robotium", (String)("Activity priorly opened: " + this.activityList.get(i).getClass().getSimpleName()));
            }
            Assert.assertTrue((String)("No Activity named " + name + " has been priorly opened"), (boolean)false);
        }
    }

    public String getString(int resId) {
        return this.activity.getString(resId);
    }

    public void finalize() throws Throwable {
        try {
            for (int i = this.activityList.size() - 1; i >= 0; --i) {
                this.activityList.get(i).finish();
                this.sleeper.sleep(100);
            }
            this.getCurrentActivity().finish();
            this.inst.sendKeyDownUpSync(4);
            this.activityList.clear();
        }
        catch (Exception exception) {
            // empty catch block
        }
        super.finalize();
    }
}

