/*
 * Decompiled with CFR 0.152.
 */
package com.android.monkeyrunner.controller;

import com.android.monkeyrunner.MonkeyManager;
import com.android.monkeyrunner.PhysicalButton;
import com.android.monkeyrunner.controller.VariableFrame;
import com.android.monkeyrunner.core.IMonkeyDevice;
import com.android.monkeyrunner.core.IMonkeyImage;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.Timer;

public class MonkeyControllerFrame
extends JFrame {
    private static final Logger LOG = Logger.getLogger(MonkeyControllerFrame.class.getName());
    private final JButton refreshButton = new JButton("Refresh");
    private final JButton variablesButton = new JButton("Variable");
    private final JLabel imageLabel = new JLabel();
    private final VariableFrame variableFrame;
    private MonkeyManager monkeyManager;
    private BufferedImage currentImage;
    private final Timer timer = new Timer(1000, new ActionListener(){

        public void actionPerformed(ActionEvent e) {
            MonkeyControllerFrame.this.updateScreen();
        }
    });
    private final IMonkeyDevice device;

    private JButton createToolbarButton(PhysicalButton hardButton) {
        JButton button = new JButton(new PressAction(hardButton));
        button.setText(hardButton.getKeyName());
        return button;
    }

    public MonkeyControllerFrame(IMonkeyDevice device) {
        super("MonkeyController");
        this.device = device;
        this.setDefaultCloseOperation(3);
        this.setLayout(new BoxLayout(this.getContentPane(), 1));
        JToolBar toolbar = new JToolBar();
        toolbar.add(this.createToolbarButton(PhysicalButton.HOME));
        toolbar.add(this.createToolbarButton(PhysicalButton.BACK));
        toolbar.add(this.createToolbarButton(PhysicalButton.SEARCH));
        toolbar.add(this.createToolbarButton(PhysicalButton.MENU));
        this.add(toolbar);
        this.add(this.refreshButton);
        this.add(this.variablesButton);
        this.add(this.imageLabel);
        this.refreshButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MonkeyControllerFrame.this.updateScreen();
            }
        });
        this.variableFrame = new VariableFrame();
        this.variablesButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MonkeyControllerFrame.this.variableFrame.setVisible(true);
            }
        });
        this.imageLabel.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent event) {
                try {
                    MonkeyControllerFrame.this.monkeyManager.touch(event.getX(), event.getY());
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                MonkeyControllerFrame.this.updateScreen();
            }
        });
        KeyboardFocusManager focusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        focusManager.addKeyEventDispatcher(new KeyEventDispatcher(){

            public boolean dispatchKeyEvent(KeyEvent event) {
                if (400 == event.getID()) {
                    try {
                        MonkeyControllerFrame.this.monkeyManager.type(event.getKeyChar());
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
                return false;
            }
        });
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                MonkeyControllerFrame.this.init();
                MonkeyControllerFrame.this.variableFrame.init(MonkeyControllerFrame.this.monkeyManager);
            }
        });
        this.pack();
    }

    private void updateScreen() {
        IMonkeyImage snapshot = this.device.takeSnapshot();
        this.currentImage = snapshot.createBufferedImage();
        this.imageLabel.setIcon(new ImageIcon(this.currentImage));
        this.pack();
    }

    private void init() {
        this.monkeyManager = this.device.getManager();
        if (this.monkeyManager == null) {
            throw new RuntimeException("Unable to create monkey manager");
        }
        this.updateScreen();
        this.timer.start();
    }

    private class PressAction
    extends AbstractAction {
        private final PhysicalButton button;

        public PressAction(PhysicalButton button) {
            this.button = button;
        }

        public void actionPerformed(ActionEvent event) {
            try {
                MonkeyControllerFrame.this.monkeyManager.press(this.button);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            MonkeyControllerFrame.this.updateScreen();
        }
    }
}

