/*
 * Decompiled with CFR 0.152.
 */
package com.android.monkeyrunner;

import com.android.monkeyrunner.PhysicalButton;
import com.google.common.collect.Lists;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.Socket;
import java.util.Collection;
import java.util.Collections;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MonkeyManager {
    private static Logger LOG = Logger.getLogger(MonkeyManager.class.getName());
    private Socket monkeySocket;
    private BufferedWriter monkeyWriter;
    private BufferedReader monkeyReader;

    public MonkeyManager(Socket monkeySocket) {
        try {
            this.monkeySocket = monkeySocket;
            this.monkeyWriter = new BufferedWriter(new OutputStreamWriter(monkeySocket.getOutputStream()));
            this.monkeyReader = new BufferedReader(new InputStreamReader(monkeySocket.getInputStream()));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean touchDown(int x, int y) throws IOException {
        return this.sendMonkeyEvent("touch down " + x + " " + y);
    }

    public boolean touchUp(int x, int y) throws IOException {
        return this.sendMonkeyEvent("touch up " + x + " " + y);
    }

    public boolean touchMove(int x, int y) throws IOException {
        return this.sendMonkeyEvent("touch move " + x + " " + y);
    }

    public boolean touch(int x, int y) throws IOException {
        return this.sendMonkeyEvent("tap " + x + " " + y);
    }

    public boolean press(String name) throws IOException {
        return this.sendMonkeyEvent("press " + name);
    }

    public boolean keyDown(String name) throws IOException {
        return this.sendMonkeyEvent("key down " + name);
    }

    public boolean keyUp(String name) throws IOException {
        return this.sendMonkeyEvent("key up " + name);
    }

    public boolean press(PhysicalButton button) throws IOException {
        return this.press(button.getKeyName());
    }

    private String sendMonkeyEventAndGetResponse(String command) throws IOException {
        command = command.trim();
        LOG.info("Monkey Command: " + command + ".");
        this.monkeyWriter.write(command + "\n");
        this.monkeyWriter.flush();
        return this.monkeyReader.readLine();
    }

    private boolean parseResponseForSuccess(String monkeyResponse) {
        if (monkeyResponse == null) {
            return false;
        }
        return monkeyResponse.startsWith("OK");
    }

    private String parseResponseForExtra(String monkeyResponse) {
        int offset = monkeyResponse.indexOf(58);
        if (offset < 0) {
            return "";
        }
        return monkeyResponse.substring(offset + 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean sendMonkeyEvent(String command) throws IOException {
        MonkeyManager monkeyManager = this;
        synchronized (monkeyManager) {
            String monkeyResponse = this.sendMonkeyEventAndGetResponse(command);
            return this.parseResponseForSuccess(monkeyResponse);
        }
    }

    public void close() {
        try {
            this.monkeySocket.close();
        }
        catch (IOException e) {
            LOG.log(Level.SEVERE, "Unable to close monkeySocket", e);
        }
        try {
            this.monkeyReader.close();
        }
        catch (IOException e) {
            LOG.log(Level.SEVERE, "Unable to close monkeyReader", e);
        }
        try {
            this.monkeyWriter.close();
        }
        catch (IOException e) {
            LOG.log(Level.SEVERE, "Unable to close monkeyWriter", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getVariable(String name) throws IOException {
        MonkeyManager monkeyManager = this;
        synchronized (monkeyManager) {
            String response = this.sendMonkeyEventAndGetResponse("getvar " + name);
            if (!this.parseResponseForSuccess(response)) {
                return null;
            }
            return this.parseResponseForExtra(response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<String> listVariable() throws IOException {
        MonkeyManager monkeyManager = this;
        synchronized (monkeyManager) {
            String response = this.sendMonkeyEventAndGetResponse("listvar");
            if (!this.parseResponseForSuccess(response)) {
                Collections.emptyList();
            }
            String extras = this.parseResponseForExtra(response);
            return Lists.newArrayList((Object[])extras.split(" "));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void done() throws IOException {
        MonkeyManager monkeyManager = this;
        synchronized (monkeyManager) {
            this.sendMonkeyEventAndGetResponse("done");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void quit() throws IOException {
        MonkeyManager monkeyManager = this;
        synchronized (monkeyManager) {
            this.sendMonkeyEventAndGetResponse("quit");
        }
    }

    public boolean tap(int x, int y) throws IOException {
        return this.sendMonkeyEvent("tap " + x + " " + y);
    }

    public boolean type(String text) throws IOException {
        StringTokenizer tok = new StringTokenizer(text, "\n", true);
        while (tok.hasMoreTokens()) {
            boolean success;
            String line = tok.nextToken();
            if (!("\n".equals(line) ? !(success = this.press(PhysicalButton.ENTER)) : !(success = this.sendMonkeyEvent("type " + line)))) continue;
            return false;
        }
        return true;
    }

    public boolean type(char keyChar) throws IOException {
        return this.type(Character.toString(keyChar));
    }

    public void wake() throws IOException {
        this.sendMonkeyEvent("wake");
    }
}

