/*******************************************************************************
 * Copyright 2011 See AUTHORS file.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 ******************************************************************************/
package com.badlogic.gdx.physics.box2d;

public interface ContactListener {
        /**
         * Called when two fixtures begin to touch.
         */
        public void beginContact (Contact contact);

        /**
         * Called when two fixtures cease to touch.
         */
        public void endContact (Contact contact);
        
        /* 
                This is called after a contact is updated. This allows you to inspect a
                contact before it goes to the solver. If you are careful, you can modify the
                contact manifold (e.g. disable contact).
                A copy of the old manifold is provided so that you can detect changes.
                Note: this is called only for awake bodies.
                Note: this is called even when the number of contact points is zero.
                Note: this is not called for sensors.
                Note: if you set the number of contact points to zero, you will not
                get an EndContact callback. However, you may get a BeginContact callback
                the next step. */
        public void preSolve(Contact contact, Manifold oldManifold);

        /* This lets you inspect a contact after the solver is finished. This is useful
         for inspecting impulses.
         Note: the contact manifold does not include time of impact impulses, which can be
         arbitrarily large if the sub-step is small. Hence the impulse is provided explicitly
         in a separate data structure.
         Note: this is only called for contacts that are touching, solid, and awake. */
        public void postSolve(Contact contact, ContactImpulse impulse); 
}
