package nl.codestone.cookbook.incomingcallinterceptor;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.telephony.TelephonyManager;
import android.widget.Toast;

public class IncomingCallInterceptor extends BroadcastReceiver {

    @Override
    public void onReceive(Context context, Intent intent) {                                         // 1
        String state = intent.getStringExtra(TelephonyManager.EXTRA_STATE);                         // 2
        String msg = "Zmiana stanu poczenia na: " + state;
        
        if (TelephonyManager.EXTRA_STATE_RINGING.equals(state)) {                                   // 3
            String incomingNumber = intent.getStringExtra(TelephonyManager.EXTRA_INCOMING_NUMBER);  // 4
            msg += ". Numer rozmwcy: " + incomingNumber;
            
            // Tu naley umieci operacje, ktre aplikacja ma wykonywa, kiedy dzwoni telefon
            
        }
        
        Toast.makeText(context, msg, Toast.LENGTH_LONG).show();
        
    }

}