package com.halfclosed.wordpress;

import android.app.Activity;
import android.content.Intent;
import android.os.Bundle;
import android.view.KeyEvent;

/**
 * Ta aktywno wywietla ekran powitalny i przechodzi do 
 * gwnej aktywnoci po SPLASH_TIME milisekund (lub po 
 * wciniciu dowolnego klawisza). Wybranie klawisza Wstecz
 * prowadzi do zamknicia aplikacji.
 * 
 * @author Emaad Ahmed Manzoor
 *
 */
public class Splash extends Activity {
    
    /**
     * Licznik czasu od momentu wywietlenia ekranu 
     * powitalnego (w milisekundach).
     */
    private long ms = 0;
    
    /**
     * Czas, przez ktry ekran powitalny ma by widoczny.
     */
    private final long SPLASH_TIME = 2000;
    
    /**
     * Opcja okrelajca, czy ekran powitalny ma by wywietlany.
     */
    private boolean splashActive = true;
    
    /**
     * Opcja do wstrzymywania i wznawiania zegara zwizanego z 
     * wywietlaniem ekranu powitalnego.
     */
    private boolean paused = false;
    
    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.splash);
        
        Thread mythread = new Thread() {
            public void run() {
                try {
                    while (splashActive && ms < SPLASH_TIME) {
                        if (!paused)
                            ms = ms + 100;
                        sleep(100);
                    }
                } catch (Exception e) {}
                finally {
                    startActivity(new Intent("com.halfclosed.wordpress.SEARCH"));
                    finish();
                }
            }
        };
        
        mythread.start();
    }
    
    @Override
    protected void onPause() {
        super.onPause();
        paused = true;  
    }
    
    @Override
    protected void onResume() {
        super.onResume();
        paused = false; 
    }
      
    @Override
    public boolean onKeyDown(int keyCode, KeyEvent event) {
        super.onKeyDown(keyCode, event);
        if (keyCode == KeyEvent.KEYCODE_BACK) {
            finish();
        } else {
            splashActive = false;
        }
        return true;
    }
}