package com.marcodinacci.android.commons;

public interface AndroidImage {

	/** Przeksztacanie na wersj czarno-bia (w miejscu) */
	public abstract AndroidImage toGrayscale();

	/** Wywoywanie erode (w miejscu) */
	public abstract AndroidImage erode(int erosionLevel);
	
	/** czenie dwch rysunkw ze sob (w miejscu) 
	 **/
	public abstract AndroidImage morph(AndroidImage background, int value);

	/** Sprawdzanie, czy biecy rysunek rni si od danego. 
	 * Piksele s rne, jeli pixel_value - 3 < pixel_threshold < pixel_value + 3. 
	 * Obrazy s rne, jeli suma rnych pikseli jest wiksza od wartoci progowej
	 * */
	public abstract boolean isDifferent(AndroidImage background, int pixel_threshold, 
			int threshold);
	
	/** Dostp do niskopoziomowych danych obrazu. Ukad danych 
	 *  zaley od implementacji
	 * */
	public abstract byte[] get();

}