package com.examples;

import java.util.ArrayList;

import android.app.ListActivity;
import android.content.Intent;
import android.content.res.Configuration;
import android.os.Bundle;
import android.util.Log;
import android.view.View;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.ListView;
import android.widget.Toast;
import android.widget.AdapterView.OnItemClickListener;

public class DemoList extends ListActivity implements OnItemClickListener
	{
		private static final String tag = "DemoList";
		private ListView listview;
		private ArrayAdapter<String> listAdapter;

		// Dane s przekazywane jako parametry do nastpnych aktywnoci, widokw i stron
		private String params;

		// Wywietlane dane
		private final double[][] data = { { 1, 1.0 }, { 2.0, 4.0 }, { 3.0, 10.0 }, { 4, 2.0 }, { 5.0, 20 }, { 6.0, 4.0 }, { 7.0, 1.0 }, };

		@Override
		public void onCreate(Bundle savedInstanceState)
			{
				super.onCreate(savedInstanceState);

				// Ustawianie widoku
				setContentView(R.layout.data_listview);

				// Pobieranie domylnego widoku ListView @android:list
				listview = getListView();

				// Ustawianie odbiornika klikni dla kontrolki ListView
				listview.setOnItemClickListener(this);

				// Zapisywanie danych
				ArrayList<String> dataList = getDataStringList(data);

				// Tworzenie adaptera na potrzeby wywietlania kontrolki ListView
				listAdapter = new ArrayAdapter<String>(this, android.R.layout.simple_list_item_1, dataList);

				// Wizanie adaptera z kontrolk ListView
				listview.setAdapter(listAdapter);

				// Ustawianie parametrw przekazywanych do nastpnego widoku
				setParameters(data);
			}

		private String doubleArrayToString(double[][] dataVals)
			{
				StringBuilder strBuilder = new StringBuilder();
				for (int i = 0; i < dataVals.length; i++)
					{
						String datum = "[" + String.valueOf(dataVals[i][0]) + "," + String.valueOf(dataVals[i][1]) + "]";

						if (i < dataVals.length - 1)
							{
								strBuilder.append(datum + " , ");
							}
						else
							{
								strBuilder.append(datum);
							}
					}
				return strBuilder.toString();
			}

		/**
		 * Zapisywanie parametrw w obiekcie Bundle
		 * 
		 * @param dataList
		 */
		private void setParameters(double[][] dataVals)
			{
				params = toJSON(dataVals);
			}

		public String getParameters()
			{
				return this.params;
			}

		/**
		 * Doda obsug tablic JSONArray
		 * 
		 * @param dataVals
		 * @return
		 */
		private String toJSON(double[][] dataVals)
			{
				StringBuilder strBuilder = new StringBuilder();

				strBuilder.append("[");
				strBuilder.append(doubleArrayToString(dataVals));
				strBuilder.append("]");
				return strBuilder.toString();
			}

		/**
		 * 
		 * @param dataVals
		 * @return
		 */
		private ArrayList<String> getDataStringList(double[][] dataVals)
			{
				ArrayList<String> list = new ArrayList<String>();

				// TODO: zastosowa format JSON
				for (int i = 0; i < dataVals.length; i++)
					{
						String datum = "[" + String.valueOf(dataVals[i][0]) + "," + String.valueOf(dataVals[i][1]) + "]";
						list.add(datum);
					}
				return list;
			}

		@Override
		public void onConfigurationChanged(Configuration newConfig)
			{
				super.onConfigurationChanged(newConfig);

				// Tworzenie intencji przechodzcej do nastpnej strony
				Intent intent = new Intent(this, DemoCharts.class);

				// Przekazywanie parametrw do nastpnej strony
				intent.putExtra("param", getParameters());

				// Uruchamianie aktywnoci
				startActivity(intent);

				Log.d(tag, "Zmiana orientacji...");
				Log.d(tag, "Params: " + getParameters());
			}

		@Override
		public void onItemClick(AdapterView<?> parent, View view, int position, long duration)
			{
				// Po klikniciu elementu z listy naley wywietli komunikat toast
				String msg = "Element nr: " + String.valueOf(position) + " - " + listAdapter.getItem(position);
				Toast.makeText(getApplicationContext(), msg, Toast.LENGTH_LONG).show();
			}
	}
