package com.example.sendsms;

import java.util.ArrayList;

import android.telephony.SmsManager;
import android.util.Log;

/** Kod do obsugi menedera wiadomoci SMS
 *  wywoywany z poziomu interfejsu GUI
 */
public class SendSMS {
    static String TAG = "SendSMS";
    SmsManager mSMSManager = null;
    /* Lista fragmentw, na ktre wiadomo 
     * jest dzielona przez obiekt SmsManager */
    ArrayList<String> mFragmentList = null;
    /* Numer SMSC - nieuywany */
    String mServiceCentreAddr = null;

	SendSMS() {
		mSMSManager = SmsManager.getDefault();
	}

	/* Wywoywana z poziomu interfejsu GUI. Wysya jedn wiadomo w jedno miejsce */
	public boolean sendSMSMessage(
			String aDestinationAddress,
			String aMessageText) {
		
		if (mSMSManager == null) {
			return (false);
		}

		mFragmentList = mSMSManager.divideMessage(aMessageText);
		int fragmentCount = mFragmentList.size();
		if (fragmentCount > 1) {
			Log.d(TAG, "Liczba czci: " + fragmentCount + ".");
			mSMSManager.sendMultipartTextMessage(aDestinationAddress, 
					mServiceCentreAddr,
					mFragmentList, null, null);
		} else {
			Log.d(TAG, "Wysyanie jednej czci");
			mSMSManager.sendTextMessage(aDestinationAddress, 
					mServiceCentreAddr,
					aMessageText, null, null);
		}

		return true;
	}
}