package com.example.preferences;

import android.app.Activity;
import android.content.Intent;
import android.content.SharedPreferences;
import android.os.Bundle;
import android.preference.PreferenceManager;
import android.view.View;
import android.widget.Toast;

public class Main extends Activity {
    private SharedPreferences sharedPreferences;

	/** Wywoywana, gdy aktywno tworzona jest po raz pierwszy */
    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState); 
        setContentView(R.layout.main);
        sharedPreferences = PreferenceManager.getDefaultSharedPreferences(this);
    }
    
    @Override
    protected void onResume() {
    	super.onResume();
    	String message = String.format(
    			"Ustawienia: Lista %s, Nazwisko %s, Opcja %b",
    			sharedPreferences.getString("listChoice", "Brak"),
    			sharedPreferences.getString("nameChoice", "Bez nazwiska"),
    			sharedPreferences.getBoolean("booleanChoice", false));
    	Toast.makeText(this, message, Toast.LENGTH_LONG).show();
    }
    
    public void showPrefs(View v) {
    	Intent intent = new Intent(Main.this, DemoPreferenceActivity.class);
    	startActivity(intent);
    }
}