package com.osm;

import java.util.ArrayList;
import org.osmdroid.DefaultResourceProxyImpl;
import org.osmdroid.ResourceProxy;
import org.osmdroid.util.GeoPoint;
import org.osmdroid.views.MapController;
import org.osmdroid.views.MapView;
import org.osmdroid.views.overlay.ItemizedIconOverlay;
import org.osmdroid.views.overlay.ItemizedOverlay;
import org.osmdroid.views.overlay.OverlayItem;
import android.app.Activity;
import android.os.Bundle;

public class OverlayOSM extends Activity {

    private MapView mapView;
    private MapController mapController;
    private ItemizedOverlay<OverlayItem> myLocationOverlay;
    private ResourceProxy mResourceProxy;

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);

        setContentView(R.layout.main);

        mapView = (MapView) this.findViewById(R.id.mapview);
        mapView.setBuiltInZoomControls(true);
        mapController = this.mapView.getController();
        mapController.setZoom(14);
        GeoPoint mapCenter = new GeoPoint(53554070, -2959520); 
        GeoPoint overlayPoint = new GeoPoint(53554070 + 1000, -2959520 + 1000); 
        mapController.setCenter(mapCenter);
        ArrayList<OverlayItem> overlays = new ArrayList<OverlayItem>();
        overlays.add(new OverlayItem("Nowa warstwa", "Opis warstwy", overlayPoint));

        mResourceProxy = new DefaultResourceProxyImpl(getApplicationContext());
        this.myLocationOverlay = new ItemizedIconOverlay<OverlayItem>(overlays, null, mResourceProxy);
        this.mapView.getOverlays().add(this.myLocationOverlay);
        mapView.invalidate();
    }

}
