package numbers;

import java.text.*;

/**
 * Formatowanie liczby mnogiej (dla jzyka angielskiego).
 * @author Ian F. Darwin, http://www.darwinsys.com/
 * @version $Id: FormatPluralsChoice.java,v 1.9 2010/06/22 21:51:41 ian Exp $
 */
public class FormatPluralsChoice extends FormatPlurals {

	// Obiekt ChoiceFormat zwracajcy tylko sowo w liczbie mnogiej
	static double[] limits = { 0, 1, 2 };
	static String[] formats = { "reviews", "review", "reviews"};
	static ChoiceFormat pluralizedFormat = new ChoiceFormat(limits, formats);

	// ChoiceFormat zwracajcy angielsk wersj tekstow z uwzgldnieniem liczby
	static ChoiceFormat quantizedFormat = new ChoiceFormat(
		"0#no reviews|1#one review|1<many reviews");

	// Dane testowe
	static int[] data = { -1, 0, 1, 2, 3 };

	public static void main(String[] argv) {
		System.out.println("Liczba mnoga:");
		for (int i : data) {
			System.out.println("Found " + i + " " + pluralizedFormat.format(i));
		}
		
		System.out.println("Z okreleniem liczby:");
		for (int i : data) {
			System.out.println("Found " + quantizedFormat.format(i));
		}
	}
}
