package com.darwinsys.android;

import android.widget.EditText;

public class NumberPickerLogic {

	int minimum = 0;
	int maximum = Integer.MAX_VALUE;
	EditText number;

	public NumberPickerLogic(EditText number) {
		this(number, 0, Integer.MAX_VALUE);
	}

	public NumberPickerLogic(EditText number, int minimum, int maximum) {
		super();
		this.number = number;
		this.minimum = minimum;
		this.maximum = maximum;
	}

	public void increment() {
		final int newValue = clamp(getValue() + 1);
		setValue(newValue);
	}

	public void decrement() {
		final int newValue = clamp(getValue() - 1);
		setValue(newValue);
	}

	/** Gwarantuje, e wartoci znajduj si w dozwolonym przedziale */
	int clamp(int newValue) {
		if (newValue < minimum) {
			newValue = minimum;
		}
		if (newValue > maximum) {
			newValue = maximum;
		}
		return newValue;
	}

	/** Zwracanie wartoci */
	public int getValue() {
		return Integer.parseInt(number.getText().toString());
	}

	/** Ustawianie wartoci */
	public void setValue(int value) {
		number.setText(Integer.toString(value));
	}

}
