package com.halfclosed.wordpress;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.util.Log;
import android.view.KeyEvent;
import android.view.View;
import android.view.View.OnClickListener;
import android.widget.ArrayAdapter;
import android.widget.AutoCompleteTextView;
import android.widget.Button;
import android.widget.TextView;

/**
 * Ta aktywno to ekran wyszukiwania. Uytkownik moe utworzy
 * zapytanie za pomoc element interfejsu graficznego, a aplikacja
 * kieruje to zapytanie do wyszukiwarki JustDial, pobiera dane,
 * wywietla je, pobiera informacje o odlegoci z serwisu
 * Google Maps, a nastpnie uruchamia aktywno Results.
 * 
 * @author Emaad Ahmed Manzoor
 *
 */
public class Search extends Activity {
    
    public static String searchText;
    public static String city;
    public static String locality;
    
    @Override
    public void onCreate(Bundle savedInstanceState) {
        
        super.onCreate(savedInstanceState);
        setContentView(R.layout.search);
        
        final Context context = getApplicationContext();
        
        String[] cities = getResources().getStringArray(R.array.cities);
        ArrayAdapter<String> adapter = new ArrayAdapter<String> (this, android.R.layout.simple_dropdown_item_1line, cities );
        final AutoCompleteTextView citiesView = (AutoCompleteTextView) findViewById(R.id.city_autocompletetextview);
        citiesView.setAdapter(adapter);     
        
        Button searchButton = (Button) findViewById(R.id.search_button);
        searchButton.setOnClickListener(new OnClickListener() {        
            public void onClick(View v) {
                
                searchText = ((TextView)findViewById(R.id.search_edittext)).getText().toString();
                city = citiesView.getText().toString();
                locality = ((TextView)findViewById(R.id.locality_edittext)).getText().toString();
                
                Intent startProgress = new Intent("com.halfclosed.wordpress.PROGRESS");
                Bundle params = new Bundle();
                params.putString("city", city);
                params.putString("locality", locality);
                params.putString("searchtext", searchText);
                startProgress.putExtras(params);
                startProgress.setFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
                startActivity(startProgress);
                
            }
        });
        
    }
    
    @Override
    public boolean onKeyDown(int keyCode, KeyEvent event) {
        super.onKeyDown(keyCode, event);
        Log.d("EMAaD", "keyCode: " + keyCode + " Zdarzenie: " + event.toString()  );
        return true;
    }
    
}