package com.examples;

import net.droidsolutions.droidcharts.awt.Rectangle2D;
import net.droidsolutions.droidcharts.core.ChartFactory;
import net.droidsolutions.droidcharts.core.JFreeChart;
import net.droidsolutions.droidcharts.core.axis.NumberAxis;
import net.droidsolutions.droidcharts.core.data.XYDataset;
import net.droidsolutions.droidcharts.core.plot.PlotOrientation;
import net.droidsolutions.droidcharts.core.plot.XYPlot;
import net.droidsolutions.droidcharts.core.renderer.xy.XYLineAndShapeRenderer;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Rect;
import android.os.Handler;
import android.view.View;

public class XYLineChartView extends View
	{

		private final String _chartTitle;
		private final String _xLabel;
		private final String _yLabel;
		private final XYDataset _dataSet;

		/** Granice widoku */
		private final Rect mRect = new Rect();

		/** Komponent obsugi wtku interfejsu uytkownika */
		private final Handler mHandler;

		/**
		 * Tworzy nowy widok graficzny
		 * 
		 * @param context
		 *          Kontekst
		 * @param chart
		 *          Wywietlany wykres
		 */
		public XYLineChartView(Context context, String chartTitle, String xLabel, String yLabel, XYDataset dataSet)
			{
				super(context);
				mHandler = new Handler();
				_chartTitle = chartTitle;
				_xLabel = xLabel;
				_yLabel = yLabel;
				_dataSet = dataSet;
			}

		@Override
		protected void onDraw(Canvas canvas)
			{

				super.onDraw(canvas);
				canvas.getClipBounds(mRect);

				// Pobieranie przekazanego zbioru danych
				final XYDataset dataset = _dataSet;

				// Tworzenie wykresu
				final JFreeChart chart = createChart(dataset);

				// Wywietlanie wykresu
				chart.draw(canvas, new Rectangle2D.Double(0, 0, mRect.width(), mRect.height()));
				Paint p = new Paint();
				p.setColor(Color.RED);
			}

		/**
		 * Ponowne wywietlanie interfejsu uytkownika
		 */
		public void repaint()
			{
				mHandler.post(new Runnable()
					{
						public void run()
							{
								invalidate();
							}
					});
			}

		/**
		 * Tworzenie wykresu
		 * 
		 * @param dataset
		 *          Dane z wykresu
		 * 
		 * @return Wykres
		 */
		private JFreeChart createChart(final XYDataset dataset)
			{
				// Tworzenie wykresu (naley okreli
				// nagwek, etykiet osi x, etykiet osi y,
				// zbir danych, orientacj, adres url)

				final JFreeChart chart = ChartFactory.createXYLineChart(_chartTitle, _xLabel, _yLabel, dataset, PlotOrientation.VERTICAL, true, true, false);

				Paint white = new Paint(Paint.ANTI_ALIAS_FLAG);
				white.setColor(Color.WHITE);

				Paint dkGray = new Paint(Paint.ANTI_ALIAS_FLAG);
				dkGray.setColor(Color.DKGRAY);

				Paint lightGray = new Paint(Paint.ANTI_ALIAS_FLAG);
				lightGray.setColor(Color.LTGRAY);
				lightGray.setStrokeWidth(10);

				// Ustawianie koloru ta wykresu
				chart.setBackgroundPaint(white);

				final XYPlot plot = chart.getXYPlot();

				plot.setBackgroundPaint(dkGray);
				plot.setDomainGridlinePaint(lightGray);
				plot.setRangeGridlinePaint(lightGray);

				final XYLineAndShapeRenderer renderer = new XYLineAndShapeRenderer();
				renderer.setSeriesLinesVisible(0, true);
				plot.setRenderer(renderer);

				// Ustawianie jednostek osi na liczby cakowite
				final NumberAxis rangeAxis = (NumberAxis) plot.getRangeAxis();
				rangeAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
				// final NumberAxis domainAxis = (NumberAxis) plot.getDomainAxis();
				// domainAxis.set(CategoryLabelPositions.STANDARD);

				return chart;

			}
	}
