package com.examples;

import java.util.ArrayList;

import net.droidsolutions.droidcharts.core.data.XYDataset;
import net.droidsolutions.droidcharts.core.data.xy.XYSeries;
import net.droidsolutions.droidcharts.core.data.xy.XYSeriesCollection;
import android.app.Activity;
import android.content.Intent;
import android.content.res.Configuration;
import android.os.Bundle;
import android.util.Log;
import android.widget.Toast;

public class DemoCharts extends Activity
	{
		private static final String tag = "DemoCharts";
		private final String chartTitle = "Dzienne wydatki na kaw";
		private final String xLabel = "Dzie tygodnia";
		private final String yLabel = "Wydatki";

		/** Wywoywana, gdy aktywno tworzona jest po raz pierwszy */
		@Override
		public void onCreate(Bundle savedInstanceState)
			{
				super.onCreate(savedInstanceState);

				// Dostp do dodatkowych danych z obiektu Bundle
				Bundle params = getIntent().getExtras();

				// Jeli nie ma parametrw, nie trzeba wykonywa adnych operacji
				if (params == null) { return; }

				// Pobieranie wartoci parametrw
				String paramVals = params.getString("param");

				Log.d(tag, "Parametry:= " + paramVals);
				Toast.makeText(getApplicationContext(), "Parametry:= " + paramVals, Toast.LENGTH_LONG).show();

				ArrayList<ArrayList<Double>> dataVals = stringArrayToDouble(paramVals);

				XYDataset dataset = createDataset("Dzienne wydatki na kaw", dataVals);
				XYLineChartView graphView = new XYLineChartView(this, chartTitle, xLabel, yLabel, dataset);
				setContentView(graphView);
			}

		private String arrayToString(String[] data)
			{
				StringBuilder strBuilder = new StringBuilder();
				for (int i = 0; i < data.length; i++)
					{
						strBuilder.append(data[i]);
					}
				return strBuilder.toString();
			}

		private String cleanNumericString(String val)
			{
				return val.replaceAll("\\[", "").replaceAll("\\]", "").trim();
			}

		private ArrayList<ArrayList<Double>> stringArrayToDouble(String paramVals)
			{
				ArrayList<ArrayList<Double>> plotVals = new ArrayList<ArrayList<Double>>();
				if (paramVals.startsWith("[") && paramVals.endsWith("]"))
					{
						String[] vals = paramVals.substring(1, paramVals.length() - 1).split(" , ");
						for (String v : vals)
							{
								if (v.startsWith("[") && v.endsWith("]"))
									{
										String[] dataVals = v.split(",");

										String xvalStr = cleanNumericString(dataVals[0]);
										String yvalStr = cleanNumericString(dataVals[1]);
										Log.d(paramVals, xvalStr + " - " + yvalStr);

										// Przeksztacanie na liczby
										Double x = Double.parseDouble(xvalStr);
										Double y = Double.parseDouble(yvalStr);

										// Tworzenie krotki (x,y)
										ArrayList<Double> list1 = new ArrayList<Double>();
										list1.add(x);
										list1.add(y);

										// Dodawanie do listy
										plotVals.add(list1);
									}
								Log.d(tag, "Wartoci umieszczane na wykresie: " + plotVals.toString());
							}
					}
				return plotVals;
			}

		/**
		 * Tworzenie przykadowych danych
		 * 
		 * @return Przykadowe dane
		 */
		private XYDataset createDataset(String title, ArrayList<ArrayList<Double>> dataVals)
			{
				final XYSeries series1 = new XYSeries(title);
				for (ArrayList<Double> tuple : dataVals)
					{
						double x = tuple.get(0).doubleValue();
						double y = tuple.get(1).doubleValue();

						series1.add(x, y);
					}

				// Tworzenie kolekcji na rne zbiory danych
				final XYSeriesCollection dataset = new XYSeriesCollection();
				dataset.addSeries(series1);
				return dataset;
			}

		@Override
		public void onConfigurationChanged(Configuration newConfig)
			{
				super.onConfigurationChanged(newConfig);
				Toast.makeText(this, "Zmiana orientacji", Toast.LENGTH_SHORT);

				// Powrt do widoku DemoList
				Intent intent = new Intent(this, DemoList.class);
				startActivity(intent);

				// Koczenie aktualnej aktywnoci
				this.finish();
			}
	}