package com.orientation;

import java.util.List;
import android.app.Activity;
import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import android.os.Bundle;
import android.widget.TextView;

public class Orientation extends Activity {
    private TextView orient;
	private Sensor sensor;

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.main);
        orient = (TextView)findViewById(R.id.orient);
        SensorManager sensorManager = (SensorManager)getSystemService(SENSOR_SERVICE);
        List<android.hardware.Sensor> sensorList = sensorManager.getSensorList(Sensor.TYPE_ORIENTATION);
        if (sensorList.size() > 0) {
            sensor = sensorList.get(0);
        }
        else {
        	orient.setText("Brak czujnika orientacji");
        }
        sensorManager.registerListener(orientationListener,sensor, 0, null);
        
    }
    
    private SensorEventListener orientationListener = new SensorEventListener() {

		@Override
		public void onAccuracyChanged(Sensor arg0, int arg1) {
			
		}

		@Override
		public void onSensorChanged(SensorEvent sensorEvent) {
			if (sensorEvent.sensor.getType() == Sensor.TYPE_ORIENTATION) {
				float azimuth = sensorEvent.values[0];
				float pitch = sensorEvent.values[1];
				float roll = sensorEvent.values[2];

				if (pitch < -45 && pitch > -135) {
					
					orient.setText("Grna krawd telefonu jest skierowana w gr");
					
	            } else if (pitch > 45 && pitch < 135) {

	            	orient.setText("Dolna krawd telefonu jest skierowana w gr");

	            } else if (roll > 45) {
	            	
					orient.setText("Prawa krawd telefonu jest skierowana w gr");
					
	            } else if (roll < -45) {

	            	orient.setText("Lewa krawd telefonu jest skierowana w gr");
	            }
				
			}
		}
    	
    };
}