package foo.bt;

import android.app.Activity;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Bundle;
import android.util.Log;
import android.view.View;
import android.view.View.OnClickListener;
import android.widget.ArrayAdapter;
import android.widget.Button;
import android.widget.EditText;
import android.widget.ListView;
import android.widget.Toast;

public class Main extends Activity {
	protected static final String TAG = "bluetoothdemo";
	int REQUEST_ENABLE_BT = 1;
	EditText main;
	private ArrayAdapter<String> mNewDevicesArrayAdapter;
	
    /** Wywoywana, gdy aktywno jest tworzona po raz pierwszy */
    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.main);
        main = (EditText) findViewById(R.id.mainTextArea);
        mNewDevicesArrayAdapter = new ArrayAdapter<String>(this, R.string.app_name);
        
        // Podczanie przycisku wykrywania do komponentu obsugi
        Button discover = (Button) findViewById(R.id.discoverButton);
        discover.setOnClickListener(discoverButtonHandler);
        
        // Podczanie adaptera ArrayAdapter do kontrolki ListView
        ListView lv = (ListView) findViewById(R.id.pairedBtDevices);
        lv.setAdapter(mNewDevicesArrayAdapter);
        
        BluetoothAdapter BT = BluetoothAdapter.getDefaultAdapter();
        if (BT == null) {
        	String noDevMsg = "Urzdzenie nie posiada moduu Bluetooth";
        	main.setText(noDevMsg);
        	Toast.makeText(this, noDevMsg, Toast.LENGTH_LONG).show();
        	return;
        }
        if (!BT.isEnabled()) {
        	// danie wczenia moduu Bluetooth  
        	Intent enableIntent = new Intent(BluetoothAdapter.ACTION_REQUEST_ENABLE);
        	startActivityForResult(enableIntent, REQUEST_ENABLE_BT);
        } 
    }
        
    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
    	if (requestCode==REQUEST_ENABLE_BT) {
    		if (resultCode==Activity.RESULT_OK) {
    			BluetoothAdapter BT = BluetoothAdapter.getDefaultAdapter();
    			String address = BT.getAddress();
    			String name = BT.getName();
    			String connectedMsg = "Bluetooth jest wczony; urzdzenie to "  + name + " : " + address;
    			main.setText(connectedMsg);
    			Toast.makeText(this, connectedMsg, Toast.LENGTH_LONG).show();
    			Button discoverButton = (Button) findViewById(R.id.discoverButton);
    			discoverButton.setOnClickListener(discoverButtonHandler);
    		} else {
    			Toast.makeText(this, "Nie mona wczy moduu Bluetooth!", Toast.LENGTH_LONG).show();
    		}
    	} else {
    		Toast.makeText(this, "Nieznany kod dania " + requestCode, Toast.LENGTH_LONG).show();
    	}
    }
    
    /** Po klikniciu przycisku Wykrywanie uytkownik otrzymuje list sparowanych urzdze
     */
    OnClickListener discoverButtonHandler = new OnClickListener() {
		@Override
		public void onClick(View v) {
			Log.d(TAG, "w metodzie onClick(" + v + ")");
			// Obiekt IntentFilter dla znalezionych urzdze
			IntentFilter foundFilter = new IntentFilter(BluetoothDevice.ACTION_FOUND);
			// Odbiornik rozgoszeniowy dla pasujcych filtrw
			Main.this.registerReceiver(mReceiver, foundFilter);

			IntentFilter doneFilter = new IntentFilter(BluetoothAdapter.ACTION_DISCOVERY_FINISHED);
			Main.this.registerReceiver(mReceiver, doneFilter);
		}
	};
	
	protected void onDestroy() {
		unregisterReceiver(mReceiver);
		super.onDestroy();
	}
    
	/** Odbiornik dla intencji wykrywajcej urzdzenia z Bluetoothem; sparowane
	 *  urzdzenia s wywietlane na licie
	 */
	private final BroadcastReceiver mReceiver = new BroadcastReceiver() {    		
			@Override
    		public void onReceive(Context context, Intent intent) {
				String action = intent.getAction();
				Log.d(TAG, "w metodzie onReceive; akcja = " + action);
    			
    			if (BluetoothDevice.ACTION_FOUND.equals(action)){
    				BluetoothDevice btDevice = intent.getParcelableExtra(BluetoothDevice.EXTRA_DEVICE);
    				
    				if(btDevice.getBondState() != BluetoothDevice.BOND_BONDED){    					
    					mNewDevicesArrayAdapter.add(btDevice.getName()+"\n"+btDevice.getAddress());
    				}
    			}
    			else
    				if (BluetoothAdapter.ACTION_DISCOVERY_FINISHED.equals(action)){
    					setProgressBarIndeterminateVisibility(false);
    					setTitle(R.string.select_device);
    					if (mNewDevicesArrayAdapter.getCount() == 0){
    						String noDevice = getResources().getText(R.string.none_paired).toString();
    						mNewDevicesArrayAdapter.add(noDevice);
    					}
    				}   			
    		}
    	};
}