/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.views.overlay;

import android.graphics.Canvas;
import android.graphics.Point;
import android.view.KeyEvent;
import android.view.Menu;
import android.view.MenuItem;
import android.view.MotionEvent;
import java.util.AbstractList;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.concurrent.CopyOnWriteArrayList;
import org.osmdroid.views.MapView;
import org.osmdroid.views.overlay.IOverlayMenuProvider;
import org.osmdroid.views.overlay.Overlay;
import org.osmdroid.views.overlay.TilesOverlay;

public class OverlayManager
extends AbstractList<Overlay> {
    private TilesOverlay mTilesOverlay;
    private final CopyOnWriteArrayList<Overlay> mOverlayList;

    public OverlayManager(TilesOverlay tilesOverlay) {
        this.setTilesOverlay(tilesOverlay);
        this.mOverlayList = new CopyOnWriteArrayList();
    }

    @Override
    public Overlay get(int pIndex) {
        return this.mOverlayList.get(pIndex);
    }

    @Override
    public int size() {
        return this.mOverlayList.size();
    }

    @Override
    public void add(int pIndex, Overlay pElement) {
        this.mOverlayList.add(pIndex, pElement);
    }

    @Override
    public Overlay remove(int pIndex) {
        return this.mOverlayList.remove(pIndex);
    }

    @Override
    public Overlay set(int pIndex, Overlay pElement) {
        return this.mOverlayList.set(pIndex, pElement);
    }

    public TilesOverlay getTilesOverlay() {
        return this.mTilesOverlay;
    }

    public void setTilesOverlay(TilesOverlay tilesOverlay) {
        this.mTilesOverlay = tilesOverlay;
    }

    public Iterable<Overlay> overlaysReversed() {
        return new Iterable<Overlay>(){

            @Override
            public Iterator<Overlay> iterator() {
                final ListIterator i = OverlayManager.this.mOverlayList.listIterator(OverlayManager.this.mOverlayList.size());
                return new Iterator<Overlay>(){

                    @Override
                    public boolean hasNext() {
                        return i.hasPrevious();
                    }

                    @Override
                    public Overlay next() {
                        return (Overlay)i.previous();
                    }

                    @Override
                    public void remove() {
                        i.remove();
                    }
                };
            }
        };
    }

    public void onDraw(Canvas c, MapView pMapView) {
        if (this.mTilesOverlay != null && this.mTilesOverlay.isEnabled()) {
            this.mTilesOverlay.draw(c, pMapView, true);
        }
        for (Overlay overlay : this.mOverlayList) {
            if (!overlay.isEnabled()) continue;
            overlay.draw(c, pMapView, true);
        }
        if (this.mTilesOverlay != null && this.mTilesOverlay.isEnabled()) {
            this.mTilesOverlay.draw(c, pMapView, false);
        }
        for (Overlay overlay : this.mOverlayList) {
            if (!overlay.isEnabled()) continue;
            overlay.draw(c, pMapView, false);
        }
    }

    public void onDetach(MapView pMapView) {
        if (this.mTilesOverlay != null) {
            this.mTilesOverlay.onDetach(pMapView);
        }
        for (Overlay overlay : this.overlaysReversed()) {
            overlay.onDetach(pMapView);
        }
    }

    public boolean onKeyDown(int keyCode, KeyEvent event, MapView pMapView) {
        for (Overlay overlay : this.overlaysReversed()) {
            if (!overlay.onKeyDown(keyCode, event, pMapView)) continue;
            return true;
        }
        return false;
    }

    public boolean onKeyUp(int keyCode, KeyEvent event, MapView pMapView) {
        for (Overlay overlay : this.overlaysReversed()) {
            if (!overlay.onKeyUp(keyCode, event, pMapView)) continue;
            return true;
        }
        return false;
    }

    public boolean onTouchEvent(MotionEvent event, MapView pMapView) {
        for (Overlay overlay : this.overlaysReversed()) {
            if (!overlay.onTouchEvent(event, pMapView)) continue;
            return true;
        }
        return false;
    }

    public boolean onTrackballEvent(MotionEvent event, MapView pMapView) {
        for (Overlay overlay : this.overlaysReversed()) {
            if (!overlay.onTrackballEvent(event, pMapView)) continue;
            return true;
        }
        return false;
    }

    public boolean onSnapToItem(int x, int y, Point snapPoint, MapView pMapView) {
        for (Overlay overlay : this.overlaysReversed()) {
            if (!(overlay instanceof Overlay.Snappable) || !((Overlay.Snappable)((Object)overlay)).onSnapToItem(x, y, snapPoint, pMapView)) continue;
            return true;
        }
        return false;
    }

    public boolean onDoubleTap(MotionEvent e, MapView pMapView) {
        for (Overlay overlay : this.overlaysReversed()) {
            if (!overlay.onDoubleTap(e, pMapView)) continue;
            return true;
        }
        return false;
    }

    public boolean onDoubleTapEvent(MotionEvent e, MapView pMapView) {
        for (Overlay overlay : this.overlaysReversed()) {
            if (!overlay.onDoubleTapEvent(e, pMapView)) continue;
            return true;
        }
        return false;
    }

    public boolean onSingleTapConfirmed(MotionEvent e, MapView pMapView) {
        for (Overlay overlay : this.overlaysReversed()) {
            if (!overlay.onSingleTapConfirmed(e, pMapView)) continue;
            return true;
        }
        return false;
    }

    public boolean onDown(MotionEvent pEvent, MapView pMapView) {
        for (Overlay overlay : this.overlaysReversed()) {
            if (!overlay.onDown(pEvent, pMapView)) continue;
            return true;
        }
        return false;
    }

    public boolean onFling(MotionEvent pEvent1, MotionEvent pEvent2, float pVelocityX, float pVelocityY, MapView pMapView) {
        for (Overlay overlay : this.overlaysReversed()) {
            if (!overlay.onFling(pEvent1, pEvent2, pVelocityX, pVelocityY, pMapView)) continue;
            return true;
        }
        return false;
    }

    public boolean onLongPress(MotionEvent pEvent, MapView pMapView) {
        for (Overlay overlay : this.overlaysReversed()) {
            if (!overlay.onLongPress(pEvent, pMapView)) continue;
            return true;
        }
        return false;
    }

    public boolean onScroll(MotionEvent pEvent1, MotionEvent pEvent2, float pDistanceX, float pDistanceY, MapView pMapView) {
        for (Overlay overlay : this.overlaysReversed()) {
            if (!overlay.onScroll(pEvent1, pEvent2, pDistanceX, pDistanceY, pMapView)) continue;
            return true;
        }
        return false;
    }

    public void onShowPress(MotionEvent pEvent, MapView pMapView) {
        for (Overlay overlay : this.overlaysReversed()) {
            overlay.onShowPress(pEvent, pMapView);
        }
    }

    public boolean onSingleTapUp(MotionEvent pEvent, MapView pMapView) {
        for (Overlay overlay : this.overlaysReversed()) {
            if (!overlay.onSingleTapUp(pEvent, pMapView)) continue;
            return true;
        }
        return false;
    }

    public void setOptionsMenusEnabled(boolean pEnabled) {
        for (Overlay overlay : this.mOverlayList) {
            if (!(overlay instanceof IOverlayMenuProvider) || !((IOverlayMenuProvider)((Object)overlay)).isOptionsMenuEnabled()) continue;
            ((IOverlayMenuProvider)((Object)overlay)).setOptionsMenuEnabled(pEnabled);
        }
    }

    public boolean onCreateOptionsMenu(Menu pMenu, int menuIdOffset, MapView mapView) {
        boolean result = true;
        for (Overlay overlay : this.overlaysReversed()) {
            if (!(overlay instanceof IOverlayMenuProvider) || !((IOverlayMenuProvider)((Object)overlay)).isOptionsMenuEnabled()) continue;
            result &= ((IOverlayMenuProvider)((Object)overlay)).onCreateOptionsMenu(pMenu, menuIdOffset, mapView);
        }
        if (this.mTilesOverlay != null && this.mTilesOverlay instanceof IOverlayMenuProvider && this.mTilesOverlay.isOptionsMenuEnabled()) {
            result &= this.mTilesOverlay.onCreateOptionsMenu(pMenu, menuIdOffset, mapView);
        }
        return result;
    }

    public boolean onPrepareOptionsMenu(Menu pMenu, int menuIdOffset, MapView mapView) {
        for (Overlay overlay : this.overlaysReversed()) {
            if (!(overlay instanceof IOverlayMenuProvider) || !((IOverlayMenuProvider)((Object)overlay)).isOptionsMenuEnabled()) continue;
            ((IOverlayMenuProvider)((Object)overlay)).onPrepareOptionsMenu(pMenu, menuIdOffset, mapView);
        }
        if (this.mTilesOverlay != null && this.mTilesOverlay instanceof IOverlayMenuProvider && this.mTilesOverlay.isOptionsMenuEnabled()) {
            this.mTilesOverlay.onPrepareOptionsMenu(pMenu, menuIdOffset, mapView);
        }
        return true;
    }

    public boolean onOptionsItemSelected(MenuItem item, int menuIdOffset, MapView mapView) {
        for (Overlay overlay : this.overlaysReversed()) {
            if (!(overlay instanceof IOverlayMenuProvider) || !((IOverlayMenuProvider)((Object)overlay)).isOptionsMenuEnabled() || !((IOverlayMenuProvider)((Object)overlay)).onOptionsItemSelected(item, menuIdOffset, mapView)) continue;
            return true;
        }
        return this.mTilesOverlay != null && this.mTilesOverlay instanceof IOverlayMenuProvider && this.mTilesOverlay.isOptionsMenuEnabled() && this.mTilesOverlay.onOptionsItemSelected(item, menuIdOffset, mapView);
    }
}

