/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.views.overlay;

import android.app.Activity;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Picture;
import android.graphics.Rect;
import android.os.Build;
import java.lang.reflect.Field;
import org.osmdroid.DefaultResourceProxyImpl;
import org.osmdroid.ResourceProxy;
import org.osmdroid.api.IGeoPoint;
import org.osmdroid.util.GeoPoint;
import org.osmdroid.util.constants.GeoConstants;
import org.osmdroid.views.MapView;
import org.osmdroid.views.overlay.Overlay;

public class ScaleBarOverlay
extends Overlay
implements GeoConstants {
    float xOffset = 10.0f;
    float yOffset = 10.0f;
    float lineWidth = 2.0f;
    final int textSize = 12;
    int minZoom = 0;
    boolean imperial = false;
    boolean nautical = false;
    boolean latitudeBar = true;
    boolean longitudeBar = false;
    private final Activity activity;
    protected final Picture scaleBarPicture = new Picture();
    private int lastZoomLevel = -1;
    private float lastLatitude = 0.0f;
    public float xdpi;
    public float ydpi;
    public int screenWidth;
    public int screenHeight;
    private final ResourceProxy resourceProxy;
    private Paint barPaint;
    private Paint textPaint;
    private MapView.Projection projection;
    private final Rect mBounds = new Rect();

    public ScaleBarOverlay(Activity activity) {
        this(activity, new DefaultResourceProxyImpl((Context)activity));
    }

    public ScaleBarOverlay(Activity activity, ResourceProxy pResourceProxy) {
        super(pResourceProxy);
        this.resourceProxy = pResourceProxy;
        this.activity = activity;
        this.barPaint = new Paint();
        this.barPaint.setColor(-16777216);
        this.barPaint.setAntiAlias(true);
        this.barPaint.setStyle(Paint.Style.FILL);
        this.barPaint.setAlpha(255);
        this.textPaint = new Paint();
        this.textPaint.setColor(-16777216);
        this.textPaint.setAntiAlias(true);
        this.textPaint.setStyle(Paint.Style.FILL);
        this.textPaint.setAlpha(255);
        this.textPaint.setTextSize(12.0f);
        this.xdpi = this.activity.getResources().getDisplayMetrics().xdpi;
        this.ydpi = this.activity.getResources().getDisplayMetrics().ydpi;
        this.screenWidth = this.activity.getResources().getDisplayMetrics().widthPixels;
        this.screenHeight = this.activity.getResources().getDisplayMetrics().heightPixels;
        String manufacturer = null;
        try {
            Field field = Build.class.getField("MANUFACTURER");
            manufacturer = (String)field.get(null);
        }
        catch (Exception ignore) {
            // empty catch block
        }
        if ("motorola".equals(manufacturer) && "DROIDX".equals(Build.MODEL)) {
            if (activity.getWindowManager().getDefaultDisplay().getOrientation() > 0) {
                this.xdpi = (float)((double)this.screenWidth / 3.75);
                this.ydpi = (float)((double)this.screenHeight / 2.1);
            } else {
                this.xdpi = (float)((double)this.screenWidth / 2.1);
                this.ydpi = (float)((double)this.screenHeight / 3.75);
            }
        } else if ("motorola".equals(manufacturer) && "Droid".equals(Build.MODEL)) {
            this.xdpi = 264.0f;
            this.ydpi = 264.0f;
        }
    }

    public void setMinZoom(int zoom) {
        this.minZoom = zoom;
    }

    public void setScaleBarOffset(float x, float y) {
        this.xOffset = x;
        this.yOffset = y;
    }

    public void setLineWidth(float width) {
        this.lineWidth = width;
    }

    public void setTextSize(float size) {
        this.textPaint.setTextSize(size);
    }

    public void setImperial() {
        this.imperial = true;
        this.nautical = false;
        this.lastZoomLevel = -1;
    }

    public void setNautical() {
        this.nautical = true;
        this.imperial = false;
        this.lastZoomLevel = -1;
    }

    public void setMetric() {
        this.nautical = false;
        this.imperial = false;
        this.lastZoomLevel = -1;
    }

    public void drawLatitudeScale(boolean latitude) {
        this.latitudeBar = latitude;
    }

    public void drawLongitudeScale(boolean longitude) {
        this.longitudeBar = longitude;
    }

    public Paint getBarPaint() {
        return this.barPaint;
    }

    public void setBarPaint(Paint pBarPaint) {
        if (pBarPaint == null) {
            throw new IllegalArgumentException("pBarPaint argument cannot be null");
        }
        this.barPaint = pBarPaint;
    }

    public Paint getTextPaint() {
        return this.textPaint;
    }

    public void setTextPaint(Paint pTextPaint) {
        if (pTextPaint == null) {
            throw new IllegalArgumentException("pTextPaint argument cannot be null");
        }
        this.textPaint = pTextPaint;
    }

    @Override
    public void draw(Canvas c, MapView mapView, boolean shadow) {
        if (shadow) {
            return;
        }
        if (mapView.isAnimating()) {
            return;
        }
        int zoomLevel = mapView.getZoomLevel();
        if (zoomLevel >= this.minZoom) {
            MapView.Projection projection = mapView.getProjection();
            if (projection == null) {
                return;
            }
            IGeoPoint center = projection.fromPixels(this.screenWidth / 2, this.screenHeight / 2);
            if (zoomLevel != this.lastZoomLevel || (int)((double)center.getLatitudeE6() / 1000000.0) != (int)((double)this.lastLatitude / 1000000.0)) {
                this.lastZoomLevel = zoomLevel;
                this.lastLatitude = center.getLatitudeE6();
                this.createScaleBarPicture(mapView);
            }
            this.mBounds.set(projection.getScreenRect());
            this.mBounds.offset((int)this.xOffset, (int)this.yOffset);
            this.mBounds.set(this.mBounds.left, this.mBounds.top, this.mBounds.left + this.scaleBarPicture.getWidth(), this.mBounds.top + this.scaleBarPicture.getHeight());
            c.drawPicture(this.scaleBarPicture, this.mBounds);
        }
    }

    public void disableScaleBar() {
        this.setEnabled(false);
    }

    public void enableScaleBar() {
        this.setEnabled(true);
    }

    private void createScaleBarPicture(MapView mapView) {
        int textSpacing;
        this.projection = mapView.getProjection();
        if (this.projection == null) {
            return;
        }
        IGeoPoint p1 = this.projection.fromPixels((float)(this.screenWidth / 2) - this.xdpi / 2.0f, (float)(this.screenHeight / 2));
        IGeoPoint p2 = this.projection.fromPixels((float)(this.screenWidth / 2) + this.xdpi / 2.0f, (float)(this.screenHeight / 2));
        int xMetersPerInch = ((GeoPoint)p1).distanceTo(p2);
        p1 = this.projection.fromPixels((float)(this.screenWidth / 2), (float)(this.screenHeight / 2) - this.ydpi / 2.0f);
        p2 = this.projection.fromPixels((float)(this.screenWidth / 2), (float)(this.screenHeight / 2) + this.ydpi / 2.0f);
        int yMetersPerInch = ((GeoPoint)p1).distanceTo(p2);
        Canvas canvas = this.scaleBarPicture.beginRecording((int)this.xdpi, (int)this.ydpi);
        if (this.latitudeBar) {
            String xMsg = this.scaleBarLengthText(xMetersPerInch, this.imperial, this.nautical);
            Rect xTextRect = new Rect();
            this.textPaint.getTextBounds(xMsg, 0, xMsg.length(), xTextRect);
            textSpacing = (int)((double)xTextRect.height() / 5.0);
            canvas.drawRect(0.0f, 0.0f, this.xdpi, this.lineWidth, this.barPaint);
            canvas.drawRect(this.xdpi, 0.0f, this.xdpi + this.lineWidth, (float)xTextRect.height() + this.lineWidth + (float)textSpacing, this.barPaint);
            if (!this.longitudeBar) {
                canvas.drawRect(0.0f, 0.0f, this.lineWidth, (float)xTextRect.height() + this.lineWidth + (float)textSpacing, this.barPaint);
            }
            canvas.drawText(xMsg, this.xdpi / 2.0f - (float)(xTextRect.width() / 2), (float)xTextRect.height() + this.lineWidth + (float)textSpacing, this.textPaint);
        }
        if (this.longitudeBar) {
            String yMsg = this.scaleBarLengthText(yMetersPerInch, this.imperial, this.nautical);
            Rect yTextRect = new Rect();
            this.textPaint.getTextBounds(yMsg, 0, yMsg.length(), yTextRect);
            textSpacing = (int)((double)yTextRect.height() / 5.0);
            canvas.drawRect(0.0f, 0.0f, this.lineWidth, this.ydpi, this.barPaint);
            canvas.drawRect(0.0f, this.ydpi, (float)yTextRect.height() + this.lineWidth + (float)textSpacing, this.ydpi + this.lineWidth, this.barPaint);
            if (!this.latitudeBar) {
                canvas.drawRect(0.0f, 0.0f, (float)yTextRect.height() + this.lineWidth + (float)textSpacing, this.lineWidth, this.barPaint);
            }
            float x = (float)yTextRect.height() + this.lineWidth + (float)textSpacing;
            float y = this.ydpi / 2.0f + (float)(yTextRect.width() / 2);
            canvas.rotate(-90.0f, x, y);
            canvas.drawText(yMsg, x, y + (float)textSpacing, this.textPaint);
        }
        this.scaleBarPicture.endRecording();
    }

    private String scaleBarLengthText(int meters, boolean imperial, boolean nautical) {
        if (this.imperial) {
            if ((double)meters >= 8046.72) {
                return this.resourceProxy.getString(ResourceProxy.string.format_distance_miles, (int)((double)meters / 1609.344));
            }
            if ((double)meters >= 321.8688) {
                return this.resourceProxy.getString(ResourceProxy.string.format_distance_miles, (double)((int)((double)meters / 160.9344)) / 10.0);
            }
            return this.resourceProxy.getString(ResourceProxy.string.format_distance_feet, (int)((double)meters * 3.2808399));
        }
        if (this.nautical) {
            if ((double)meters >= 9260.0) {
                return this.resourceProxy.getString(ResourceProxy.string.format_distance_nautical_miles, (int)((double)meters / 1852.0));
            }
            if ((double)meters >= 370.4) {
                return this.resourceProxy.getString(ResourceProxy.string.format_distance_nautical_miles, (double)((int)((double)meters / 185.2)) / 10.0);
            }
            return this.resourceProxy.getString(ResourceProxy.string.format_distance_feet, (int)((double)meters * 3.2808399));
        }
        if (meters >= 5000) {
            return this.resourceProxy.getString(ResourceProxy.string.format_distance_kilometers, meters / 1000);
        }
        if (meters >= 200) {
            return this.resourceProxy.getString(ResourceProxy.string.format_distance_kilometers, (double)((int)((double)meters / 100.0)) / 10.0);
        }
        return this.resourceProxy.getString(ResourceProxy.string.format_distance_meters, meters);
    }
}

