/*
 * Decompiled with CFR 0.152.
 */
package com.androidplot.util;

import android.graphics.PointF;
import android.graphics.RectF;

public class ValPixConverter {
    public static float valToPix(double d, double d2, double d3, float f, boolean bl) {
        if (f <= 0.0f) {
            throw new IllegalArgumentException("Length in pixels must be greater than 0.");
        }
        double d4 = ValPixConverter.range(d2, d3);
        double d5 = (double)f / d4;
        double d6 = d - d2;
        float f2 = (float)(d6 * d5);
        if (bl) {
            f2 = f - f2;
        }
        return f2;
    }

    public static double range(double d, double d2) {
        return d2 - d;
    }

    public static double valPerPix(double d, double d2, float f) {
        double d3 = ValPixConverter.range(d, d2);
        return d3 / (double)f;
    }

    public static double pixToVal(float f, double d, double d2, float f2, boolean bl) {
        if (f < 0.0f) {
            throw new IllegalArgumentException("pixel values cannot be negative.");
        }
        if (f2 <= 0.0f) {
            throw new IllegalArgumentException("Length in pixels must be greater than 0.");
        }
        float f3 = f;
        if (bl) {
            f3 = f2 - f;
        }
        double d3 = ValPixConverter.range(d, d2);
        return d3 / (double)f2 * (double)f3 + d;
    }

    public static PointF valToPix(Number number, Number number2, RectF rectF, Number number3, Number number4, Number number5, Number number6) {
        float f = ValPixConverter.valToPix(number.doubleValue(), number3.doubleValue(), number4.doubleValue(), rectF.width(), false) + rectF.left;
        float f2 = ValPixConverter.valToPix(number2.doubleValue(), number5.doubleValue(), number6.doubleValue(), rectF.height(), true) + rectF.top;
        return new PointF(f, f2);
    }
}

