/*
 * Decompiled with CFR 0.152.
 */
package com.androidplot.ui.layout;

import com.androidplot.ui.layout.a;

public abstract class PositionMetric<LayoutType extends Enum>
extends a<LayoutType> {
    public PositionMetric(float f, LayoutType LayoutType) {
        super(f, LayoutType);
    }

    protected static void a(float f, LayoutMode layoutMode) throws IllegalArgumentException {
        switch (layoutMode) {
            case ABSOLUTE: {
                return;
            }
            case RELATIVE: {
                if (!(f < -1.0f) && !(f > 1.0f)) break;
                throw new IllegalArgumentException("Relative layout values must be within the range of -1 to 1.");
            }
            default: {
                throw new IllegalArgumentException("Unknown LayoutMode: " + (Object)((Object)layoutMode));
            }
        }
    }

    protected final float a(float f, Origin origin) {
        switch (origin) {
            case FROM_BEGINING: {
                return this.getValue();
            }
            case FROM_CENTER: {
                return f / 2.0f + this.getValue();
            }
            case FROM_END: {
                return f - this.getValue();
            }
        }
        throw new IllegalArgumentException("Unsupported Origin: " + (Object)((Object)origin));
    }

    protected final float b(float f, Origin origin) {
        switch (origin) {
            case FROM_BEGINING: {
                return f * this.getValue();
            }
            case FROM_CENTER: {
                return f / 2.0f + f / 2.0f * this.getValue();
            }
            case FROM_END: {
                return f + f * this.getValue();
            }
        }
        throw new IllegalArgumentException("Unsupported Origin: " + (Object)((Object)origin));
    }

    protected static enum LayoutMode {
        ABSOLUTE,
        RELATIVE;

    }

    protected static enum Origin {
        FROM_BEGINING,
        FROM_CENTER,
        FROM_END;

    }
}

