/*
 * Decompiled with CFR 0.152.
 */
package org.achartengine.chart;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import java.io.Serializable;
import org.achartengine.renderer.DefaultRenderer;
import org.achartengine.renderer.SimpleSeriesRenderer;
import org.achartengine.renderer.XYMultipleSeriesRenderer;

public abstract class AbstractChart
implements Serializable {
    public abstract void draw(Canvas var1, int var2, int var3, int var4, int var5);

    protected void drawBackground(DefaultRenderer defaultRenderer, Canvas canvas, int n, int n2, int n3, int n4, Paint paint) {
        if (defaultRenderer.isApplyBackgroundColor()) {
            paint.setColor(defaultRenderer.getBackgroundColor());
            paint.setStyle(Paint.Style.FILL);
            canvas.drawRect((float)n, (float)n2, (float)(n + n3), (float)(n2 + n4), paint);
        }
    }

    protected void drawLegend(Canvas canvas, DefaultRenderer defaultRenderer, String[] stringArray, int n, int n2, int n3, int n4, int n5, int n6, Paint paint) {
        if (defaultRenderer.isShowLegend()) {
            float f = n;
            float f2 = n3 + n5 - n6 + 32;
            float f3 = this.getLegendShapeWidth();
            paint.setTextAlign(Paint.Align.LEFT);
            paint.setTextSize(defaultRenderer.getLegendTextSize());
            int n7 = Math.min(stringArray.length, defaultRenderer.getSeriesRendererCount());
            for (int i = 0; i < n7; ++i) {
                String string = stringArray[i];
                if (stringArray.length == defaultRenderer.getSeriesRendererCount()) {
                    paint.setColor(defaultRenderer.getSeriesRendererAt(i).getColor());
                } else {
                    paint.setColor(-3355444);
                }
                float[] fArray = new float[string.length()];
                paint.getTextWidths(string, fArray);
                float f4 = 0.0f;
                for (float f5 : fArray) {
                    f4 += f5;
                }
                float f6 = f3 + 10.0f + f4;
                float f7 = f + f6;
                if (i > 0 && this.getExceed(f7, defaultRenderer, n2, n4)) {
                    f = n;
                    f2 += 15.0f;
                    f7 = f + f6;
                }
                if (this.getExceed(f7, defaultRenderer, n2, n4)) {
                    float f8 = (float)n2 - f - f3 - 10.0f;
                    if (this.isVertical(defaultRenderer)) {
                        f8 = (float)n4 - f - f3 - 10.0f;
                    }
                    int n8 = paint.breakText(string, true, f8, fArray);
                    string = string.substring(0, n8) + "...";
                }
                this.drawLegendShape(canvas, defaultRenderer.getSeriesRendererAt(i), f, f2, paint);
                canvas.drawText(string, f + f3 + 5.0f, f2 + 5.0f, paint);
                f += f6;
            }
        }
    }

    private boolean getExceed(float f, DefaultRenderer defaultRenderer, int n, int n2) {
        boolean bl;
        boolean bl2 = bl = f > (float)n;
        if (this.isVertical(defaultRenderer)) {
            bl = f > (float)n2;
        }
        return bl;
    }

    private boolean isVertical(DefaultRenderer defaultRenderer) {
        return defaultRenderer instanceof XYMultipleSeriesRenderer && ((XYMultipleSeriesRenderer)defaultRenderer).getOrientation() == XYMultipleSeriesRenderer.Orientation.VERTICAL;
    }

    protected void drawPath(Canvas canvas, float[] fArray, Paint paint, boolean bl) {
        Path path = new Path();
        path.moveTo(fArray[0], fArray[1]);
        for (int i = 2; i < fArray.length; i += 2) {
            path.lineTo(fArray[i], fArray[i + 1]);
        }
        if (bl) {
            path.lineTo(fArray[0], fArray[1]);
        }
        canvas.drawPath(path, paint);
    }

    public abstract int getLegendShapeWidth();

    public abstract void drawLegendShape(Canvas var1, SimpleSeriesRenderer var2, float var3, float var4, Paint var5);
}

