/*
 * Decompiled with CFR 0.152.
 */
package net.droidsolutions.droidcharts.core.text;

import android.graphics.Canvas;
import android.graphics.Paint;
import java.io.Serializable;
import net.droidsolutions.droidcharts.awt.Font;
import net.droidsolutions.droidcharts.awt.Rectangle2D;
import net.droidsolutions.droidcharts.common.RefineryUtilities;
import net.droidsolutions.droidcharts.common.Size2D;
import net.droidsolutions.droidcharts.common.TextAnchor;
import net.droidsolutions.droidcharts.core.text.TextUtilities;

public class TextFragment
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final Font DEFAULT_FONT = new Font("Serif", 1, 12);
    public static final Paint DEFAULT_PAINT = new Paint(1);
    private String text;
    private Font font;
    private Paint paint;

    static {
        DEFAULT_PAINT.setARGB(0, 0, 0, 0);
    }

    public TextFragment(String text) {
        this(text, DEFAULT_FONT, DEFAULT_PAINT);
    }

    public TextFragment(String text, Font font) {
        this(text, font, DEFAULT_PAINT);
    }

    public TextFragment(String text, Font font, Paint paint) {
        if (text == null) {
            throw new IllegalArgumentException("Null 'text' argument.");
        }
        if (font == null) {
            throw new IllegalArgumentException("Null 'font' argument.");
        }
        if (paint == null) {
            throw new IllegalArgumentException("Null 'paint' argument.");
        }
        this.text = text;
        this.font = font;
        this.paint = paint;
    }

    public String getText() {
        return this.text;
    }

    public Font getFont() {
        return this.font;
    }

    public Paint getPaint() {
        return this.paint;
    }

    public void draw(Canvas g2, float anchorX, float anchorY, TextAnchor anchor, float rotateX, float rotateY, double angle, Paint paint) {
        RefineryUtilities.drawRotatedString(this.text, g2, anchorX, anchorY, paint, (float)angle);
    }

    public Size2D calculateDimensions(Canvas g2) {
        Rectangle2D rec = TextUtilities.getTextBounds(this.text, this.paint);
        return new Size2D(rec.getWidth(), rec.getHeight());
    }

    public float calculateBaselineOffset(Canvas g2, TextAnchor anchor) {
        return 0.0f;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj instanceof TextFragment) {
            TextFragment tf = (TextFragment)obj;
            if (!this.text.equals(tf.text)) {
                return false;
            }
            if (!this.font.equals(tf.font)) {
                return false;
            }
            return this.paint.equals(tf.paint);
        }
        return false;
    }
}

