/*
 * Decompiled with CFR 0.152.
 */
package net.droidsolutions.droidcharts.core.text;

import android.graphics.Canvas;
import android.graphics.Paint;
import java.io.Serializable;
import net.droidsolutions.droidcharts.awt.Font;
import net.droidsolutions.droidcharts.awt.Rectangle2D;
import net.droidsolutions.droidcharts.common.RectangleAnchor;
import net.droidsolutions.droidcharts.common.RectangleInsets;
import net.droidsolutions.droidcharts.common.Size2D;
import net.droidsolutions.droidcharts.core.text.TextBlock;
import net.droidsolutions.droidcharts.core.text.TextBlockAnchor;

public class TextBox
implements Serializable {
    private static final Paint BLACK = new Paint(1);
    private static final Paint GRAY;
    private static final Paint WHITE;
    private static final long serialVersionUID = 3360220213180203706L;
    private transient Paint outlinePaint = BLACK;
    private transient Float outlineStroke = Float.valueOf(1.0f);
    private RectangleInsets interiorGap = new RectangleInsets(1.0, 3.0, 1.0, 3.0);
    private transient Paint backgroundPaint = WHITE;
    private transient Paint shadowPaint = GRAY;
    private double shadowXOffset = 2.0;
    private double shadowYOffset = 2.0;
    private TextBlock textBlock;

    static {
        BLACK.setColor(-16777216);
        GRAY = new Paint(1);
        GRAY.setColor(-7829368);
        WHITE = new Paint(1);
        WHITE.setColor(-1);
    }

    public TextBox() {
        this((TextBlock)null);
    }

    public TextBox(String text) {
        this((TextBlock)null);
        if (text != null) {
            this.textBlock = new TextBlock();
            this.textBlock.addLine(text, new Font("SansSerif", 0, 10), BLACK);
        }
    }

    public TextBox(TextBlock block) {
        this.textBlock = block;
    }

    public Paint getOutlinePaint() {
        return this.outlinePaint;
    }

    public void setOutlinePaint(Paint paint) {
        this.outlinePaint = paint;
    }

    public Float getOutlineStroke() {
        return this.outlineStroke;
    }

    public void setOutlineStroke(Float stroke) {
        this.outlineStroke = stroke;
    }

    public RectangleInsets getInteriorGap() {
        return this.interiorGap;
    }

    public void setInteriorGap(RectangleInsets gap) {
        this.interiorGap = gap;
    }

    public Paint getBackgroundPaint() {
        return this.backgroundPaint;
    }

    public void setBackgroundPaint(Paint paint) {
        this.backgroundPaint = paint;
    }

    public Paint getShadowPaint() {
        return this.shadowPaint;
    }

    public void setShadowPaint(Paint paint) {
        this.shadowPaint = paint;
    }

    public double getShadowXOffset() {
        return this.shadowXOffset;
    }

    public void setShadowXOffset(double offset) {
        this.shadowXOffset = offset;
    }

    public double getShadowYOffset() {
        return this.shadowYOffset;
    }

    public void setShadowYOffset(double offset) {
        this.shadowYOffset = offset;
    }

    public TextBlock getTextBlock() {
        return this.textBlock;
    }

    public void setTextBlock(TextBlock block) {
        this.textBlock = block;
    }

    public void draw(Canvas g2, float x, float y, RectangleAnchor anchor) {
        Size2D d1 = this.textBlock.calculateDimensions(g2);
        double w = this.interiorGap.extendWidth(d1.getWidth());
        double h = this.interiorGap.extendHeight(d1.getHeight());
        Size2D d2 = new Size2D(w, h);
        Rectangle2D bounds = RectangleAnchor.createRectangle(d2, x, y, anchor);
        if (this.shadowPaint != null) {
            Rectangle2D.Double shadow = new Rectangle2D.Double(bounds.getX() + this.shadowXOffset, bounds.getY() + this.shadowYOffset, bounds.getWidth(), bounds.getHeight());
            this.shadowPaint.setStyle(Paint.Style.FILL);
            g2.drawRect((float)shadow.getMinX(), (float)shadow.getMinY(), (float)shadow.getMaxX(), (float)shadow.getMaxY(), this.shadowPaint);
        }
        if (this.backgroundPaint != null) {
            this.backgroundPaint.setStyle(Paint.Style.FILL);
            g2.drawRect((float)bounds.getMinX(), (float)bounds.getMinY(), (float)bounds.getMaxX(), (float)bounds.getMaxY(), this.backgroundPaint);
        }
        if (this.outlinePaint != null && this.outlineStroke != null) {
            this.outlinePaint.setStyle(Paint.Style.STROKE);
            this.outlinePaint.setStrokeWidth(this.outlineStroke.floatValue());
            g2.drawRect((float)bounds.getMinX(), (float)bounds.getMinY(), (float)bounds.getMaxX(), (float)bounds.getMaxY(), this.outlinePaint);
        }
        this.textBlock.draw(g2, (float)bounds.getCenterX(), (float)bounds.getCenterY(), TextBlockAnchor.CENTER, BLACK);
    }

    public double getHeight(Canvas g2) {
        Size2D d = this.textBlock.calculateDimensions(g2);
        return this.interiorGap.extendHeight(d.getHeight());
    }
}

