/*
 * Decompiled with CFR 0.152.
 */
package net.droidsolutions.droidcharts.core.plot;

import android.graphics.Canvas;
import android.graphics.Paint;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import net.droidsolutions.droidcharts.awt.Line2D;
import net.droidsolutions.droidcharts.awt.Point2D;
import net.droidsolutions.droidcharts.awt.Rectangle2D;
import net.droidsolutions.droidcharts.common.Layer;
import net.droidsolutions.droidcharts.common.ObjectList;
import net.droidsolutions.droidcharts.common.RectangleEdge;
import net.droidsolutions.droidcharts.common.RectangleInsets;
import net.droidsolutions.droidcharts.core.LegendItem;
import net.droidsolutions.droidcharts.core.LegendItemCollection;
import net.droidsolutions.droidcharts.core.anotations.XYAnnotation;
import net.droidsolutions.droidcharts.core.anotations.XYAnnotationBoundsInfo;
import net.droidsolutions.droidcharts.core.axis.Axis;
import net.droidsolutions.droidcharts.core.axis.AxisCollection;
import net.droidsolutions.droidcharts.core.axis.AxisLocation;
import net.droidsolutions.droidcharts.core.axis.AxisSpace;
import net.droidsolutions.droidcharts.core.axis.AxisState;
import net.droidsolutions.droidcharts.core.axis.TickType;
import net.droidsolutions.droidcharts.core.axis.ValueAxis;
import net.droidsolutions.droidcharts.core.axis.ValueTick;
import net.droidsolutions.droidcharts.core.data.Range;
import net.droidsolutions.droidcharts.core.data.XYDataset;
import net.droidsolutions.droidcharts.core.data.general.DatasetUtilities;
import net.droidsolutions.droidcharts.core.event.RendererChangeEvent;
import net.droidsolutions.droidcharts.core.event.RendererChangeListener;
import net.droidsolutions.droidcharts.core.plot.CrosshairState;
import net.droidsolutions.droidcharts.core.plot.DatasetRenderingOrder;
import net.droidsolutions.droidcharts.core.plot.Marker;
import net.droidsolutions.droidcharts.core.plot.Pannable;
import net.droidsolutions.droidcharts.core.plot.Plot;
import net.droidsolutions.droidcharts.core.plot.PlotOrientation;
import net.droidsolutions.droidcharts.core.plot.PlotRenderingInfo;
import net.droidsolutions.droidcharts.core.plot.PlotState;
import net.droidsolutions.droidcharts.core.plot.SeriesRenderingOrder;
import net.droidsolutions.droidcharts.core.plot.ValueAxisPlot;
import net.droidsolutions.droidcharts.core.plot.Zoomable;
import net.droidsolutions.droidcharts.core.renderer.RendererUtilities;
import net.droidsolutions.droidcharts.core.renderer.xy.AbstractXYItemRenderer;
import net.droidsolutions.droidcharts.core.renderer.xy.XYItemRenderer;
import net.droidsolutions.droidcharts.core.renderer.xy.XYItemRendererState;

public class XYPlot
extends Plot
implements ValueAxisPlot,
Pannable,
Zoomable,
RendererChangeListener,
Cloneable {
    private static final long serialVersionUID = 7044148245716569264L;
    public static final Float DEFAULT_GRIDLINE_STROKE = Float.valueOf(1.0f);
    public static final Paint DEFAULT_GRIDLINE_PAINT = new Paint(1);
    public static final boolean DEFAULT_CROSSHAIR_VISIBLE = false;
    public static final Float DEFAULT_CROSSHAIR_STROKE;
    public static final Paint DEFAULT_CROSSHAIR_PAINT;
    private PlotOrientation orientation;
    private RectangleInsets axisOffset;
    private ObjectList domainAxes;
    private ObjectList domainAxisLocations;
    private ObjectList rangeAxes;
    private ObjectList rangeAxisLocations;
    private ObjectList datasets;
    private ObjectList renderers;
    private Map datasetToDomainAxesMap;
    private Map datasetToRangeAxesMap;
    private transient Point2D quadrantOrigin = new Point2D.Double(0.0, 0.0);
    private transient Paint[] quadrantPaint = new Paint[4];
    private boolean domainGridlinesVisible;
    private transient Float domainGridlineStroke;
    private transient Paint domainGridlinePaint;
    private boolean rangeGridlinesVisible;
    private transient Float rangeGridlineStroke;
    private transient Paint rangeGridlinePaint;
    private boolean domainMinorGridlinesVisible;
    private transient Float domainMinorGridlineStroke;
    private transient Paint domainMinorGridlinePaint;
    private boolean rangeMinorGridlinesVisible;
    private transient Float rangeMinorGridlineStroke;
    private transient Paint rangeMinorGridlinePaint;
    private boolean domainZeroBaselineVisible;
    private transient Float domainZeroBaselineStroke;
    private transient Paint domainZeroBaselinePaint;
    private boolean rangeZeroBaselineVisible;
    private transient Float rangeZeroBaselineStroke;
    private transient Paint rangeZeroBaselinePaint;
    private boolean domainCrosshairVisible;
    private double domainCrosshairValue;
    private transient Float domainCrosshairStroke;
    private transient Paint domainCrosshairPaint;
    private boolean domainCrosshairLockedOnData = true;
    private boolean rangeCrosshairVisible;
    private double rangeCrosshairValue;
    private transient Float rangeCrosshairStroke;
    private transient Paint rangeCrosshairPaint;
    private boolean rangeCrosshairLockedOnData = true;
    private Map foregroundDomainMarkers;
    private Map backgroundDomainMarkers;
    private Map foregroundRangeMarkers;
    private Map backgroundRangeMarkers;
    private List annotations;
    private transient Paint domainTickBandPaint;
    private transient Paint rangeTickBandPaint;
    private AxisSpace fixedDomainAxisSpace;
    private AxisSpace fixedRangeAxisSpace;
    private DatasetRenderingOrder datasetRenderingOrder = DatasetRenderingOrder.REVERSE;
    private SeriesRenderingOrder seriesRenderingOrder = SeriesRenderingOrder.REVERSE;
    private int weight = 1;
    private LegendItemCollection fixedLegendItems;
    private boolean domainPannable;
    private boolean rangePannable;

    static {
        DEFAULT_GRIDLINE_PAINT.setColor(-3355444);
        DEFAULT_CROSSHAIR_STROKE = DEFAULT_GRIDLINE_STROKE;
        DEFAULT_CROSSHAIR_PAINT = new Paint(1);
        DEFAULT_CROSSHAIR_PAINT.setColor(-16776961);
    }

    public XYPlot() {
        this(null, null, null, null);
    }

    public XYPlot(XYDataset dataset, ValueAxis domainAxis, ValueAxis rangeAxis, XYItemRenderer renderer) {
        this.orientation = PlotOrientation.VERTICAL;
        this.axisOffset = RectangleInsets.ZERO_INSETS;
        this.domainAxes = new ObjectList();
        this.domainAxisLocations = new ObjectList();
        this.foregroundDomainMarkers = new HashMap();
        this.backgroundDomainMarkers = new HashMap();
        this.rangeAxes = new ObjectList();
        this.rangeAxisLocations = new ObjectList();
        this.foregroundRangeMarkers = new HashMap();
        this.backgroundRangeMarkers = new HashMap();
        this.datasets = new ObjectList();
        this.renderers = new ObjectList();
        this.datasetToDomainAxesMap = new TreeMap();
        this.datasetToRangeAxesMap = new TreeMap();
        this.annotations = new ArrayList();
        this.datasets.set(0, dataset);
        this.renderers.set(0, renderer);
        if (renderer != null) {
            renderer.setPlot(this);
            renderer.addChangeListener(this);
        }
        this.domainAxes.set(0, domainAxis);
        this.mapDatasetToDomainAxis(0, 0);
        if (domainAxis != null) {
            domainAxis.setPlot(this);
        }
        this.domainAxisLocations.set(0, AxisLocation.BOTTOM_OR_LEFT);
        this.rangeAxes.set(0, rangeAxis);
        this.mapDatasetToRangeAxis(0, 0);
        if (rangeAxis != null) {
            rangeAxis.setPlot(this);
        }
        this.rangeAxisLocations.set(0, AxisLocation.BOTTOM_OR_LEFT);
        this.configureDomainAxes();
        this.configureRangeAxes();
        Paint white = new Paint(1);
        white.setColor(-1);
        Paint black = new Paint(1);
        white.setColor(-16777216);
        this.domainGridlinesVisible = true;
        this.domainGridlineStroke = DEFAULT_GRIDLINE_STROKE;
        this.domainGridlinePaint = DEFAULT_GRIDLINE_PAINT;
        this.domainMinorGridlinesVisible = false;
        this.domainMinorGridlineStroke = DEFAULT_GRIDLINE_STROKE;
        this.domainMinorGridlinePaint = white;
        this.domainZeroBaselineVisible = false;
        this.domainZeroBaselinePaint = black;
        this.domainZeroBaselineStroke = Float.valueOf(1.0f);
        this.rangeGridlinesVisible = true;
        this.rangeGridlineStroke = DEFAULT_GRIDLINE_STROKE;
        this.rangeGridlinePaint = DEFAULT_GRIDLINE_PAINT;
        this.rangeMinorGridlinesVisible = false;
        this.rangeMinorGridlineStroke = DEFAULT_GRIDLINE_STROKE;
        this.rangeMinorGridlinePaint = white;
        this.rangeZeroBaselineVisible = false;
        this.rangeZeroBaselinePaint = black;
        this.rangeZeroBaselineStroke = Float.valueOf(1.0f);
        this.domainCrosshairVisible = false;
        this.domainCrosshairValue = 0.0;
        this.domainCrosshairStroke = DEFAULT_CROSSHAIR_STROKE;
        this.domainCrosshairPaint = DEFAULT_CROSSHAIR_PAINT;
        this.rangeCrosshairVisible = false;
        this.rangeCrosshairValue = 0.0;
        this.rangeCrosshairStroke = DEFAULT_CROSSHAIR_STROKE;
        this.rangeCrosshairPaint = DEFAULT_CROSSHAIR_PAINT;
    }

    @Override
    public String getPlotType() {
        return "XY_Plot";
    }

    @Override
    public PlotOrientation getOrientation() {
        return this.orientation;
    }

    public void setOrientation(PlotOrientation orientation) {
        if (orientation == null) {
            throw new IllegalArgumentException("Null 'orientation' argument.");
        }
        if (orientation != this.orientation) {
            this.orientation = orientation;
        }
    }

    public RectangleInsets getAxisOffset() {
        return this.axisOffset;
    }

    public void setAxisOffset(RectangleInsets offset) {
        if (offset == null) {
            throw new IllegalArgumentException("Null 'offset' argument.");
        }
        this.axisOffset = offset;
    }

    public ValueAxis getDomainAxis() {
        return this.getDomainAxis(0);
    }

    public ValueAxis getDomainAxis(int index) {
        Plot parent;
        ValueAxis result = null;
        if (index < this.domainAxes.size()) {
            result = (ValueAxis)this.domainAxes.get(index);
        }
        if (result == null && (parent = this.getParent()) instanceof XYPlot) {
            XYPlot xy = (XYPlot)parent;
            result = xy.getDomainAxis(index);
        }
        return result;
    }

    public void setDomainAxis(ValueAxis axis) {
        this.setDomainAxis(0, axis);
    }

    public void setDomainAxis(int index, ValueAxis axis) {
        this.setDomainAxis(index, axis, true);
    }

    public void setDomainAxis(int index, ValueAxis axis, boolean notify) {
        ValueAxis existing = this.getDomainAxis(index);
        if (axis != null) {
            axis.setPlot(this);
        }
        this.domainAxes.set(index, axis);
        if (axis != null) {
            axis.configure();
        }
    }

    public void setDomainAxes(ValueAxis[] axes) {
        int i = 0;
        while (i < axes.length) {
            this.setDomainAxis(i, axes[i], false);
            ++i;
        }
    }

    public AxisLocation getDomainAxisLocation() {
        return (AxisLocation)this.domainAxisLocations.get(0);
    }

    public void setDomainAxisLocation(AxisLocation location) {
        this.setDomainAxisLocation(0, location, true);
    }

    public void setDomainAxisLocation(AxisLocation location, boolean notify) {
        this.setDomainAxisLocation(0, location, notify);
    }

    public RectangleEdge getDomainAxisEdge() {
        return Plot.resolveDomainAxisLocation(this.getDomainAxisLocation(), this.orientation);
    }

    public int getDomainAxisCount() {
        return this.domainAxes.size();
    }

    public void clearDomainAxes() {
        int i = 0;
        while (i < this.domainAxes.size()) {
            ValueAxis valueAxis = (ValueAxis)this.domainAxes.get(i);
            ++i;
        }
        this.domainAxes.clear();
    }

    public void configureDomainAxes() {
        int i = 0;
        while (i < this.domainAxes.size()) {
            ValueAxis axis = (ValueAxis)this.domainAxes.get(i);
            if (axis != null) {
                axis.configure();
            }
            ++i;
        }
    }

    public AxisLocation getDomainAxisLocation(int index) {
        AxisLocation result = null;
        if (index < this.domainAxisLocations.size()) {
            result = (AxisLocation)this.domainAxisLocations.get(index);
        }
        if (result == null) {
            result = AxisLocation.getOpposite(this.getDomainAxisLocation());
        }
        return result;
    }

    public void setDomainAxisLocation(int index, AxisLocation location) {
        this.setDomainAxisLocation(index, location, true);
    }

    public void setDomainAxisLocation(int index, AxisLocation location, boolean notify) {
        if (index == 0 && location == null) {
            throw new IllegalArgumentException("Null 'location' for index 0 not permitted.");
        }
        this.domainAxisLocations.set(index, location);
    }

    public RectangleEdge getDomainAxisEdge(int index) {
        AxisLocation location = this.getDomainAxisLocation(index);
        RectangleEdge result = Plot.resolveDomainAxisLocation(location, this.orientation);
        if (result == null) {
            result = RectangleEdge.opposite(this.getDomainAxisEdge());
        }
        return result;
    }

    public ValueAxis getRangeAxis() {
        return this.getRangeAxis(0);
    }

    public void setRangeAxis(ValueAxis axis) {
        if (axis != null) {
            axis.setPlot(this);
        }
        ValueAxis existing = this.getRangeAxis();
        this.rangeAxes.set(0, axis);
        if (axis != null) {
            axis.configure();
        }
    }

    public AxisLocation getRangeAxisLocation() {
        return (AxisLocation)this.rangeAxisLocations.get(0);
    }

    public void setRangeAxisLocation(AxisLocation location) {
        this.setRangeAxisLocation(0, location, true);
    }

    public void setRangeAxisLocation(AxisLocation location, boolean notify) {
        this.setRangeAxisLocation(0, location, notify);
    }

    public RectangleEdge getRangeAxisEdge() {
        return Plot.resolveRangeAxisLocation(this.getRangeAxisLocation(), this.orientation);
    }

    public ValueAxis getRangeAxis(int index) {
        Plot parent;
        ValueAxis result = null;
        if (index < this.rangeAxes.size()) {
            result = (ValueAxis)this.rangeAxes.get(index);
        }
        if (result == null && (parent = this.getParent()) instanceof XYPlot) {
            XYPlot xy = (XYPlot)parent;
            result = xy.getRangeAxis(index);
        }
        return result;
    }

    public void setRangeAxis(int index, ValueAxis axis) {
        this.setRangeAxis(index, axis, true);
    }

    public void setRangeAxis(int index, ValueAxis axis, boolean notify) {
        ValueAxis existing = this.getRangeAxis(index);
        if (axis != null) {
            axis.setPlot(this);
        }
        this.rangeAxes.set(index, axis);
        if (axis != null) {
            axis.configure();
        }
    }

    public void setRangeAxes(ValueAxis[] axes) {
        int i = 0;
        while (i < axes.length) {
            this.setRangeAxis(i, axes[i], false);
            ++i;
        }
    }

    public int getRangeAxisCount() {
        return this.rangeAxes.size();
    }

    public void clearRangeAxes() {
        int i = 0;
        while (i < this.rangeAxes.size()) {
            ValueAxis valueAxis = (ValueAxis)this.rangeAxes.get(i);
            ++i;
        }
        this.rangeAxes.clear();
    }

    public void configureRangeAxes() {
        int i = 0;
        while (i < this.rangeAxes.size()) {
            ValueAxis axis = (ValueAxis)this.rangeAxes.get(i);
            if (axis != null) {
                axis.configure();
            }
            ++i;
        }
    }

    public AxisLocation getRangeAxisLocation(int index) {
        AxisLocation result = null;
        if (index < this.rangeAxisLocations.size()) {
            result = (AxisLocation)this.rangeAxisLocations.get(index);
        }
        if (result == null) {
            result = AxisLocation.getOpposite(this.getRangeAxisLocation());
        }
        return result;
    }

    public void setRangeAxisLocation(int index, AxisLocation location) {
        this.setRangeAxisLocation(index, location, true);
    }

    public void setRangeAxisLocation(int index, AxisLocation location, boolean notify) {
        if (index == 0 && location == null) {
            throw new IllegalArgumentException("Null 'location' for index 0 not permitted.");
        }
        this.rangeAxisLocations.set(index, location);
    }

    public RectangleEdge getRangeAxisEdge(int index) {
        AxisLocation location = this.getRangeAxisLocation(index);
        RectangleEdge result = Plot.resolveRangeAxisLocation(location, this.orientation);
        if (result == null) {
            result = RectangleEdge.opposite(this.getRangeAxisEdge());
        }
        return result;
    }

    public XYDataset getDataset() {
        return this.getDataset(0);
    }

    public XYDataset getDataset(int index) {
        XYDataset result = null;
        if (this.datasets.size() > index) {
            result = (XYDataset)this.datasets.get(index);
        }
        return result;
    }

    public void setDataset(XYDataset dataset) {
        this.setDataset(0, dataset);
    }

    public void setDataset(int index, XYDataset dataset) {
        XYDataset existing = this.getDataset(index);
        this.datasets.set(index, dataset);
    }

    public int getDatasetCount() {
        return this.datasets.size();
    }

    public int indexOf(XYDataset dataset) {
        int result = -1;
        int i = 0;
        while (i < this.datasets.size()) {
            if (dataset == this.datasets.get(i)) {
                result = i;
                break;
            }
            ++i;
        }
        return result;
    }

    public void mapDatasetToDomainAxis(int index, int axisIndex) {
        ArrayList<Integer> axisIndices = new ArrayList<Integer>(1);
        axisIndices.add(new Integer(axisIndex));
        this.mapDatasetToDomainAxes(index, axisIndices);
    }

    public void mapDatasetToDomainAxes(int index, List axisIndices) {
        if (index < 0) {
            throw new IllegalArgumentException("Requires 'index' >= 0.");
        }
        this.checkAxisIndices(axisIndices);
        Integer key = new Integer(index);
        this.datasetToDomainAxesMap.put(key, new ArrayList(axisIndices));
    }

    public void mapDatasetToRangeAxis(int index, int axisIndex) {
        ArrayList<Integer> axisIndices = new ArrayList<Integer>(1);
        axisIndices.add(new Integer(axisIndex));
        this.mapDatasetToRangeAxes(index, axisIndices);
    }

    public void mapDatasetToRangeAxes(int index, List axisIndices) {
        if (index < 0) {
            throw new IllegalArgumentException("Requires 'index' >= 0.");
        }
        this.checkAxisIndices(axisIndices);
        Integer key = new Integer(index);
        this.datasetToRangeAxesMap.put(key, new ArrayList(axisIndices));
    }

    private void checkAxisIndices(List indices) {
        if (indices == null) {
            return;
        }
        int count = indices.size();
        if (count == 0) {
            throw new IllegalArgumentException("Empty list not permitted.");
        }
        HashSet set = new HashSet();
        int i = 0;
        while (i < count) {
            Object item = indices.get(i);
            if (!(item instanceof Integer)) {
                throw new IllegalArgumentException("Indices must be Integer instances.");
            }
            if (set.contains(item)) {
                throw new IllegalArgumentException("Indices must be unique.");
            }
            set.add(item);
            ++i;
        }
    }

    public int getRendererCount() {
        return this.renderers.size();
    }

    public XYItemRenderer getRenderer() {
        return this.getRenderer(0);
    }

    public XYItemRenderer getRenderer(int index) {
        XYItemRenderer result = null;
        if (this.renderers.size() > index) {
            result = (XYItemRenderer)this.renderers.get(index);
        }
        return result;
    }

    public void setRenderer(XYItemRenderer renderer) {
        this.setRenderer(0, renderer);
    }

    public void setRenderer(int index, XYItemRenderer renderer) {
        this.setRenderer(index, renderer, true);
    }

    public void setRenderer(int index, XYItemRenderer renderer, boolean notify) {
        XYItemRenderer existing = this.getRenderer(index);
        if (existing != null) {
            existing.removeChangeListener(this);
        }
        this.renderers.set(index, renderer);
        if (renderer != null) {
            renderer.setPlot(this);
            renderer.addChangeListener(this);
        }
        this.configureDomainAxes();
        this.configureRangeAxes();
    }

    public void setRenderers(XYItemRenderer[] renderers) {
        int i = 0;
        while (i < renderers.length) {
            this.setRenderer(i, renderers[i], false);
            ++i;
        }
    }

    public DatasetRenderingOrder getDatasetRenderingOrder() {
        return this.datasetRenderingOrder;
    }

    public void setDatasetRenderingOrder(DatasetRenderingOrder order) {
        if (order == null) {
            throw new IllegalArgumentException("Null 'order' argument.");
        }
        this.datasetRenderingOrder = order;
    }

    public SeriesRenderingOrder getSeriesRenderingOrder() {
        return this.seriesRenderingOrder;
    }

    public void setSeriesRenderingOrder(SeriesRenderingOrder order) {
        if (order == null) {
            throw new IllegalArgumentException("Null 'order' argument.");
        }
        this.seriesRenderingOrder = order;
    }

    public int getIndexOf(XYItemRenderer renderer) {
        return this.renderers.indexOf(renderer);
    }

    public XYItemRenderer getRendererForDataset(XYDataset dataset) {
        XYItemRenderer result = null;
        int i = 0;
        while (i < this.datasets.size()) {
            if (this.datasets.get(i) == dataset) {
                result = (XYItemRenderer)this.renderers.get(i);
                if (result != null) break;
                result = this.getRenderer();
                break;
            }
            ++i;
        }
        return result;
    }

    public int getWeight() {
        return this.weight;
    }

    public void setWeight(int weight) {
        this.weight = weight;
    }

    public boolean isDomainGridlinesVisible() {
        return this.domainGridlinesVisible;
    }

    public void setDomainGridlinesVisible(boolean visible) {
        if (this.domainGridlinesVisible != visible) {
            this.domainGridlinesVisible = visible;
        }
    }

    public boolean isDomainMinorGridlinesVisible() {
        return this.domainMinorGridlinesVisible;
    }

    public void setDomainMinorGridlinesVisible(boolean visible) {
        if (this.domainMinorGridlinesVisible != visible) {
            this.domainMinorGridlinesVisible = visible;
        }
    }

    public Float getDomainGridlineStroke() {
        return this.domainGridlineStroke;
    }

    public void setDomainGridlineStroke(Float stroke) {
        if (stroke == null) {
            throw new IllegalArgumentException("Null 'stroke' argument.");
        }
        this.domainGridlineStroke = stroke;
    }

    public Float getDomainMinorGridlineStroke() {
        return this.domainMinorGridlineStroke;
    }

    public void setDomainMinorGridlineStroke(Float stroke) {
        if (stroke == null) {
            throw new IllegalArgumentException("Null 'stroke' argument.");
        }
        this.domainMinorGridlineStroke = stroke;
    }

    public Paint getDomainGridlinePaint() {
        return this.domainGridlinePaint;
    }

    public void setDomainGridlinePaint(Paint paint) {
        if (paint == null) {
            throw new IllegalArgumentException("Null 'paint' argument.");
        }
        this.domainGridlinePaint = paint;
    }

    public Paint getDomainMinorGridlinePaint() {
        return this.domainMinorGridlinePaint;
    }

    public void setDomainMinorGridlinePaint(Paint paint) {
        if (paint == null) {
            throw new IllegalArgumentException("Null 'paint' argument.");
        }
        this.domainMinorGridlinePaint = paint;
    }

    public boolean isRangeGridlinesVisible() {
        return this.rangeGridlinesVisible;
    }

    public void setRangeGridlinesVisible(boolean visible) {
        if (this.rangeGridlinesVisible != visible) {
            this.rangeGridlinesVisible = visible;
        }
    }

    public Float getRangeGridlineStroke() {
        return this.rangeGridlineStroke;
    }

    public void setRangeGridlineStroke(Float stroke) {
        if (stroke == null) {
            throw new IllegalArgumentException("Null 'stroke' argument.");
        }
        this.rangeGridlineStroke = stroke;
    }

    public Paint getRangeGridlinePaint() {
        return this.rangeGridlinePaint;
    }

    public void setRangeGridlinePaint(Paint paint) {
        if (paint == null) {
            throw new IllegalArgumentException("Null 'paint' argument.");
        }
        this.rangeGridlinePaint = paint;
    }

    public boolean isRangeMinorGridlinesVisible() {
        return this.rangeMinorGridlinesVisible;
    }

    public void setRangeMinorGridlinesVisible(boolean visible) {
        if (this.rangeMinorGridlinesVisible != visible) {
            this.rangeMinorGridlinesVisible = visible;
        }
    }

    public Float getRangeMinorGridlineStroke() {
        return this.rangeMinorGridlineStroke;
    }

    public void setRangeMinorGridlineStroke(Float stroke) {
        if (stroke == null) {
            throw new IllegalArgumentException("Null 'stroke' argument.");
        }
        this.rangeMinorGridlineStroke = stroke;
    }

    public Paint getRangeMinorGridlinePaint() {
        return this.rangeMinorGridlinePaint;
    }

    public void setRangeMinorGridlinePaint(Paint paint) {
        if (paint == null) {
            throw new IllegalArgumentException("Null 'paint' argument.");
        }
        this.rangeMinorGridlinePaint = paint;
    }

    public boolean isDomainZeroBaselineVisible() {
        return this.domainZeroBaselineVisible;
    }

    public void setDomainZeroBaselineVisible(boolean visible) {
        this.domainZeroBaselineVisible = visible;
    }

    public Float getDomainZeroBaselineStroke() {
        return this.domainZeroBaselineStroke;
    }

    public void setDomainZeroBaselineStroke(Float stroke) {
        if (stroke == null) {
            throw new IllegalArgumentException("Null 'stroke' argument.");
        }
        this.domainZeroBaselineStroke = stroke;
    }

    public Paint getDomainZeroBaselinePaint() {
        return this.domainZeroBaselinePaint;
    }

    public void setDomainZeroBaselinePaint(Paint paint) {
        if (paint == null) {
            throw new IllegalArgumentException("Null 'paint' argument.");
        }
        this.domainZeroBaselinePaint = paint;
    }

    public boolean isRangeZeroBaselineVisible() {
        return this.rangeZeroBaselineVisible;
    }

    public void setRangeZeroBaselineVisible(boolean visible) {
        this.rangeZeroBaselineVisible = visible;
    }

    public Float getRangeZeroBaselineStroke() {
        return this.rangeZeroBaselineStroke;
    }

    public void setRangeZeroBaselineStroke(Float stroke) {
        if (stroke == null) {
            throw new IllegalArgumentException("Null 'stroke' argument.");
        }
        this.rangeZeroBaselineStroke = stroke;
    }

    public Paint getRangeZeroBaselinePaint() {
        return this.rangeZeroBaselinePaint;
    }

    public void setRangeZeroBaselinePaint(Paint paint) {
        if (paint == null) {
            throw new IllegalArgumentException("Null 'paint' argument.");
        }
        this.rangeZeroBaselinePaint = paint;
    }

    public Paint getDomainTickBandPaint() {
        return this.domainTickBandPaint;
    }

    public void setDomainTickBandPaint(Paint paint) {
        this.domainTickBandPaint = paint;
    }

    public Paint getRangeTickBandPaint() {
        return this.rangeTickBandPaint;
    }

    public void setRangeTickBandPaint(Paint paint) {
        this.rangeTickBandPaint = paint;
    }

    public Point2D getQuadrantOrigin() {
        return this.quadrantOrigin;
    }

    public void setQuadrantOrigin(Point2D origin) {
        if (origin == null) {
            throw new IllegalArgumentException("Null 'origin' argument.");
        }
        this.quadrantOrigin = origin;
    }

    public Paint getQuadrantPaint(int index) {
        if (index < 0 || index > 3) {
            throw new IllegalArgumentException("The index value (" + index + ") should be in the range 0 to 3.");
        }
        return this.quadrantPaint[index];
    }

    public void setQuadrantPaint(int index, Paint paint) {
        if (index < 0 || index > 3) {
            throw new IllegalArgumentException("The index value (" + index + ") should be in the range 0 to 3.");
        }
        this.quadrantPaint[index] = paint;
    }

    public void addDomainMarker(Marker marker) {
        this.addDomainMarker(marker, Layer.FOREGROUND);
    }

    public void addDomainMarker(Marker marker, Layer layer) {
        this.addDomainMarker(0, marker, layer);
    }

    public void clearDomainMarkers() {
        Set keys;
        if (this.backgroundDomainMarkers != null) {
            keys = this.backgroundDomainMarkers.keySet();
            for (Integer key : keys) {
                this.clearDomainMarkers(key);
            }
            this.backgroundDomainMarkers.clear();
        }
        if (this.foregroundDomainMarkers != null) {
            keys = this.foregroundDomainMarkers.keySet();
            for (Integer key : keys) {
                this.clearDomainMarkers(key);
            }
            this.foregroundDomainMarkers.clear();
        }
    }

    public void clearDomainMarkers(int index) {
        Collection markers;
        Integer key = new Integer(index);
        if (this.backgroundDomainMarkers != null && (markers = (Collection)this.backgroundDomainMarkers.get(key)) != null) {
            for (Marker marker : markers) {
            }
            markers.clear();
        }
        if (this.foregroundRangeMarkers != null && (markers = (Collection)this.foregroundDomainMarkers.get(key)) != null) {
            for (Marker marker : markers) {
            }
            markers.clear();
        }
    }

    public void addDomainMarker(int index, Marker marker, Layer layer) {
        this.addDomainMarker(index, marker, layer, true);
    }

    public void addDomainMarker(int index, Marker marker, Layer layer, boolean notify) {
        if (marker == null) {
            throw new IllegalArgumentException("Null 'marker' not permitted.");
        }
        if (layer == null) {
            throw new IllegalArgumentException("Null 'layer' not permitted.");
        }
        if (layer == Layer.FOREGROUND) {
            ArrayList<Marker> markers = (ArrayList<Marker>)this.foregroundDomainMarkers.get(new Integer(index));
            if (markers == null) {
                markers = new ArrayList<Marker>();
                this.foregroundDomainMarkers.put(new Integer(index), markers);
            }
            markers.add(marker);
        } else if (layer == Layer.BACKGROUND) {
            ArrayList<Marker> markers = (ArrayList<Marker>)this.backgroundDomainMarkers.get(new Integer(index));
            if (markers == null) {
                markers = new ArrayList<Marker>();
                this.backgroundDomainMarkers.put(new Integer(index), markers);
            }
            markers.add(marker);
        }
    }

    public boolean removeDomainMarker(Marker marker) {
        return this.removeDomainMarker(marker, Layer.FOREGROUND);
    }

    public boolean removeDomainMarker(Marker marker, Layer layer) {
        return this.removeDomainMarker(0, marker, layer);
    }

    public boolean removeDomainMarker(int index, Marker marker, Layer layer) {
        return this.removeDomainMarker(index, marker, layer, true);
    }

    public boolean removeDomainMarker(int index, Marker marker, Layer layer, boolean notify) {
        ArrayList markers = layer == Layer.FOREGROUND ? (ArrayList)this.foregroundDomainMarkers.get(new Integer(index)) : (ArrayList)this.backgroundDomainMarkers.get(new Integer(index));
        if (markers == null) {
            return false;
        }
        boolean removed = markers.remove(marker);
        if (removed) {
            // empty if block
        }
        return removed;
    }

    public void addRangeMarker(Marker marker) {
        this.addRangeMarker(marker, Layer.FOREGROUND);
    }

    public void addRangeMarker(Marker marker, Layer layer) {
        this.addRangeMarker(0, marker, layer);
    }

    public void clearRangeMarkers() {
        Set keys;
        if (this.backgroundRangeMarkers != null) {
            keys = this.backgroundRangeMarkers.keySet();
            for (Integer key : keys) {
                this.clearRangeMarkers(key);
            }
            this.backgroundRangeMarkers.clear();
        }
        if (this.foregroundRangeMarkers != null) {
            keys = this.foregroundRangeMarkers.keySet();
            for (Integer key : keys) {
                this.clearRangeMarkers(key);
            }
            this.foregroundRangeMarkers.clear();
        }
    }

    public void addRangeMarker(int index, Marker marker, Layer layer) {
        this.addRangeMarker(index, marker, layer, true);
    }

    public void addRangeMarker(int index, Marker marker, Layer layer, boolean notify) {
        if (layer == Layer.FOREGROUND) {
            ArrayList<Marker> markers = (ArrayList<Marker>)this.foregroundRangeMarkers.get(new Integer(index));
            if (markers == null) {
                markers = new ArrayList<Marker>();
                this.foregroundRangeMarkers.put(new Integer(index), markers);
            }
            markers.add(marker);
        } else if (layer == Layer.BACKGROUND) {
            ArrayList<Marker> markers = (ArrayList<Marker>)this.backgroundRangeMarkers.get(new Integer(index));
            if (markers == null) {
                markers = new ArrayList<Marker>();
                this.backgroundRangeMarkers.put(new Integer(index), markers);
            }
            markers.add(marker);
        }
    }

    public void clearRangeMarkers(int index) {
        Collection markers;
        Integer key = new Integer(index);
        if (this.backgroundRangeMarkers != null && (markers = (Collection)this.backgroundRangeMarkers.get(key)) != null) {
            for (Marker marker : markers) {
            }
            markers.clear();
        }
        if (this.foregroundRangeMarkers != null && (markers = (Collection)this.foregroundRangeMarkers.get(key)) != null) {
            for (Marker marker : markers) {
            }
            markers.clear();
        }
    }

    public boolean removeRangeMarker(Marker marker) {
        return this.removeRangeMarker(marker, Layer.FOREGROUND);
    }

    public boolean removeRangeMarker(Marker marker, Layer layer) {
        return this.removeRangeMarker(0, marker, layer);
    }

    public boolean removeRangeMarker(int index, Marker marker, Layer layer) {
        return this.removeRangeMarker(index, marker, layer, true);
    }

    public boolean removeRangeMarker(int index, Marker marker, Layer layer, boolean notify) {
        if (marker == null) {
            throw new IllegalArgumentException("Null 'marker' argument.");
        }
        ArrayList markers = layer == Layer.FOREGROUND ? (ArrayList)this.foregroundRangeMarkers.get(new Integer(index)) : (ArrayList)this.backgroundRangeMarkers.get(new Integer(index));
        if (markers == null) {
            return false;
        }
        boolean removed = markers.remove(marker);
        if (removed) {
            // empty if block
        }
        return removed;
    }

    public void addAnnotation(XYAnnotation annotation) {
        this.addAnnotation(annotation, true);
    }

    public void addAnnotation(XYAnnotation annotation, boolean notify) {
        if (annotation == null) {
            throw new IllegalArgumentException("Null 'annotation' argument.");
        }
        this.annotations.add(annotation);
    }

    public boolean removeAnnotation(XYAnnotation annotation) {
        return this.removeAnnotation(annotation, true);
    }

    public boolean removeAnnotation(XYAnnotation annotation, boolean notify) {
        if (annotation == null) {
            throw new IllegalArgumentException("Null 'annotation' argument.");
        }
        boolean removed = this.annotations.remove(annotation);
        if (removed) {
            // empty if block
        }
        return removed;
    }

    public List getAnnotations() {
        return new ArrayList(this.annotations);
    }

    public void clearAnnotations() {
        this.annotations.clear();
    }

    protected AxisSpace calculateAxisSpace(Canvas g2, Rectangle2D plotArea) {
        AxisSpace space = new AxisSpace();
        space = this.calculateRangeAxisSpace(g2, plotArea, space);
        Rectangle2D revPlotArea = space.shrink(plotArea, null);
        space = this.calculateDomainAxisSpace(g2, revPlotArea, space);
        return space;
    }

    protected AxisSpace calculateDomainAxisSpace(Canvas g2, Rectangle2D plotArea, AxisSpace space) {
        block5: {
            block3: {
                block4: {
                    if (space == null) {
                        space = new AxisSpace();
                    }
                    if (this.fixedDomainAxisSpace == null) break block3;
                    if (this.orientation != PlotOrientation.HORIZONTAL) break block4;
                    space.ensureAtLeast(this.fixedDomainAxisSpace.getLeft(), RectangleEdge.LEFT);
                    space.ensureAtLeast(this.fixedDomainAxisSpace.getRight(), RectangleEdge.RIGHT);
                    break block5;
                }
                if (this.orientation != PlotOrientation.VERTICAL) break block5;
                space.ensureAtLeast(this.fixedDomainAxisSpace.getTop(), RectangleEdge.TOP);
                space.ensureAtLeast(this.fixedDomainAxisSpace.getBottom(), RectangleEdge.BOTTOM);
                break block5;
            }
            int i = 0;
            while (i < this.domainAxes.size()) {
                Axis axis = (Axis)this.domainAxes.get(i);
                if (axis != null) {
                    RectangleEdge edge = this.getDomainAxisEdge(i);
                    space = axis.reserveSpace(g2, this, plotArea, edge, space);
                }
                ++i;
            }
        }
        return space;
    }

    protected AxisSpace calculateRangeAxisSpace(Canvas g2, Rectangle2D plotArea, AxisSpace space) {
        block5: {
            block3: {
                block4: {
                    if (space == null) {
                        space = new AxisSpace();
                    }
                    if (this.fixedRangeAxisSpace == null) break block3;
                    if (this.orientation != PlotOrientation.HORIZONTAL) break block4;
                    space.ensureAtLeast(this.fixedRangeAxisSpace.getTop(), RectangleEdge.TOP);
                    space.ensureAtLeast(this.fixedRangeAxisSpace.getBottom(), RectangleEdge.BOTTOM);
                    break block5;
                }
                if (this.orientation != PlotOrientation.VERTICAL) break block5;
                space.ensureAtLeast(this.fixedRangeAxisSpace.getLeft(), RectangleEdge.LEFT);
                space.ensureAtLeast(this.fixedRangeAxisSpace.getRight(), RectangleEdge.RIGHT);
                break block5;
            }
            int i = 0;
            while (i < this.rangeAxes.size()) {
                Axis axis = (Axis)this.rangeAxes.get(i);
                if (axis != null) {
                    RectangleEdge edge = this.getRangeAxisEdge(i);
                    space = axis.reserveSpace(g2, this, plotArea, edge, space);
                }
                ++i;
            }
        }
        return space;
    }

    @Override
    public void draw(Canvas g2, Rectangle2D area, Point2D anchor, PlotState parentState, PlotRenderingInfo info) {
        ValueAxis rangeAxis;
        ValueAxis domainAxis;
        XYItemRenderer r;
        int i;
        int rendererCount;
        AxisState rangeAxisState;
        boolean b2;
        boolean b1 = area.getWidth() <= 10.0;
        boolean bl = b2 = area.getHeight() <= 10.0;
        if (b1 || b2) {
            return;
        }
        if (info != null) {
            info.setPlotArea(area);
        }
        RectangleInsets insets = this.getInsets();
        insets.trim(area);
        AxisSpace space = this.calculateAxisSpace(g2, area);
        Rectangle2D dataArea = space.shrink(area, null);
        this.axisOffset.trim(dataArea);
        this.createAndAddEntity((Rectangle2D)dataArea.clone(), info, null, null);
        if (info != null) {
            info.setDataArea(dataArea);
        }
        this.drawBackground(g2, dataArea);
        Map axisStateMap = this.drawAxes(g2, area, dataArea, info);
        PlotOrientation orient = this.getOrientation();
        if (anchor != null && !dataArea.contains(anchor)) {
            anchor = null;
        }
        CrosshairState crosshairState = new CrosshairState();
        crosshairState.setCrosshairDistance(Double.POSITIVE_INFINITY);
        crosshairState.setAnchor(anchor);
        crosshairState.setAnchorX(Double.NaN);
        crosshairState.setAnchorY(Double.NaN);
        if (anchor != null) {
            ValueAxis rangeAxis2;
            ValueAxis domainAxis2 = this.getDomainAxis();
            if (domainAxis2 != null) {
                double x = orient == PlotOrientation.VERTICAL ? domainAxis2.java2DToValue(anchor.getX(), dataArea, this.getDomainAxisEdge()) : domainAxis2.java2DToValue(anchor.getY(), dataArea, this.getDomainAxisEdge());
                crosshairState.setAnchorX(x);
            }
            if ((rangeAxis2 = this.getRangeAxis()) != null) {
                double y = orient == PlotOrientation.VERTICAL ? rangeAxis2.java2DToValue(anchor.getY(), dataArea, this.getRangeAxisEdge()) : rangeAxis2.java2DToValue(anchor.getX(), dataArea, this.getRangeAxisEdge());
                crosshairState.setAnchorY(y);
            }
        }
        crosshairState.setCrosshairX(this.getDomainCrosshairValue());
        crosshairState.setCrosshairY(this.getRangeCrosshairValue());
        g2.save();
        g2.clipRect((float)dataArea.getMinX(), (float)dataArea.getMinY(), (float)dataArea.getMaxX(), (float)dataArea.getMaxY());
        AxisState domainAxisState = (AxisState)axisStateMap.get(this.getDomainAxis());
        if (domainAxisState == null && parentState != null) {
            domainAxisState = (AxisState)parentState.getSharedAxisStates().get(this.getDomainAxis());
        }
        if ((rangeAxisState = (AxisState)axisStateMap.get(this.getRangeAxis())) == null && parentState != null) {
            rangeAxisState = (AxisState)parentState.getSharedAxisStates().get(this.getRangeAxis());
        }
        if (domainAxisState != null) {
            this.drawDomainTickBands(g2, dataArea, domainAxisState.getTicks());
        }
        if (rangeAxisState != null) {
            this.drawRangeTickBands(g2, dataArea, rangeAxisState.getTicks());
        }
        if (domainAxisState != null) {
            this.drawDomainGridlines(g2, dataArea, domainAxisState.getTicks());
            this.drawZeroDomainBaseline(g2, dataArea);
        }
        if (rangeAxisState != null) {
            this.drawRangeGridlines(g2, dataArea, rangeAxisState.getTicks());
            this.drawZeroRangeBaseline(g2, dataArea);
        }
        int i2 = 0;
        while (i2 < this.renderers.size()) {
            this.drawDomainMarkers(g2, dataArea, i2, Layer.BACKGROUND);
            ++i2;
        }
        i2 = 0;
        while (i2 < this.renderers.size()) {
            this.drawRangeMarkers(g2, dataArea, i2, Layer.BACKGROUND);
            ++i2;
        }
        boolean foundData = false;
        DatasetRenderingOrder order = this.getDatasetRenderingOrder();
        if (order == DatasetRenderingOrder.FORWARD) {
            rendererCount = this.renderers.size();
            i = 0;
            while (i < rendererCount) {
                r = this.getRenderer(i);
                if (r != null) {
                    domainAxis = this.getDomainAxisForDataset(i);
                    rangeAxis = this.getRangeAxisForDataset(i);
                    r.drawAnnotations(g2, dataArea, domainAxis, rangeAxis, Layer.BACKGROUND, info);
                }
                ++i;
            }
            i = 0;
            while (i < this.getDatasetCount()) {
                foundData = this.render(g2, dataArea, i, info, crosshairState) || foundData;
                ++i;
            }
            i = 0;
            while (i < rendererCount) {
                r = this.getRenderer(i);
                if (r != null) {
                    domainAxis = this.getDomainAxisForDataset(i);
                    rangeAxis = this.getRangeAxisForDataset(i);
                    r.drawAnnotations(g2, dataArea, domainAxis, rangeAxis, Layer.FOREGROUND, info);
                }
                ++i;
            }
        } else if (order == DatasetRenderingOrder.REVERSE) {
            rendererCount = this.renderers.size();
            i = rendererCount - 1;
            while (i >= 0) {
                r = this.getRenderer(i);
                if (i < this.getDatasetCount() && r != null) {
                    domainAxis = this.getDomainAxisForDataset(i);
                    rangeAxis = this.getRangeAxisForDataset(i);
                    r.drawAnnotations(g2, dataArea, domainAxis, rangeAxis, Layer.BACKGROUND, info);
                }
                --i;
            }
            i = this.getDatasetCount() - 1;
            while (i >= 0) {
                foundData = this.render(g2, dataArea, i, info, crosshairState) || foundData;
                --i;
            }
            i = rendererCount - 1;
            while (i >= 0) {
                r = this.getRenderer(i);
                if (i < this.getDatasetCount() && r != null) {
                    domainAxis = this.getDomainAxisForDataset(i);
                    rangeAxis = this.getRangeAxisForDataset(i);
                    r.drawAnnotations(g2, dataArea, domainAxis, rangeAxis, Layer.FOREGROUND, info);
                }
                --i;
            }
        }
        int xAxisIndex = crosshairState.getDomainAxisIndex();
        ValueAxis xAxis = this.getDomainAxis(xAxisIndex);
        RectangleEdge xAxisEdge = this.getDomainAxisEdge(xAxisIndex);
        if (!this.domainCrosshairLockedOnData && anchor != null) {
            double xx = orient == PlotOrientation.VERTICAL ? xAxis.java2DToValue(anchor.getX(), dataArea, xAxisEdge) : xAxis.java2DToValue(anchor.getY(), dataArea, xAxisEdge);
            crosshairState.setCrosshairX(xx);
        }
        this.setDomainCrosshairValue(crosshairState.getCrosshairX(), false);
        if (this.isDomainCrosshairVisible()) {
            double x = this.getDomainCrosshairValue();
            Paint paint = this.getDomainCrosshairPaint();
            int oldAlpha = paint.getAlpha();
            paint.setAlpha(this.getForegroundAlpha());
            Float stroke = this.getDomainCrosshairStroke();
            this.drawDomainCrosshair(g2, dataArea, orient, x, xAxis, stroke, paint);
            paint.setAlpha(oldAlpha);
        }
        int yAxisIndex = crosshairState.getRangeAxisIndex();
        ValueAxis yAxis = this.getRangeAxis(yAxisIndex);
        RectangleEdge yAxisEdge = this.getRangeAxisEdge(yAxisIndex);
        if (!this.rangeCrosshairLockedOnData && anchor != null) {
            double yy = orient == PlotOrientation.VERTICAL ? yAxis.java2DToValue(anchor.getY(), dataArea, yAxisEdge) : yAxis.java2DToValue(anchor.getX(), dataArea, yAxisEdge);
            crosshairState.setCrosshairY(yy);
        }
        this.setRangeCrosshairValue(crosshairState.getCrosshairY(), false);
        if (this.isRangeCrosshairVisible()) {
            double y = this.getRangeCrosshairValue();
            Paint paint = this.getRangeCrosshairPaint();
            int oldAlpha = paint.getAlpha();
            paint.setAlpha(this.getForegroundAlpha());
            Float stroke = this.getRangeCrosshairStroke();
            this.drawRangeCrosshair(g2, dataArea, orient, y, yAxis, stroke, paint);
            paint.setAlpha(oldAlpha);
        }
        if (!foundData) {
            this.drawNoDataMessage(g2, dataArea);
        }
        int i3 = 0;
        while (i3 < this.renderers.size()) {
            this.drawDomainMarkers(g2, dataArea, i3, Layer.FOREGROUND);
            ++i3;
        }
        i3 = 0;
        while (i3 < this.renderers.size()) {
            this.drawRangeMarkers(g2, dataArea, i3, Layer.FOREGROUND);
            ++i3;
        }
        this.drawAnnotations(g2, dataArea, info);
        g2.restore();
        this.drawOutline(g2, dataArea);
    }

    @Override
    public void drawBackground(Canvas g2, Rectangle2D area) {
        this.fillBackground(g2, area, this.orientation);
        this.drawQuadrants(g2, area);
    }

    protected void drawQuadrants(Canvas g2, Rectangle2D area) {
        boolean somethingToDraw = false;
        ValueAxis xAxis = this.getDomainAxis();
        if (xAxis == null) {
            return;
        }
        double x = xAxis.getRange().constrain(this.quadrantOrigin.getX());
        double xx = xAxis.valueToJava2D(x, area, this.getDomainAxisEdge());
        ValueAxis yAxis = this.getRangeAxis();
        if (yAxis == null) {
            return;
        }
        double y = yAxis.getRange().constrain(this.quadrantOrigin.getY());
        double yy = yAxis.valueToJava2D(y, area, this.getRangeAxisEdge());
        double xmin = xAxis.getLowerBound();
        double xxmin = xAxis.valueToJava2D(xmin, area, this.getDomainAxisEdge());
        double xmax = xAxis.getUpperBound();
        double xxmax = xAxis.valueToJava2D(xmax, area, this.getDomainAxisEdge());
        double ymin = yAxis.getLowerBound();
        double yymin = yAxis.valueToJava2D(ymin, area, this.getRangeAxisEdge());
        double ymax = yAxis.getUpperBound();
        double yymax = yAxis.valueToJava2D(ymax, area, this.getRangeAxisEdge());
        Rectangle2D[] r = new Rectangle2D[4];
        if (this.quadrantPaint[0] != null && x > xmin && y < ymax) {
            r[0] = this.orientation == PlotOrientation.HORIZONTAL ? new Rectangle2D.Double(Math.min(yymax, yy), Math.min(xxmin, xx), Math.abs(yy - yymax), Math.abs(xx - xxmin)) : new Rectangle2D.Double(Math.min(xxmin, xx), Math.min(yymax, yy), Math.abs(xx - xxmin), Math.abs(yy - yymax));
            somethingToDraw = true;
        }
        if (this.quadrantPaint[1] != null && x < xmax && y < ymax) {
            r[1] = this.orientation == PlotOrientation.HORIZONTAL ? new Rectangle2D.Double(Math.min(yymax, yy), Math.min(xxmax, xx), Math.abs(yy - yymax), Math.abs(xx - xxmax)) : new Rectangle2D.Double(Math.min(xx, xxmax), Math.min(yymax, yy), Math.abs(xx - xxmax), Math.abs(yy - yymax));
            somethingToDraw = true;
        }
        if (this.quadrantPaint[2] != null && x > xmin && y > ymin) {
            r[2] = this.orientation == PlotOrientation.HORIZONTAL ? new Rectangle2D.Double(Math.min(yymin, yy), Math.min(xxmin, xx), Math.abs(yy - yymin), Math.abs(xx - xxmin)) : new Rectangle2D.Double(Math.min(xxmin, xx), Math.min(yymin, yy), Math.abs(xx - xxmin), Math.abs(yy - yymin));
            somethingToDraw = true;
        }
        if (this.quadrantPaint[3] != null && x < xmax && y > ymin) {
            r[3] = this.orientation == PlotOrientation.HORIZONTAL ? new Rectangle2D.Double(Math.min(yymin, yy), Math.min(xxmax, xx), Math.abs(yy - yymin), Math.abs(xx - xxmax)) : new Rectangle2D.Double(Math.min(xx, xxmax), Math.min(yymin, yy), Math.abs(xx - xxmax), Math.abs(yy - yymin));
            somethingToDraw = true;
        }
        if (somethingToDraw) {
            int i = 0;
            while (i < 4) {
                if (this.quadrantPaint[i] != null && r[i] != null) {
                    Paint paint = this.quadrantPaint[i];
                    paint.setStyle(Paint.Style.FILL);
                    int oldAlpha = paint.getAlpha();
                    paint.setAlpha(this.getBackgroundAlpha());
                    g2.drawRect((float)r[i].getMinX(), (float)r[i].getMinY(), (float)r[i].getMaxX(), (float)r[i].getMaxY(), paint);
                    paint.setAlpha(oldAlpha);
                }
                ++i;
            }
        }
    }

    public void drawDomainTickBands(Canvas g2, Rectangle2D dataArea, List ticks) {
        Paint bandPaint = this.getDomainTickBandPaint();
        if (bandPaint != null) {
            boolean fillBand = false;
            ValueAxis xAxis = this.getDomainAxis();
            double previous = xAxis.getLowerBound();
            for (ValueTick tick : ticks) {
                double current = tick.getValue();
                if (fillBand) {
                    this.getRenderer().fillDomainGridBand(g2, this, xAxis, dataArea, previous, current);
                }
                previous = current;
                boolean bl = fillBand = !fillBand;
            }
            double end = xAxis.getUpperBound();
            if (fillBand) {
                this.getRenderer().fillDomainGridBand(g2, this, xAxis, dataArea, previous, end);
            }
        }
    }

    public void drawRangeTickBands(Canvas g2, Rectangle2D dataArea, List ticks) {
        Paint bandPaint = this.getRangeTickBandPaint();
        if (bandPaint != null) {
            boolean fillBand = false;
            ValueAxis axis = this.getRangeAxis();
            double previous = axis.getLowerBound();
            for (ValueTick tick : ticks) {
                double current = tick.getValue();
                if (fillBand) {
                    this.getRenderer().fillRangeGridBand(g2, this, axis, dataArea, previous, current);
                }
                previous = current;
                boolean bl = fillBand = !fillBand;
            }
            double end = axis.getUpperBound();
            if (fillBand) {
                this.getRenderer().fillRangeGridBand(g2, this, axis, dataArea, previous, end);
            }
        }
    }

    protected Map drawAxes(Canvas g2, Rectangle2D plotArea, Rectangle2D dataArea, PlotRenderingInfo plotState) {
        AxisState info;
        AxisCollection axisCollection = new AxisCollection();
        int index = 0;
        while (index < this.domainAxes.size()) {
            ValueAxis axis = (ValueAxis)this.domainAxes.get(index);
            if (axis != null) {
                axisCollection.add(axis, this.getDomainAxisEdge(index));
            }
            ++index;
        }
        index = 0;
        while (index < this.rangeAxes.size()) {
            ValueAxis yAxis = (ValueAxis)this.rangeAxes.get(index);
            if (yAxis != null) {
                axisCollection.add(yAxis, this.getRangeAxisEdge(index));
            }
            ++index;
        }
        HashMap<ValueAxis, AxisState> axisStateMap = new HashMap<ValueAxis, AxisState>();
        double cursor = dataArea.getMinY() - this.axisOffset.calculateTopOutset(dataArea.getHeight());
        for (ValueAxis axis : axisCollection.getAxesAtTop()) {
            info = axis.draw(g2, cursor, plotArea, dataArea, RectangleEdge.TOP, plotState);
            cursor = info.getCursor();
            axisStateMap.put(axis, info);
        }
        cursor = dataArea.getMaxY() + this.axisOffset.calculateBottomOutset(dataArea.getHeight());
        for (ValueAxis axis : axisCollection.getAxesAtBottom()) {
            info = axis.draw(g2, cursor, plotArea, dataArea, RectangleEdge.BOTTOM, plotState);
            cursor = info.getCursor();
            axisStateMap.put(axis, info);
        }
        cursor = dataArea.getMinX() - this.axisOffset.calculateLeftOutset(dataArea.getWidth());
        for (ValueAxis axis : axisCollection.getAxesAtLeft()) {
            info = axis.draw(g2, cursor, plotArea, dataArea, RectangleEdge.LEFT, plotState);
            cursor = info.getCursor();
            axisStateMap.put(axis, info);
        }
        cursor = dataArea.getMaxX() + this.axisOffset.calculateRightOutset(dataArea.getWidth());
        for (ValueAxis axis : axisCollection.getAxesAtRight()) {
            info = axis.draw(g2, cursor, plotArea, dataArea, RectangleEdge.RIGHT, plotState);
            cursor = info.getCursor();
            axisStateMap.put(axis, info);
        }
        return axisStateMap;
    }

    public boolean render(Canvas g2, Rectangle2D dataArea, int index, PlotRenderingInfo info, CrosshairState crosshairState) {
        boolean foundData;
        block13: {
            foundData = false;
            XYDataset dataset = this.getDataset(index);
            if (DatasetUtilities.isEmptyOrNull(dataset)) break block13;
            foundData = true;
            ValueAxis xAxis = this.getDomainAxisForDataset(index);
            ValueAxis yAxis = this.getRangeAxisForDataset(index);
            if (xAxis == null || yAxis == null) {
                return foundData;
            }
            XYItemRenderer renderer = this.getRenderer(index);
            if (renderer == null && (renderer = this.getRenderer()) == null) {
                return foundData;
            }
            XYItemRendererState state = renderer.initialise(g2, dataArea, this, dataset, info);
            int passCount = renderer.getPassCount();
            SeriesRenderingOrder seriesOrder = this.getSeriesRenderingOrder();
            if (seriesOrder == SeriesRenderingOrder.REVERSE) {
                int pass = 0;
                while (pass < passCount) {
                    int seriesCount = dataset.getSeriesCount();
                    int series = seriesCount - 1;
                    while (series >= 0) {
                        int firstItem = 0;
                        int lastItem = dataset.getItemCount(series) - 1;
                        if (lastItem != -1) {
                            if (state.getProcessVisibleItemsOnly()) {
                                int[] itemBounds = RendererUtilities.findLiveItems(dataset, series, xAxis.getLowerBound(), xAxis.getUpperBound());
                                firstItem = Math.max(itemBounds[0] - 1, 0);
                                lastItem = Math.min(itemBounds[1] + 1, lastItem);
                            }
                            state.startSeriesPass(dataset, series, firstItem, lastItem, pass, passCount);
                            int item = firstItem;
                            while (item <= lastItem) {
                                renderer.drawItem(g2, state, dataArea, info, this, xAxis, yAxis, dataset, series, item, crosshairState, pass);
                                ++item;
                            }
                            state.endSeriesPass(dataset, series, firstItem, lastItem, pass, passCount);
                        }
                        --series;
                    }
                    ++pass;
                }
            } else {
                int pass = 0;
                while (pass < passCount) {
                    int seriesCount = dataset.getSeriesCount();
                    int series = 0;
                    while (series < seriesCount) {
                        int firstItem = 0;
                        int lastItem = dataset.getItemCount(series) - 1;
                        if (state.getProcessVisibleItemsOnly()) {
                            int[] itemBounds = RendererUtilities.findLiveItems(dataset, series, xAxis.getLowerBound(), xAxis.getUpperBound());
                            firstItem = Math.max(itemBounds[0] - 1, 0);
                            lastItem = Math.min(itemBounds[1] + 1, lastItem);
                        }
                        state.startSeriesPass(dataset, series, firstItem, lastItem, pass, passCount);
                        int item = firstItem;
                        while (item <= lastItem) {
                            renderer.drawItem(g2, state, dataArea, info, this, xAxis, yAxis, dataset, series, item, crosshairState, pass);
                            ++item;
                        }
                        state.endSeriesPass(dataset, series, firstItem, lastItem, pass, passCount);
                        ++series;
                    }
                    ++pass;
                }
            }
        }
        return foundData;
    }

    public ValueAxis getDomainAxisForDataset(int index) {
        int upper = Math.max(this.getDatasetCount(), this.getRendererCount());
        if (index < 0 || index >= upper) {
            throw new IllegalArgumentException("Index " + index + " out of bounds.");
        }
        ValueAxis valueAxis = null;
        List axisIndices = (List)this.datasetToDomainAxesMap.get(new Integer(index));
        if (axisIndices != null) {
            Integer axisIndex = (Integer)axisIndices.get(0);
            valueAxis = this.getDomainAxis(axisIndex);
        } else {
            valueAxis = this.getDomainAxis(0);
        }
        return valueAxis;
    }

    public ValueAxis getRangeAxisForDataset(int index) {
        int upper = Math.max(this.getDatasetCount(), this.getRendererCount());
        if (index < 0 || index >= upper) {
            throw new IllegalArgumentException("Index " + index + " out of bounds.");
        }
        ValueAxis valueAxis = null;
        List axisIndices = (List)this.datasetToRangeAxesMap.get(new Integer(index));
        if (axisIndices != null) {
            Integer axisIndex = (Integer)axisIndices.get(0);
            valueAxis = this.getRangeAxis(axisIndex);
        } else {
            valueAxis = this.getRangeAxis(0);
        }
        return valueAxis;
    }

    protected void drawDomainGridlines(Canvas g2, Rectangle2D dataArea, List ticks) {
        if (this.getRenderer() == null) {
            return;
        }
        if (this.isDomainGridlinesVisible() || this.isDomainMinorGridlinesVisible()) {
            Float gridStroke = null;
            Paint gridPaint = null;
            Iterator iterator = ticks.iterator();
            boolean paintLine = false;
            while (iterator.hasNext()) {
                paintLine = false;
                ValueTick tick = (ValueTick)iterator.next();
                if (tick.getTickType() == TickType.MINOR && this.isDomainMinorGridlinesVisible()) {
                    gridStroke = this.getDomainMinorGridlineStroke();
                    gridPaint = this.getDomainMinorGridlinePaint();
                    paintLine = true;
                } else if (tick.getTickType() == TickType.MAJOR && this.isDomainGridlinesVisible()) {
                    gridStroke = this.getDomainGridlineStroke();
                    gridPaint = this.getDomainGridlinePaint();
                    paintLine = true;
                }
                XYItemRenderer r = this.getRenderer();
                if (!(r instanceof AbstractXYItemRenderer) || !paintLine) continue;
                ((AbstractXYItemRenderer)r).drawDomainLine(g2, this, this.getDomainAxis(), dataArea, tick.getValue(), gridPaint, gridStroke);
            }
        }
    }

    protected void drawRangeGridlines(Canvas g2, Rectangle2D area, List ticks) {
        if (this.getRenderer() == null) {
            return;
        }
        if (this.isRangeGridlinesVisible() || this.isRangeMinorGridlinesVisible()) {
            Float gridStroke = null;
            Paint gridPaint = null;
            ValueAxis axis = this.getRangeAxis();
            if (axis != null) {
                Iterator iterator = ticks.iterator();
                boolean paintLine = false;
                while (iterator.hasNext()) {
                    paintLine = false;
                    ValueTick tick = (ValueTick)iterator.next();
                    if (tick.getTickType() == TickType.MINOR && this.isRangeMinorGridlinesVisible()) {
                        gridStroke = this.getRangeMinorGridlineStroke();
                        gridPaint = this.getRangeMinorGridlinePaint();
                        paintLine = true;
                    } else if (tick.getTickType() == TickType.MAJOR && this.isRangeGridlinesVisible()) {
                        gridStroke = this.getRangeGridlineStroke();
                        gridPaint = this.getRangeGridlinePaint();
                        paintLine = true;
                    }
                    if (tick.getValue() == 0.0 && this.isRangeZeroBaselineVisible() || !paintLine) continue;
                    this.getRenderer().drawRangeLine(g2, this, this.getRangeAxis(), area, tick.getValue(), gridPaint, gridStroke);
                }
            }
        }
    }

    protected void drawZeroDomainBaseline(Canvas g2, Rectangle2D area) {
        XYItemRenderer r;
        if (this.isDomainZeroBaselineVisible() && (r = this.getRenderer()) instanceof AbstractXYItemRenderer) {
            AbstractXYItemRenderer renderer = (AbstractXYItemRenderer)r;
            renderer.drawDomainLine(g2, this, this.getDomainAxis(), area, 0.0, this.domainZeroBaselinePaint, this.domainZeroBaselineStroke);
        }
    }

    protected void drawZeroRangeBaseline(Canvas g2, Rectangle2D area) {
        if (this.isRangeZeroBaselineVisible()) {
            this.getRenderer().drawRangeLine(g2, this, this.getRangeAxis(), area, 0.0, this.rangeZeroBaselinePaint, this.rangeZeroBaselineStroke);
        }
    }

    public void drawAnnotations(Canvas g2, Rectangle2D dataArea, PlotRenderingInfo info) {
        for (XYAnnotation annotation : this.annotations) {
            ValueAxis xAxis = this.getDomainAxis();
            ValueAxis yAxis = this.getRangeAxis();
            annotation.draw(g2, this, dataArea, xAxis, yAxis, 0, info);
        }
    }

    protected void drawDomainMarkers(Canvas g2, Rectangle2D dataArea, int index, Layer layer) {
        XYItemRenderer r = this.getRenderer(index);
        if (r == null) {
            return;
        }
        if (index >= this.getDatasetCount()) {
            return;
        }
        Collection markers = this.getDomainMarkers(index, layer);
        ValueAxis axis = this.getDomainAxisForDataset(index);
        if (markers != null && axis != null) {
            for (Marker marker : markers) {
                r.drawDomainMarker(g2, this, axis, marker, dataArea);
            }
        }
    }

    protected void drawRangeMarkers(Canvas g2, Rectangle2D dataArea, int index, Layer layer) {
        XYItemRenderer r = this.getRenderer(index);
        if (r == null) {
            return;
        }
        if (index >= this.getDatasetCount()) {
            return;
        }
        Collection markers = this.getRangeMarkers(index, layer);
        ValueAxis axis = this.getRangeAxisForDataset(index);
        if (markers != null && axis != null) {
            for (Marker marker : markers) {
                r.drawRangeMarker(g2, this, axis, marker, dataArea);
            }
        }
    }

    public Collection getDomainMarkers(Layer layer) {
        return this.getDomainMarkers(0, layer);
    }

    public Collection getRangeMarkers(Layer layer) {
        return this.getRangeMarkers(0, layer);
    }

    public Collection getDomainMarkers(int index, Layer layer) {
        Collection result = null;
        Integer key = new Integer(index);
        if (layer == Layer.FOREGROUND) {
            result = (Collection)this.foregroundDomainMarkers.get(key);
        } else if (layer == Layer.BACKGROUND) {
            result = (Collection)this.backgroundDomainMarkers.get(key);
        }
        if (result != null) {
            result = Collections.unmodifiableCollection(result);
        }
        return result;
    }

    public Collection getRangeMarkers(int index, Layer layer) {
        Collection result = null;
        Integer key = new Integer(index);
        if (layer == Layer.FOREGROUND) {
            result = (Collection)this.foregroundRangeMarkers.get(key);
        } else if (layer == Layer.BACKGROUND) {
            result = (Collection)this.backgroundRangeMarkers.get(key);
        }
        if (result != null) {
            result = Collections.unmodifiableCollection(result);
        }
        return result;
    }

    protected void drawHorizontalLine(Canvas g2, Rectangle2D dataArea, double value, Float stroke, Paint paint) {
        ValueAxis axis = this.getRangeAxis();
        if (this.getOrientation() == PlotOrientation.HORIZONTAL) {
            axis = this.getDomainAxis();
        }
        if (axis.getRange().contains(value)) {
            double yy = axis.valueToJava2D(value, dataArea, RectangleEdge.LEFT);
            Line2D.Double line = new Line2D.Double(dataArea.getMinX(), yy, dataArea.getMaxX(), yy);
            paint.setStyle(Paint.Style.STROKE);
            paint.setStrokeWidth(stroke.floatValue());
            g2.drawLine((float)((Line2D)line).getX1(), (float)((Line2D)line).getY1(), (float)((Line2D)line).getX2(), (float)((Line2D)line).getY2(), paint);
        }
    }

    protected void drawDomainCrosshair(Canvas g2, Rectangle2D dataArea, PlotOrientation orientation, double value, ValueAxis axis, Float stroke, Paint paint) {
        if (axis.getRange().contains(value)) {
            Line2D.Double line = null;
            if (orientation == PlotOrientation.VERTICAL) {
                double xx = axis.valueToJava2D(value, dataArea, RectangleEdge.BOTTOM);
                line = new Line2D.Double(xx, dataArea.getMinY(), xx, dataArea.getMaxY());
            } else {
                double yy = axis.valueToJava2D(value, dataArea, RectangleEdge.LEFT);
                line = new Line2D.Double(dataArea.getMinX(), yy, dataArea.getMaxX(), yy);
            }
            paint.setStyle(Paint.Style.STROKE);
            paint.setStrokeWidth(stroke.floatValue());
            g2.drawLine((float)((Line2D)line).getX1(), (float)((Line2D)line).getY1(), (float)((Line2D)line).getX2(), (float)((Line2D)line).getY2(), paint);
        }
    }

    protected void drawVerticalLine(Canvas g2, Rectangle2D dataArea, double value, Float stroke, Paint paint) {
        ValueAxis axis = this.getDomainAxis();
        if (this.getOrientation() == PlotOrientation.HORIZONTAL) {
            axis = this.getRangeAxis();
        }
        if (axis.getRange().contains(value)) {
            double xx = axis.valueToJava2D(value, dataArea, RectangleEdge.BOTTOM);
            Line2D.Double line = new Line2D.Double(xx, dataArea.getMinY(), xx, dataArea.getMaxY());
            paint.setStyle(Paint.Style.STROKE);
            paint.setStrokeWidth(stroke.floatValue());
            g2.drawLine((float)((Line2D)line).getX1(), (float)((Line2D)line).getY1(), (float)((Line2D)line).getX2(), (float)((Line2D)line).getY2(), paint);
        }
    }

    protected void drawRangeCrosshair(Canvas g2, Rectangle2D dataArea, PlotOrientation orientation, double value, ValueAxis axis, Float stroke, Paint paint) {
        if (axis.getRange().contains(value)) {
            Line2D.Double line = null;
            if (orientation == PlotOrientation.HORIZONTAL) {
                double xx = axis.valueToJava2D(value, dataArea, RectangleEdge.BOTTOM);
                line = new Line2D.Double(xx, dataArea.getMinY(), xx, dataArea.getMaxY());
            } else {
                double yy = axis.valueToJava2D(value, dataArea, RectangleEdge.LEFT);
                line = new Line2D.Double(dataArea.getMinX(), yy, dataArea.getMaxX(), yy);
            }
            paint.setStyle(Paint.Style.STROKE);
            paint.setStrokeWidth(stroke.floatValue());
            g2.drawLine((float)((Line2D)line).getX1(), (float)((Line2D)line).getY1(), (float)((Line2D)line).getX2(), (float)((Line2D)line).getY2(), paint);
        }
    }

    @Override
    public void handleClick(int x, int y, PlotRenderingInfo info) {
        Rectangle2D dataArea = info.getDataArea();
        if (dataArea.contains(x, y)) {
            ValueAxis yaxis;
            ValueAxis xaxis = this.getDomainAxis();
            if (xaxis != null) {
                double hvalue = xaxis.java2DToValue(x, info.getDataArea(), this.getDomainAxisEdge());
                this.setDomainCrosshairValue(hvalue);
            }
            if ((yaxis = this.getRangeAxis()) != null) {
                double vvalue = yaxis.java2DToValue(y, info.getDataArea(), this.getRangeAxisEdge());
                this.setRangeCrosshairValue(vvalue);
            }
        }
    }

    private List getDatasetsMappedToDomainAxis(Integer axisIndex) {
        if (axisIndex == null) {
            throw new IllegalArgumentException("Null 'axisIndex' argument.");
        }
        ArrayList<Object> result = new ArrayList<Object>();
        int i = 0;
        while (i < this.datasets.size()) {
            List mappedAxes = (List)this.datasetToDomainAxesMap.get(new Integer(i));
            if (mappedAxes == null) {
                if (axisIndex.equals(ZERO)) {
                    result.add(this.datasets.get(i));
                }
            } else if (mappedAxes.contains(axisIndex)) {
                result.add(this.datasets.get(i));
            }
            ++i;
        }
        return result;
    }

    private List getDatasetsMappedToRangeAxis(Integer axisIndex) {
        if (axisIndex == null) {
            throw new IllegalArgumentException("Null 'axisIndex' argument.");
        }
        ArrayList<Object> result = new ArrayList<Object>();
        int i = 0;
        while (i < this.datasets.size()) {
            List mappedAxes = (List)this.datasetToRangeAxesMap.get(new Integer(i));
            if (mappedAxes == null) {
                if (axisIndex.equals(ZERO)) {
                    result.add(this.datasets.get(i));
                }
            } else if (mappedAxes.contains(axisIndex)) {
                result.add(this.datasets.get(i));
            }
            ++i;
        }
        return result;
    }

    public int getDomainAxisIndex(ValueAxis axis) {
        Plot parent;
        int result = this.domainAxes.indexOf(axis);
        if (result < 0 && (parent = this.getParent()) instanceof XYPlot) {
            XYPlot p = (XYPlot)parent;
            result = p.getDomainAxisIndex(axis);
        }
        return result;
    }

    public int getRangeAxisIndex(ValueAxis axis) {
        Plot parent;
        int result = this.rangeAxes.indexOf(axis);
        if (result < 0 && (parent = this.getParent()) instanceof XYPlot) {
            XYPlot p = (XYPlot)parent;
            result = p.getRangeAxisIndex(axis);
        }
        return result;
    }

    @Override
    public Range getDataRange(ValueAxis axis) {
        int rangeIndex;
        Range result = null;
        ArrayList mappedDatasets = new ArrayList();
        ArrayList<XYAnnotation> includedAnnotations = new ArrayList<XYAnnotation>();
        boolean isDomainAxis = true;
        int domainIndex = this.getDomainAxisIndex(axis);
        if (domainIndex >= 0) {
            isDomainAxis = true;
            mappedDatasets.addAll(this.getDatasetsMappedToDomainAxis(new Integer(domainIndex)));
            if (domainIndex == 0) {
                for (XYAnnotation annotation : this.annotations) {
                    if (!(annotation instanceof XYAnnotationBoundsInfo)) continue;
                    includedAnnotations.add(annotation);
                }
            }
        }
        if ((rangeIndex = this.getRangeAxisIndex(axis)) >= 0) {
            isDomainAxis = false;
            mappedDatasets.addAll(this.getDatasetsMappedToRangeAxis(new Integer(rangeIndex)));
            if (rangeIndex == 0) {
                for (XYAnnotation annotation : this.annotations) {
                    if (!(annotation instanceof XYAnnotationBoundsInfo)) continue;
                    includedAnnotations.add(annotation);
                }
            }
        }
        for (XYDataset d : mappedDatasets) {
            if (d == null) continue;
            XYItemRenderer xYItemRenderer = this.getRendererForDataset(d);
            result = isDomainAxis ? (xYItemRenderer != null ? Range.combine(result, xYItemRenderer.findDomainBounds(d)) : Range.combine(result, DatasetUtilities.findDomainBounds(d))) : (xYItemRenderer != null ? Range.combine(result, xYItemRenderer.findRangeBounds(d)) : Range.combine(result, DatasetUtilities.findRangeBounds(d)));
            if (!(xYItemRenderer instanceof AbstractXYItemRenderer)) continue;
            AbstractXYItemRenderer rr = (AbstractXYItemRenderer)xYItemRenderer;
            Collection c = rr.getAnnotations();
            for (XYAnnotation a : c) {
                if (!(a instanceof XYAnnotationBoundsInfo)) continue;
                includedAnnotations.add(a);
            }
        }
        for (XYAnnotationBoundsInfo xYAnnotationBoundsInfo : includedAnnotations) {
            if (!xYAnnotationBoundsInfo.getIncludeInDataBounds()) continue;
            result = isDomainAxis ? Range.combine(result, xYAnnotationBoundsInfo.getXRange()) : Range.combine(result, xYAnnotationBoundsInfo.getYRange());
        }
        return result;
    }

    @Override
    public void rendererChanged(RendererChangeEvent event) {
        if (event.getSeriesVisibilityChanged()) {
            this.configureDomainAxes();
            this.configureRangeAxes();
        }
    }

    public boolean isDomainCrosshairVisible() {
        return this.domainCrosshairVisible;
    }

    public void setDomainCrosshairVisible(boolean flag) {
        if (this.domainCrosshairVisible != flag) {
            this.domainCrosshairVisible = flag;
        }
    }

    public boolean isDomainCrosshairLockedOnData() {
        return this.domainCrosshairLockedOnData;
    }

    public void setDomainCrosshairLockedOnData(boolean flag) {
        if (this.domainCrosshairLockedOnData != flag) {
            this.domainCrosshairLockedOnData = flag;
        }
    }

    public double getDomainCrosshairValue() {
        return this.domainCrosshairValue;
    }

    public void setDomainCrosshairValue(double value) {
        this.setDomainCrosshairValue(value, true);
    }

    public void setDomainCrosshairValue(double value, boolean notify) {
        this.domainCrosshairValue = value;
        if (this.isDomainCrosshairVisible()) {
            // empty if block
        }
    }

    public Float getDomainCrosshairStroke() {
        return this.domainCrosshairStroke;
    }

    public void setDomainCrosshairStroke(Float stroke) {
        if (stroke == null) {
            throw new IllegalArgumentException("Null 'stroke' argument.");
        }
        this.domainCrosshairStroke = stroke;
    }

    public Paint getDomainCrosshairPaint() {
        return this.domainCrosshairPaint;
    }

    public void setDomainCrosshairPaint(Paint paint) {
        if (paint == null) {
            throw new IllegalArgumentException("Null 'paint' argument.");
        }
        this.domainCrosshairPaint = paint;
    }

    public boolean isRangeCrosshairVisible() {
        return this.rangeCrosshairVisible;
    }

    public void setRangeCrosshairVisible(boolean flag) {
        if (this.rangeCrosshairVisible != flag) {
            this.rangeCrosshairVisible = flag;
        }
    }

    public boolean isRangeCrosshairLockedOnData() {
        return this.rangeCrosshairLockedOnData;
    }

    public void setRangeCrosshairLockedOnData(boolean flag) {
        if (this.rangeCrosshairLockedOnData != flag) {
            this.rangeCrosshairLockedOnData = flag;
        }
    }

    public double getRangeCrosshairValue() {
        return this.rangeCrosshairValue;
    }

    public void setRangeCrosshairValue(double value) {
        this.setRangeCrosshairValue(value, true);
    }

    public void setRangeCrosshairValue(double value, boolean notify) {
        this.rangeCrosshairValue = value;
        if (this.isRangeCrosshairVisible()) {
            // empty if block
        }
    }

    public Float getRangeCrosshairStroke() {
        return this.rangeCrosshairStroke;
    }

    public void setRangeCrosshairStroke(Float stroke) {
        if (stroke == null) {
            throw new IllegalArgumentException("Null 'stroke' argument.");
        }
        this.rangeCrosshairStroke = stroke;
    }

    public Paint getRangeCrosshairPaint() {
        return this.rangeCrosshairPaint;
    }

    public void setRangeCrosshairPaint(Paint paint) {
        if (paint == null) {
            throw new IllegalArgumentException("Null 'paint' argument.");
        }
        this.rangeCrosshairPaint = paint;
    }

    public AxisSpace getFixedDomainAxisSpace() {
        return this.fixedDomainAxisSpace;
    }

    public void setFixedDomainAxisSpace(AxisSpace space) {
        this.setFixedDomainAxisSpace(space, true);
    }

    public void setFixedDomainAxisSpace(AxisSpace space, boolean notify) {
        this.fixedDomainAxisSpace = space;
    }

    public AxisSpace getFixedRangeAxisSpace() {
        return this.fixedRangeAxisSpace;
    }

    public void setFixedRangeAxisSpace(AxisSpace space) {
        this.setFixedRangeAxisSpace(space, true);
    }

    public void setFixedRangeAxisSpace(AxisSpace space, boolean notify) {
        this.fixedRangeAxisSpace = space;
    }

    @Override
    public boolean isDomainPannable() {
        return this.domainPannable;
    }

    public void setDomainPannable(boolean pannable) {
        this.domainPannable = pannable;
    }

    @Override
    public boolean isRangePannable() {
        return this.rangePannable;
    }

    public void setRangePannable(boolean pannable) {
        this.rangePannable = pannable;
    }

    @Override
    public void panDomainAxes(double percent, PlotRenderingInfo info, Point2D source) {
        if (!this.isDomainPannable()) {
            return;
        }
        int domainAxisCount = this.getDomainAxisCount();
        int i = 0;
        while (i < domainAxisCount) {
            ValueAxis axis = this.getDomainAxis(i);
            if (axis != null) {
                if (axis.isInverted()) {
                    percent = -percent;
                }
                axis.pan(percent);
            }
            ++i;
        }
    }

    @Override
    public void panRangeAxes(double percent, PlotRenderingInfo info, Point2D source) {
        if (!this.isRangePannable()) {
            return;
        }
        int rangeAxisCount = this.getRangeAxisCount();
        int i = 0;
        while (i < rangeAxisCount) {
            ValueAxis axis = this.getRangeAxis(i);
            if (axis != null) {
                if (axis.isInverted()) {
                    percent = -percent;
                }
                axis.pan(percent);
            }
            ++i;
        }
    }

    @Override
    public void zoomDomainAxes(double factor, PlotRenderingInfo info, Point2D source) {
        this.zoomDomainAxes(factor, info, source, false);
    }

    @Override
    public void zoomDomainAxes(double factor, PlotRenderingInfo info, Point2D source, boolean useAnchor) {
        int i = 0;
        while (i < this.domainAxes.size()) {
            ValueAxis domainAxis = (ValueAxis)this.domainAxes.get(i);
            if (domainAxis != null) {
                if (useAnchor) {
                    double sourceX = source.getX();
                    if (this.orientation == PlotOrientation.HORIZONTAL) {
                        sourceX = source.getY();
                    }
                    double anchorX = domainAxis.java2DToValue(sourceX, info.getDataArea(), this.getDomainAxisEdge());
                    domainAxis.resizeRange2(factor, anchorX);
                } else {
                    domainAxis.resizeRange(factor);
                }
            }
            ++i;
        }
    }

    @Override
    public void zoomDomainAxes(double lowerPercent, double upperPercent, PlotRenderingInfo info, Point2D source) {
        int i = 0;
        while (i < this.domainAxes.size()) {
            ValueAxis domainAxis = (ValueAxis)this.domainAxes.get(i);
            if (domainAxis != null) {
                domainAxis.zoomRange(lowerPercent, upperPercent);
            }
            ++i;
        }
    }

    @Override
    public void zoomRangeAxes(double factor, PlotRenderingInfo info, Point2D source) {
        this.zoomRangeAxes(factor, info, source, false);
    }

    @Override
    public void zoomRangeAxes(double factor, PlotRenderingInfo info, Point2D source, boolean useAnchor) {
        int i = 0;
        while (i < this.rangeAxes.size()) {
            ValueAxis rangeAxis = (ValueAxis)this.rangeAxes.get(i);
            if (rangeAxis != null) {
                if (useAnchor) {
                    double sourceY = source.getY();
                    if (this.orientation == PlotOrientation.HORIZONTAL) {
                        sourceY = source.getX();
                    }
                    double anchorY = rangeAxis.java2DToValue(sourceY, info.getDataArea(), this.getRangeAxisEdge());
                    rangeAxis.resizeRange2(factor, anchorY);
                } else {
                    rangeAxis.resizeRange(factor);
                }
            }
            ++i;
        }
    }

    @Override
    public void zoomRangeAxes(double lowerPercent, double upperPercent, PlotRenderingInfo info, Point2D source) {
        int i = 0;
        while (i < this.rangeAxes.size()) {
            ValueAxis rangeAxis = (ValueAxis)this.rangeAxes.get(i);
            if (rangeAxis != null) {
                rangeAxis.zoomRange(lowerPercent, upperPercent);
            }
            ++i;
        }
    }

    @Override
    public boolean isDomainZoomable() {
        return true;
    }

    @Override
    public boolean isRangeZoomable() {
        return true;
    }

    public int getSeriesCount() {
        int result = 0;
        XYDataset dataset = this.getDataset();
        if (dataset != null) {
            result = dataset.getSeriesCount();
        }
        return result;
    }

    public LegendItemCollection getFixedLegendItems() {
        return this.fixedLegendItems;
    }

    public void setFixedLegendItems(LegendItemCollection items) {
        this.fixedLegendItems = items;
    }

    @Override
    public LegendItemCollection getLegendItems() {
        if (this.fixedLegendItems != null) {
            return this.fixedLegendItems;
        }
        LegendItemCollection result = new LegendItemCollection();
        int count = this.datasets.size();
        int datasetIndex = 0;
        while (datasetIndex < count) {
            XYDataset dataset = this.getDataset(datasetIndex);
            if (dataset != null) {
                XYItemRenderer renderer = this.getRenderer(datasetIndex);
                if (renderer == null) {
                    renderer = this.getRenderer(0);
                }
                if (renderer != null) {
                    int seriesCount = dataset.getSeriesCount();
                    int i = 0;
                    while (i < seriesCount) {
                        LegendItem item;
                        if (renderer.isSeriesVisible(i) && renderer.isSeriesVisibleInLegend(i) && (item = renderer.getLegendItem(datasetIndex, i)) != null) {
                            result.add(item);
                        }
                        ++i;
                    }
                }
            }
            ++datasetIndex;
        }
        return result;
    }
}

