/*
 * Decompiled with CFR 0.152.
 */
package com.androidplot.ui.widget.renderer;

import android.graphics.Canvas;
import android.graphics.RectF;
import android.graphics.Region;
import com.androidplot.Plot;
import com.androidplot.exception.PlotRenderException;
import com.androidplot.series.Series;
import com.androidplot.ui.widget.formatter.Formatter;

public abstract class DataRenderer<PlotType extends Plot, SeriesFormatterType extends Formatter> {
    private PlotType a;

    public DataRenderer(PlotType PlotType) {
        this.a = PlotType;
    }

    public PlotType getPlot() {
        return this.a;
    }

    public void setPlot(PlotType PlotType) {
        this.a = PlotType;
    }

    public SeriesFormatterType getFormatter(Series series) {
        return (SeriesFormatterType)((Plot)((Object)this.a)).getFormatter((Series)series, this.getClass());
    }

    public void render(Canvas canvas, RectF rectF) throws PlotRenderException {
        this.onRender(canvas, rectF);
    }

    public abstract void onRender(Canvas var1, RectF var2) throws PlotRenderException;

    protected abstract void doDrawLegendIcon(Canvas var1, RectF var2, String var3, SeriesFormatterType var4);

    public void drawLegendIcon(Canvas canvas, RectF rectF, String string, SeriesFormatterType SeriesFormatterType) {
        int n = canvas.save(2);
        canvas.clipRect(rectF, Region.Op.INTERSECT);
        this.doDrawLegendIcon(canvas, rectF, string, SeriesFormatterType);
        canvas.restoreToCount(n);
    }
}

