/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cordova;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.cordova.GeoListener;
import org.apache.cordova.api.Plugin;
import org.apache.cordova.api.PluginResult;
import org.json.JSONArray;
import org.json.JSONException;

public class GeoBroker
extends Plugin {
    private HashMap<String, GeoListener> geoListeners = new HashMap();
    private GeoListener global;

    public PluginResult execute(String action, JSONArray args, String callbackId) {
        PluginResult.Status status = PluginResult.Status.OK;
        String result = "";
        try {
            if (action.equals("getCurrentLocation")) {
                this.getCurrentLocation(args.getBoolean(0), args.getInt(1), args.getInt(2));
            } else {
                if (action.equals("start")) {
                    String s = this.start(args.getString(0), args.getBoolean(1), args.getInt(2), args.getInt(3));
                    return new PluginResult(status, s);
                }
                if (action.equals("stop")) {
                    this.stop(args.getString(0));
                }
            }
            return new PluginResult(status, result);
        }
        catch (JSONException e) {
            return new PluginResult(PluginResult.Status.JSON_EXCEPTION);
        }
    }

    public boolean isSynch(String action) {
        return true;
    }

    public void onDestroy() {
        Set<Map.Entry<String, GeoListener>> s = this.geoListeners.entrySet();
        for (Map.Entry<String, GeoListener> entry : s) {
            GeoListener listener = entry.getValue();
            listener.destroy();
        }
        this.geoListeners.clear();
        if (this.global != null) {
            this.global.destroy();
        }
        this.global = null;
    }

    public void getCurrentLocation(boolean enableHighAccuracy, int timeout, int maximumAge) {
        if (this.global == null) {
            this.global = new GeoListener(this, "global", maximumAge);
        } else {
            this.global.start(maximumAge);
        }
    }

    public String start(String key, boolean enableHighAccuracy, int timeout, int maximumAge) {
        GeoListener listener = this.geoListeners.get(key);
        if (listener == null) {
            listener = new GeoListener(this, key, maximumAge);
            this.geoListeners.put(key, listener);
        }
        listener.start(maximumAge);
        return key;
    }

    public void stop(String key) {
        GeoListener listener = this.geoListeners.remove(key);
        if (listener != null) {
            listener.stop();
        }
    }
}

