/*
 * Decompiled with CFR 0.152.
 */
package net.droidsolutions.droidcharts.core.plot;

import android.graphics.Paint;
import java.io.Serializable;
import net.droidsolutions.droidcharts.awt.Ellipse2D;
import net.droidsolutions.droidcharts.awt.Polygon;
import net.droidsolutions.droidcharts.awt.Rectangle2D;
import net.droidsolutions.droidcharts.awt.Shape;
import net.droidsolutions.droidcharts.core.ChartColor;
import net.droidsolutions.droidcharts.core.plot.DrawingSupplier;

public class DefaultDrawingSupplier
implements DrawingSupplier,
Cloneable,
Serializable {
    private static final long serialVersionUID = -7339847061039422538L;
    public static final Paint[] DEFAULT_PAINT_SEQUENCE = ChartColor.createDefaultPaintArray();
    public static final Paint white = new Paint(1);
    public static final Paint ltGray;
    public static final Paint[] DEFAULT_OUTLINE_PAINT_SEQUENCE;
    public static final Paint[] DEFAULT_FILL_PAINT_SEQUENCE;
    public static final float[] DEFAULT_STROKE_SEQUENCE;
    public static final float[] DEFAULT_OUTLINE_STROKE_SEQUENCE;
    public static final Shape[] DEFAULT_SHAPE_SEQUENCE;
    private transient Paint[] paintSequence;
    private int paintIndex;
    private transient Paint[] outlinePaintSequence;
    private int outlinePaintIndex;
    private transient Paint[] fillPaintSequence;
    private int fillPaintIndex;
    private transient float[] strokeSequence;
    private int strokeIndex;
    private transient float[] outlineStrokeSequence;
    private int outlineStrokeIndex;
    private transient Shape[] shapeSequence;
    private int shapeIndex;

    static {
        white.setColor(-1);
        ltGray = new Paint(1);
        ltGray.setColor(-3355444);
        DEFAULT_OUTLINE_PAINT_SEQUENCE = new Paint[]{ltGray};
        DEFAULT_FILL_PAINT_SEQUENCE = new Paint[]{white};
        DEFAULT_STROKE_SEQUENCE = new float[]{5.0f};
        DEFAULT_OUTLINE_STROKE_SEQUENCE = new float[]{1.0f};
        DEFAULT_SHAPE_SEQUENCE = DefaultDrawingSupplier.createStandardSeriesShapes();
    }

    public DefaultDrawingSupplier() {
        this(DEFAULT_PAINT_SEQUENCE, DEFAULT_FILL_PAINT_SEQUENCE, DEFAULT_OUTLINE_PAINT_SEQUENCE, DEFAULT_STROKE_SEQUENCE, DEFAULT_OUTLINE_STROKE_SEQUENCE, DEFAULT_SHAPE_SEQUENCE);
    }

    public DefaultDrawingSupplier(Paint[] paintSequence, Paint[] outlinePaintSequence, float[] strokeSequence, float[] outlineStrokeSequence, Shape[] shapeSequence) {
        this.paintSequence = paintSequence;
        this.fillPaintSequence = DEFAULT_FILL_PAINT_SEQUENCE;
        this.outlinePaintSequence = outlinePaintSequence;
        this.strokeSequence = strokeSequence;
        this.outlineStrokeSequence = outlineStrokeSequence;
        this.shapeSequence = shapeSequence;
    }

    public DefaultDrawingSupplier(Paint[] paintSequence, Paint[] fillPaintSequence, Paint[] outlinePaintSequence, float[] strokeSequence, float[] outlineStrokeSequence, Shape[] shapeSequence) {
        this.paintSequence = paintSequence;
        this.fillPaintSequence = fillPaintSequence;
        this.outlinePaintSequence = outlinePaintSequence;
        this.strokeSequence = strokeSequence;
        this.outlineStrokeSequence = outlineStrokeSequence;
        this.shapeSequence = shapeSequence;
    }

    @Override
    public Paint getNextPaint() {
        Paint result = this.paintSequence[this.paintIndex % this.paintSequence.length];
        ++this.paintIndex;
        return result;
    }

    @Override
    public Paint getNextOutlinePaint() {
        Paint result = this.outlinePaintSequence[this.outlinePaintIndex % this.outlinePaintSequence.length];
        ++this.outlinePaintIndex;
        return result;
    }

    @Override
    public Paint getNextFillPaint() {
        Paint result = this.fillPaintSequence[this.fillPaintIndex % this.fillPaintSequence.length];
        ++this.fillPaintIndex;
        return result;
    }

    @Override
    public float getNextStroke() {
        float result = this.strokeSequence[this.strokeIndex % this.strokeSequence.length];
        ++this.strokeIndex;
        return result;
    }

    @Override
    public float getNextOutlineStroke() {
        float result = this.outlineStrokeSequence[this.outlineStrokeIndex % this.outlineStrokeSequence.length];
        ++this.outlineStrokeIndex;
        return result;
    }

    @Override
    public Shape getNextShape() {
        Shape result = this.shapeSequence[this.shapeIndex % this.shapeSequence.length];
        ++this.shapeIndex;
        return result;
    }

    public static Shape[] createStandardSeriesShapes() {
        Shape[] result = new Shape[10];
        double size = 6.0;
        double delta = size / 2.0;
        int[] xpoints = null;
        int[] ypoints = null;
        result[0] = new Rectangle2D.Double(-delta, -delta, size, size);
        result[1] = new Ellipse2D.Double(-delta, -delta, size, size);
        xpoints = DefaultDrawingSupplier.intArray(0.0, delta, -delta);
        ypoints = DefaultDrawingSupplier.intArray(-delta, delta, delta);
        result[2] = new Polygon(xpoints, ypoints, 3);
        xpoints = DefaultDrawingSupplier.intArray(0.0, delta, 0.0, -delta);
        ypoints = DefaultDrawingSupplier.intArray(-delta, 0.0, delta, 0.0);
        result[3] = new Polygon(xpoints, ypoints, 4);
        result[4] = new Rectangle2D.Double(-delta, -delta / 2.0, size, size / 2.0);
        xpoints = DefaultDrawingSupplier.intArray(-delta, delta, 0.0);
        ypoints = DefaultDrawingSupplier.intArray(-delta, -delta, delta);
        result[5] = new Polygon(xpoints, ypoints, 3);
        result[6] = new Ellipse2D.Double(-delta, -delta / 2.0, size, size / 2.0);
        xpoints = DefaultDrawingSupplier.intArray(-delta, delta, -delta);
        ypoints = DefaultDrawingSupplier.intArray(-delta, 0.0, delta);
        result[7] = new Polygon(xpoints, ypoints, 3);
        result[8] = new Rectangle2D.Double(-delta / 2.0, -delta, size / 2.0, size);
        xpoints = DefaultDrawingSupplier.intArray(-delta, delta, delta);
        ypoints = DefaultDrawingSupplier.intArray(0.0, -delta, delta);
        result[9] = new Polygon(xpoints, ypoints, 3);
        return result;
    }

    private static int[] intArray(double a, double b, double c) {
        return new int[]{(int)a, (int)b, (int)c};
    }

    private static int[] intArray(double a, double b, double c, double d) {
        return new int[]{(int)a, (int)b, (int)c, (int)d};
    }
}

