/*
 * Decompiled with CFR 0.152.
 */
package net.droidsolutions.droidcharts.core.block;

import android.graphics.Canvas;
import android.graphics.Paint;
import java.io.Serializable;
import net.droidsolutions.droidcharts.awt.Line2D;
import net.droidsolutions.droidcharts.awt.Rectangle2D;
import net.droidsolutions.droidcharts.common.RectangleInsets;
import net.droidsolutions.droidcharts.core.block.BlockFrame;

public class LineBorder
implements BlockFrame,
Serializable {
    static final long serialVersionUID = 4630356736707233924L;
    private transient Paint paint;
    private transient float stroke;
    private RectangleInsets insets;

    public LineBorder() {
        this(-16777216, 1.0f, new RectangleInsets(1.0, 1.0, 1.0, 1.0));
    }

    public LineBorder(int paint, float stroke, RectangleInsets insets) {
        if (insets == null) {
            throw new IllegalArgumentException("Null 'insets' argument.");
        }
        Paint p = new Paint(1);
        p.setColor(paint);
        this.paint = p;
        this.stroke = stroke;
        this.insets = insets;
    }

    public Paint getPaint() {
        return this.paint;
    }

    @Override
    public RectangleInsets getInsets() {
        return this.insets;
    }

    public float getStroke() {
        return this.stroke;
    }

    @Override
    public void draw(Canvas g2, Rectangle2D area) {
        double w = area.getWidth();
        double h = area.getHeight();
        if (w <= 0.0 || h <= 0.0) {
            return;
        }
        double t = this.insets.calculateTopInset(h);
        double b = this.insets.calculateBottomInset(h);
        double l = this.insets.calculateLeftInset(w);
        double r = this.insets.calculateRightInset(w);
        double x = area.getX();
        double y = area.getY();
        double x0 = x + l / 2.0;
        double x1 = x + w - r / 2.0;
        double y0 = y + h - b / 2.0;
        double y1 = y + t / 2.0;
        this.getPaint().setStrokeWidth(this.getStroke());
        Line2D.Double line = new Line2D.Double();
        if (t > 0.0) {
            ((Line2D)line).setLine(x0, y1, x1, y1);
            g2.drawLine((float)((Line2D)line).getX1(), (float)((Line2D)line).getY1(), (float)((Line2D)line).getX2(), (float)((Line2D)line).getY2(), this.getPaint());
        }
        if (b > 0.0) {
            ((Line2D)line).setLine(x0, y0, x1, y0);
            g2.drawLine((float)((Line2D)line).getX1(), (float)((Line2D)line).getY1(), (float)((Line2D)line).getX2(), (float)((Line2D)line).getY2(), this.getPaint());
        }
        if (l > 0.0) {
            ((Line2D)line).setLine(x0, y0, x0, y1);
            g2.drawLine((float)((Line2D)line).getX1(), (float)((Line2D)line).getY1(), (float)((Line2D)line).getX2(), (float)((Line2D)line).getY2(), this.getPaint());
        }
        if (r > 0.0) {
            ((Line2D)line).setLine(x1, y0, x1, y1);
            g2.drawLine((float)((Line2D)line).getX1(), (float)((Line2D)line).getY1(), (float)((Line2D)line).getX2(), (float)((Line2D)line).getY2(), this.getPaint());
        }
    }
}

