/*
 * Decompiled with CFR 0.152.
 */
package net.droidsolutions.droidcharts.common;

import java.io.Serializable;
import java.util.Arrays;

public class AbstractObjectList
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 7789833772597351595L;
    public static final int DEFAULT_INITIAL_CAPACITY = 8;
    private transient Object[] objects;
    private int size = 0;
    private int increment = 8;

    protected AbstractObjectList() {
        this(8);
    }

    protected AbstractObjectList(int initialCapacity) {
        this(initialCapacity, initialCapacity);
    }

    protected AbstractObjectList(int initialCapacity, int increment) {
        this.objects = new Object[initialCapacity];
        this.increment = increment;
    }

    protected Object get(int index) {
        Object result = null;
        if (index >= 0 && index < this.size) {
            result = this.objects[index];
        }
        return result;
    }

    protected void set(int index, Object object) {
        if (index < 0) {
            throw new IllegalArgumentException("Requires index >= 0.");
        }
        if (index >= this.objects.length) {
            Object[] enlarged = new Object[index + this.increment];
            System.arraycopy(this.objects, 0, enlarged, 0, this.objects.length);
            this.objects = enlarged;
        }
        this.objects[index] = object;
        this.size = Math.max(this.size, index + 1);
    }

    public void clear() {
        Arrays.fill(this.objects, null);
        this.size = 0;
    }

    public int size() {
        return this.size;
    }

    protected int indexOf(Object object) {
        int index = 0;
        while (index < this.size) {
            if (this.objects[index] == object) {
                return index;
            }
            ++index;
        }
        return -1;
    }
}

