/*
 * Decompiled with CFR 0.152.
 */
package org.achartengine.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.achartengine.model.XYSeries;

public class CategorySeries
implements Serializable {
    private String mTitle;
    private List<String> mCategories = new ArrayList<String>();
    private List<Double> mValues = new ArrayList<Double>();

    public CategorySeries(String string) {
        this.mTitle = string;
    }

    public String getTitle() {
        return this.mTitle;
    }

    public void add(double d) {
        this.add(this.mCategories.size() + "", d);
    }

    public void add(String string, double d) {
        this.mCategories.add(string);
        this.mValues.add(d);
    }

    public void remove(int n) {
        this.mCategories.remove(n);
        this.mValues.remove(n);
    }

    public void clear() {
        this.mCategories.clear();
        this.mValues.clear();
    }

    public double getValue(int n) {
        return this.mValues.get(n);
    }

    public String getCategory(int n) {
        return this.mCategories.get(n);
    }

    public int getItemCount() {
        return this.mCategories.size();
    }

    public XYSeries toXYSeries() {
        XYSeries xYSeries = new XYSeries(this.mTitle);
        int n = 0;
        for (double d : this.mValues) {
            xYSeries.add(++n, d);
        }
        return xYSeries;
    }
}

