/*
 * Decompiled with CFR 0.152.
 */
package net.droidsolutions.droidcharts.core.data.general;

import java.util.List;
import net.droidsolutions.droidcharts.core.data.BoxAndWhiskerCategoryDataset;
import net.droidsolutions.droidcharts.core.data.CategoryDataset;
import net.droidsolutions.droidcharts.core.data.CategoryRangeInfo;
import net.droidsolutions.droidcharts.core.data.DefaultCategoryDataset;
import net.droidsolutions.droidcharts.core.data.DomainInfo;
import net.droidsolutions.droidcharts.core.data.IntervalCategoryDataset;
import net.droidsolutions.droidcharts.core.data.IntervalXYDataset;
import net.droidsolutions.droidcharts.core.data.OHLCDataset;
import net.droidsolutions.droidcharts.core.data.PieDataset;
import net.droidsolutions.droidcharts.core.data.Range;
import net.droidsolutions.droidcharts.core.data.RangeInfo;
import net.droidsolutions.droidcharts.core.data.StatisticalCategoryDataset;
import net.droidsolutions.droidcharts.core.data.XYDataset;
import net.droidsolutions.droidcharts.core.data.xy.XYDomainInfo;
import net.droidsolutions.droidcharts.core.data.xy.XYRangeInfo;

public final class DatasetUtilities {
    private DatasetUtilities() {
    }

    public static boolean isEmptyOrNull(CategoryDataset dataset) {
        if (dataset == null) {
            return true;
        }
        int rowCount = dataset.getRowCount();
        int columnCount = dataset.getColumnCount();
        if (rowCount == 0 || columnCount == 0) {
            return true;
        }
        int r = 0;
        while (r < rowCount) {
            int c = 0;
            while (c < columnCount) {
                if (dataset.getValue(r, c) != null) {
                    return false;
                }
                ++c;
            }
            ++r;
        }
        return true;
    }

    public static Range findRangeBounds(CategoryDataset dataset, List visibleSeriesKeys, boolean includeInterval) {
        if (dataset == null) {
            throw new IllegalArgumentException("Null 'dataset' argument.");
        }
        Range result = null;
        if (dataset instanceof CategoryRangeInfo) {
            CategoryRangeInfo info = (CategoryRangeInfo)((Object)dataset);
            result = info.getRangeBounds(visibleSeriesKeys, includeInterval);
        } else {
            result = DatasetUtilities.iterateToFindRangeBounds(dataset, visibleSeriesKeys, includeInterval);
        }
        return result;
    }

    public static Range iterateToFindRangeBounds(CategoryDataset dataset, List visibleSeriesKeys, boolean includeInterval) {
        if (dataset == null) {
            throw new IllegalArgumentException("Null 'dataset' argument.");
        }
        if (visibleSeriesKeys == null) {
            throw new IllegalArgumentException("Null 'visibleSeriesKeys' argument.");
        }
        double minimum = Double.POSITIVE_INFINITY;
        double maximum = Double.NEGATIVE_INFINITY;
        int columnCount = dataset.getColumnCount();
        if (includeInterval && dataset instanceof BoxAndWhiskerCategoryDataset) {
            BoxAndWhiskerCategoryDataset bx = (BoxAndWhiskerCategoryDataset)dataset;
            for (Comparable seriesKey : visibleSeriesKeys) {
                int series = dataset.getRowIndex(seriesKey);
                int itemCount = dataset.getColumnCount();
                int item = 0;
                while (item < itemCount) {
                    Number uvalue;
                    Number lvalue = bx.getMinRegularValue(series, item);
                    if (lvalue == null) {
                        lvalue = bx.getValue(series, item);
                    }
                    if ((uvalue = bx.getMaxRegularValue(series, item)) == null) {
                        uvalue = bx.getValue(series, item);
                    }
                    if (lvalue != null) {
                        minimum = Math.min(minimum, lvalue.doubleValue());
                    }
                    if (uvalue != null) {
                        maximum = Math.max(maximum, uvalue.doubleValue());
                    }
                    ++item;
                }
            }
        } else if (includeInterval && dataset instanceof IntervalCategoryDataset) {
            IntervalCategoryDataset icd = (IntervalCategoryDataset)dataset;
            for (Comparable seriesKey : visibleSeriesKeys) {
                int series = dataset.getRowIndex(seriesKey);
                int column = 0;
                while (column < columnCount) {
                    Number lvalue = icd.getStartValue(series, column);
                    Number uvalue = icd.getEndValue(series, column);
                    if (lvalue != null && !Double.isNaN(lvalue.doubleValue())) {
                        minimum = Math.min(minimum, lvalue.doubleValue());
                    }
                    if (uvalue != null && !Double.isNaN(uvalue.doubleValue())) {
                        maximum = Math.max(maximum, uvalue.doubleValue());
                    }
                    ++column;
                }
            }
        } else if (includeInterval && dataset instanceof StatisticalCategoryDataset) {
            StatisticalCategoryDataset scd = (StatisticalCategoryDataset)dataset;
            for (Comparable seriesKey : visibleSeriesKeys) {
                int series = dataset.getRowIndex(seriesKey);
                int column = 0;
                while (column < columnCount) {
                    Number meanN = scd.getMeanValue(series, column);
                    if (meanN != null) {
                        double mean;
                        double std = 0.0;
                        Number stdN = scd.getStdDevValue(series, column);
                        if (stdN != null && Double.isNaN(std = stdN.doubleValue())) {
                            std = 0.0;
                        }
                        if (!Double.isNaN(mean = meanN.doubleValue())) {
                            minimum = Math.min(minimum, mean - std);
                            maximum = Math.max(maximum, mean + std);
                        }
                    }
                    ++column;
                }
            }
        } else {
            for (Comparable seriesKey : visibleSeriesKeys) {
                int series = dataset.getRowIndex(seriesKey);
                int column = 0;
                while (column < columnCount) {
                    double v;
                    Number value = dataset.getValue(series, column);
                    if (value != null && !Double.isNaN(v = value.doubleValue())) {
                        minimum = Math.min(minimum, v);
                        maximum = Math.max(maximum, v);
                    }
                    ++column;
                }
            }
        }
        if (minimum == Double.POSITIVE_INFINITY) {
            return null;
        }
        return new Range(minimum, maximum);
    }

    public static Range findRangeBounds(XYDataset dataset, boolean includeInterval) {
        if (dataset == null) {
            throw new IllegalArgumentException("Null 'dataset' argument.");
        }
        Range result = null;
        if (dataset instanceof RangeInfo) {
            RangeInfo info = (RangeInfo)((Object)dataset);
            result = info.getRangeBounds(includeInterval);
        } else {
            result = DatasetUtilities.iterateRangeBounds(dataset, includeInterval);
        }
        return result;
    }

    public static Range findRangeBounds(CategoryDataset dataset, boolean includeInterval) {
        if (dataset == null) {
            throw new IllegalArgumentException("Null 'dataset' argument.");
        }
        Range result = null;
        if (dataset instanceof RangeInfo) {
            RangeInfo info = (RangeInfo)((Object)dataset);
            result = info.getRangeBounds(includeInterval);
        } else {
            result = DatasetUtilities.iterateRangeBounds(dataset, includeInterval);
        }
        return result;
    }

    public static Range findRangeBounds(CategoryDataset dataset) {
        return DatasetUtilities.findRangeBounds(dataset, true);
    }

    public static Range iterateRangeBounds(CategoryDataset dataset, boolean includeInterval) {
        double minimum = Double.POSITIVE_INFINITY;
        double maximum = Double.NEGATIVE_INFINITY;
        int rowCount = dataset.getRowCount();
        int columnCount = dataset.getColumnCount();
        if (includeInterval && dataset instanceof IntervalCategoryDataset) {
            IntervalCategoryDataset icd = (IntervalCategoryDataset)dataset;
            int row = 0;
            while (row < rowCount) {
                int column = 0;
                while (column < columnCount) {
                    Number lvalue = icd.getStartValue(row, column);
                    Number uvalue = icd.getEndValue(row, column);
                    if (lvalue != null && !Double.isNaN(lvalue.doubleValue())) {
                        minimum = Math.min(minimum, lvalue.doubleValue());
                    }
                    if (uvalue != null && !Double.isNaN(uvalue.doubleValue())) {
                        maximum = Math.max(maximum, uvalue.doubleValue());
                    }
                    ++column;
                }
                ++row;
            }
        } else {
            int row = 0;
            while (row < rowCount) {
                int column = 0;
                while (column < columnCount) {
                    double v;
                    Number value = dataset.getValue(row, column);
                    if (value != null && !Double.isNaN(v = value.doubleValue())) {
                        minimum = Math.min(minimum, v);
                        maximum = Math.max(maximum, v);
                    }
                    ++column;
                }
                ++row;
            }
        }
        if (minimum == Double.POSITIVE_INFINITY) {
            return null;
        }
        return new Range(minimum, maximum);
    }

    public static Range iterateRangeBounds(XYDataset dataset, boolean includeInterval) {
        double minimum = Double.POSITIVE_INFINITY;
        double maximum = Double.NEGATIVE_INFINITY;
        int seriesCount = dataset.getSeriesCount();
        if (includeInterval && dataset instanceof IntervalXYDataset) {
            IntervalXYDataset ixyd = (IntervalXYDataset)dataset;
            int series = 0;
            while (series < seriesCount) {
                int itemCount = dataset.getItemCount(series);
                int item = 0;
                while (item < itemCount) {
                    double lvalue = ixyd.getStartYValue(series, item);
                    double uvalue = ixyd.getEndYValue(series, item);
                    if (!Double.isNaN(lvalue)) {
                        minimum = Math.min(minimum, lvalue);
                    }
                    if (!Double.isNaN(uvalue)) {
                        maximum = Math.max(maximum, uvalue);
                    }
                    ++item;
                }
                ++series;
            }
        } else if (includeInterval && dataset instanceof OHLCDataset) {
            OHLCDataset ohlc = (OHLCDataset)dataset;
            int series = 0;
            while (series < seriesCount) {
                int itemCount = dataset.getItemCount(series);
                int item = 0;
                while (item < itemCount) {
                    double lvalue = ohlc.getLowValue(series, item);
                    double uvalue = ohlc.getHighValue(series, item);
                    if (!Double.isNaN(lvalue)) {
                        minimum = Math.min(minimum, lvalue);
                    }
                    if (!Double.isNaN(uvalue)) {
                        maximum = Math.max(maximum, uvalue);
                    }
                    ++item;
                }
                ++series;
            }
        } else {
            int series = 0;
            while (series < seriesCount) {
                int itemCount = dataset.getItemCount(series);
                int item = 0;
                while (item < itemCount) {
                    double value = dataset.getYValue(series, item);
                    if (!Double.isNaN(value)) {
                        minimum = Math.min(minimum, value);
                        maximum = Math.max(maximum, value);
                    }
                    ++item;
                }
                ++series;
            }
        }
        if (minimum == Double.POSITIVE_INFINITY) {
            return null;
        }
        return new Range(minimum, maximum);
    }

    public static CategoryDataset createCategoryDataset(String rowKeyPrefix, String columnKeyPrefix, double[][] data) {
        DefaultCategoryDataset result = new DefaultCategoryDataset();
        int r = 0;
        while (r < data.length) {
            String rowKey = String.valueOf(rowKeyPrefix) + (r + 1);
            int c = 0;
            while (c < data[r].length) {
                String columnKey = String.valueOf(columnKeyPrefix) + (c + 1);
                result.addValue(new Double(data[r][c]), (Comparable)((Object)rowKey), (Comparable)((Object)columnKey));
                ++c;
            }
            ++r;
        }
        return result;
    }

    public static double calculatePieDatasetTotal(PieDataset dataset) {
        if (dataset == null) {
            throw new IllegalArgumentException("Null 'dataset' argument.");
        }
        List keys = dataset.getKeys();
        double totalValue = 0.0;
        for (Comparable current : keys) {
            if (current == null) continue;
            Number value = dataset.getValue(current);
            double v = 0.0;
            if (value != null) {
                v = value.doubleValue();
            }
            if (!(v > 0.0)) continue;
            totalValue += v;
        }
        return totalValue;
    }

    public static boolean isEmptyOrNull(PieDataset dataset) {
        if (dataset == null) {
            return true;
        }
        int itemCount = dataset.getItemCount();
        if (itemCount == 0) {
            return true;
        }
        int item = 0;
        while (item < itemCount) {
            double yy;
            Number y = dataset.getValue(item);
            if (y != null && (yy = y.doubleValue()) > 0.0) {
                return false;
            }
            ++item;
        }
        return true;
    }

    public static boolean isEmptyOrNull(XYDataset dataset) {
        if (dataset != null) {
            int s = 0;
            while (s < dataset.getSeriesCount()) {
                if (dataset.getItemCount(s) > 0) {
                    return false;
                }
                ++s;
            }
        }
        return true;
    }

    public static Range findDomainBounds(XYDataset dataset) {
        return DatasetUtilities.findDomainBounds(dataset, true);
    }

    public static Range findDomainBounds(XYDataset dataset, boolean includeInterval) {
        if (dataset == null) {
            throw new IllegalArgumentException("Null 'dataset' argument.");
        }
        Range result = null;
        if (dataset instanceof DomainInfo) {
            DomainInfo info = (DomainInfo)((Object)dataset);
            result = info.getDomainBounds(includeInterval);
        } else {
            result = DatasetUtilities.iterateDomainBounds(dataset, includeInterval);
        }
        return result;
    }

    public static Range findDomainBounds(XYDataset dataset, List visibleSeriesKeys, boolean includeInterval) {
        if (dataset == null) {
            throw new IllegalArgumentException("Null 'dataset' argument.");
        }
        Range result = null;
        if (dataset instanceof XYDomainInfo) {
            XYDomainInfo info = (XYDomainInfo)((Object)dataset);
            result = info.getDomainBounds(visibleSeriesKeys, includeInterval);
        } else {
            result = DatasetUtilities.iterateToFindDomainBounds(dataset, visibleSeriesKeys, includeInterval);
        }
        return result;
    }

    public static Range iterateDomainBounds(XYDataset dataset) {
        return DatasetUtilities.iterateDomainBounds(dataset, true);
    }

    public static Range iterateDomainBounds(XYDataset dataset, boolean includeInterval) {
        if (dataset == null) {
            throw new IllegalArgumentException("Null 'dataset' argument.");
        }
        double minimum = Double.POSITIVE_INFINITY;
        double maximum = Double.NEGATIVE_INFINITY;
        int seriesCount = dataset.getSeriesCount();
        if (includeInterval && dataset instanceof IntervalXYDataset) {
            IntervalXYDataset intervalXYData = (IntervalXYDataset)dataset;
            int series = 0;
            while (series < seriesCount) {
                int itemCount = dataset.getItemCount(series);
                int item = 0;
                while (item < itemCount) {
                    double lvalue = intervalXYData.getStartXValue(series, item);
                    double uvalue = intervalXYData.getEndXValue(series, item);
                    if (!Double.isNaN(lvalue)) {
                        minimum = Math.min(minimum, lvalue);
                    }
                    if (!Double.isNaN(uvalue)) {
                        maximum = Math.max(maximum, uvalue);
                    }
                    ++item;
                }
                ++series;
            }
        } else {
            int series = 0;
            while (series < seriesCount) {
                int itemCount = dataset.getItemCount(series);
                int item = 0;
                while (item < itemCount) {
                    double lvalue;
                    double uvalue = lvalue = dataset.getXValue(series, item);
                    if (!Double.isNaN(lvalue)) {
                        minimum = Math.min(minimum, lvalue);
                        maximum = Math.max(maximum, uvalue);
                    }
                    ++item;
                }
                ++series;
            }
        }
        if (minimum > maximum) {
            return null;
        }
        return new Range(minimum, maximum);
    }

    public static Range findRangeBounds(XYDataset dataset) {
        return DatasetUtilities.findRangeBounds(dataset, true);
    }

    public static Range findRangeBounds(XYDataset dataset, List visibleSeriesKeys, Range xRange, boolean includeInterval) {
        if (dataset == null) {
            throw new IllegalArgumentException("Null 'dataset' argument.");
        }
        Range result = null;
        if (dataset instanceof XYRangeInfo) {
            XYRangeInfo info = (XYRangeInfo)((Object)dataset);
            result = info.getRangeBounds(visibleSeriesKeys, xRange, includeInterval);
        } else {
            result = DatasetUtilities.iterateToFindRangeBounds(dataset, visibleSeriesKeys, xRange, includeInterval);
        }
        return result;
    }

    public static Range iterateXYRangeBounds(XYDataset dataset) {
        return DatasetUtilities.iterateRangeBounds(dataset);
    }

    public static Range iterateRangeBounds(XYDataset dataset) {
        return DatasetUtilities.iterateRangeBounds(dataset, true);
    }

    public static Range iterateToFindRangeBounds(XYDataset dataset, List visibleSeriesKeys, Range xRange, boolean includeInterval) {
        if (dataset == null) {
            throw new IllegalArgumentException("Null 'dataset' argument.");
        }
        if (visibleSeriesKeys == null) {
            throw new IllegalArgumentException("Null 'visibleSeriesKeys' argument.");
        }
        if (xRange == null) {
            throw new IllegalArgumentException("Null 'xRange' argument");
        }
        double minimum = Double.POSITIVE_INFINITY;
        double maximum = Double.NEGATIVE_INFINITY;
        if (includeInterval && dataset instanceof OHLCDataset) {
            OHLCDataset ohlc = (OHLCDataset)dataset;
            for (Comparable seriesKey : visibleSeriesKeys) {
                int series = dataset.indexOf(seriesKey);
                int itemCount = dataset.getItemCount(series);
                int item = 0;
                while (item < itemCount) {
                    double x = ohlc.getXValue(series, item);
                    if (xRange.contains(x)) {
                        double lvalue = ohlc.getLowValue(series, item);
                        double uvalue = ohlc.getHighValue(series, item);
                        if (!Double.isNaN(lvalue)) {
                            minimum = Math.min(minimum, lvalue);
                        }
                        if (!Double.isNaN(uvalue)) {
                            maximum = Math.max(maximum, uvalue);
                        }
                    }
                    ++item;
                }
            }
        } else if (includeInterval && dataset instanceof IntervalXYDataset) {
            IntervalXYDataset ixyd = (IntervalXYDataset)dataset;
            for (Comparable seriesKey : visibleSeriesKeys) {
                int series = dataset.indexOf(seriesKey);
                int itemCount = dataset.getItemCount(series);
                int item = 0;
                while (item < itemCount) {
                    double x = ixyd.getXValue(series, item);
                    if (xRange.contains(x)) {
                        double lvalue = ixyd.getStartYValue(series, item);
                        double uvalue = ixyd.getEndYValue(series, item);
                        if (!Double.isNaN(lvalue)) {
                            minimum = Math.min(minimum, lvalue);
                        }
                        if (!Double.isNaN(uvalue)) {
                            maximum = Math.max(maximum, uvalue);
                        }
                    }
                    ++item;
                }
            }
        } else {
            for (Comparable seriesKey : visibleSeriesKeys) {
                int series = dataset.indexOf(seriesKey);
                int itemCount = dataset.getItemCount(series);
                int item = 0;
                while (item < itemCount) {
                    double x = dataset.getXValue(series, item);
                    double y = dataset.getYValue(series, item);
                    if (xRange.contains(x) && !Double.isNaN(y)) {
                        minimum = Math.min(minimum, y);
                        maximum = Math.max(maximum, y);
                    }
                    ++item;
                }
            }
        }
        if (minimum == Double.POSITIVE_INFINITY) {
            return null;
        }
        return new Range(minimum, maximum);
    }

    public static Range iterateToFindDomainBounds(XYDataset dataset, List visibleSeriesKeys, boolean includeInterval) {
        if (dataset == null) {
            throw new IllegalArgumentException("Null 'dataset' argument.");
        }
        if (visibleSeriesKeys == null) {
            throw new IllegalArgumentException("Null 'visibleSeriesKeys' argument.");
        }
        double minimum = Double.POSITIVE_INFINITY;
        double maximum = Double.NEGATIVE_INFINITY;
        if (includeInterval && dataset instanceof IntervalXYDataset) {
            IntervalXYDataset ixyd = (IntervalXYDataset)dataset;
            for (Comparable seriesKey : visibleSeriesKeys) {
                int series = dataset.indexOf(seriesKey);
                int itemCount = dataset.getItemCount(series);
                int item = 0;
                while (item < itemCount) {
                    double lvalue = ixyd.getStartXValue(series, item);
                    double uvalue = ixyd.getEndXValue(series, item);
                    if (!Double.isNaN(lvalue)) {
                        minimum = Math.min(minimum, lvalue);
                    }
                    if (!Double.isNaN(uvalue)) {
                        maximum = Math.max(maximum, uvalue);
                    }
                    ++item;
                }
            }
        } else {
            for (Comparable seriesKey : visibleSeriesKeys) {
                int series = dataset.indexOf(seriesKey);
                int itemCount = dataset.getItemCount(series);
                int item = 0;
                while (item < itemCount) {
                    double x = dataset.getXValue(series, item);
                    if (!Double.isNaN(x)) {
                        minimum = Math.min(minimum, x);
                        maximum = Math.max(maximum, x);
                    }
                    ++item;
                }
            }
        }
        if (minimum == Double.POSITIVE_INFINITY) {
            return null;
        }
        return new Range(minimum, maximum);
    }
}

