/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.android.robotium.solo;

import android.app.Instrumentation;
import android.os.SystemClock;
import android.view.MotionEvent;
import android.view.View;
import android.widget.AbsListView;
import android.widget.GridView;
import android.widget.ListView;
import android.widget.ScrollView;
import com.jayway.android.robotium.solo.ActivityUtils;
import com.jayway.android.robotium.solo.RobotiumUtils;
import com.jayway.android.robotium.solo.Sleeper;
import com.jayway.android.robotium.solo.ViewFetcher;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Scroller {
    public static final int DOWN = 0;
    public static final int UP = 1;
    private final Instrumentation inst;
    private final ActivityUtils activityUtils;
    private final ViewFetcher viewFetcher;
    private final Sleeper sleeper;

    public Scroller(Instrumentation inst, ActivityUtils activityUtils, ViewFetcher viewFetcher, Sleeper sleeper) {
        this.inst = inst;
        this.activityUtils = activityUtils;
        this.viewFetcher = viewFetcher;
        this.sleeper = sleeper;
    }

    public void drag(float fromX, float toX, float fromY, float toY, int stepCount) {
        long downTime = SystemClock.uptimeMillis();
        long eventTime = SystemClock.uptimeMillis();
        float y = fromY;
        float x = fromX;
        float yStep = (toY - fromY) / (float)stepCount;
        float xStep = (toX - fromX) / (float)stepCount;
        MotionEvent event = MotionEvent.obtain((long)downTime, (long)eventTime, (int)0, (float)fromX, (float)fromY, (int)0);
        try {
            this.inst.sendPointerSync(event);
        }
        catch (SecurityException ignored) {
            // empty catch block
        }
        for (int i = 0; i < stepCount; ++i) {
            eventTime = SystemClock.uptimeMillis();
            event = MotionEvent.obtain((long)downTime, (long)eventTime, (int)2, (float)(x += xStep), (float)(y += yStep), (int)0);
            try {
                this.inst.sendPointerSync(event);
                continue;
            }
            catch (SecurityException ignored) {
                // empty catch block
            }
        }
        eventTime = SystemClock.uptimeMillis();
        event = MotionEvent.obtain((long)downTime, (long)eventTime, (int)1, (float)toX, (float)toY, (int)0);
        try {
            this.inst.sendPointerSync(event);
        }
        catch (SecurityException ignored) {
            // empty catch block
        }
    }

    private boolean scrollScrollView(int direction, ArrayList<ScrollView> scrollViews) {
        ScrollView scroll = this.viewFetcher.getView(ScrollView.class, scrollViews);
        int scrollAmount = 0;
        if (scroll != null) {
            int height = scroll.getHeight();
            --height;
            int scrollTo = 0;
            if (direction == 0) {
                scrollTo = height;
            } else if (direction == 1) {
                scrollTo = -height;
            }
            scrollAmount = scroll.getScrollY();
            this.scrollScrollViewTo(scroll, 0, scrollTo);
            return scrollAmount != scroll.getScrollY();
        }
        return false;
    }

    private void scrollScrollViewTo(final ScrollView scrollView, final int x, final int y) {
        this.inst.runOnMainSync(new Runnable(){

            public void run() {
                scrollView.scrollBy(x, y);
            }
        });
    }

    public boolean scroll(int direction) {
        ArrayList<View> viewList = RobotiumUtils.removeInvisibleViews(this.viewFetcher.getViews(null, true));
        ArrayList<ListView> listViews = RobotiumUtils.filterViews(ListView.class, viewList);
        if (listViews.size() > 0) {
            return this.scrollList(ListView.class, null, direction, listViews);
        }
        ArrayList<GridView> gridViews = RobotiumUtils.filterViews(GridView.class, viewList);
        if (gridViews.size() > 0) {
            return this.scrollList(GridView.class, null, direction, gridViews);
        }
        ArrayList<ScrollView> scrollViews = RobotiumUtils.filterViews(ScrollView.class, viewList);
        if (scrollViews.size() > 0) {
            return this.scrollScrollView(direction, scrollViews);
        }
        return false;
    }

    public <T extends AbsListView> boolean scrollList(Class<T> classToFilterBy, ListView listView, int direction, ArrayList<T> listViews) {
        if (listView == null) {
            listView = (ListView)this.viewFetcher.getView(classToFilterBy, listViews);
        }
        if (listView == null) {
            return false;
        }
        if (direction == 0) {
            if (listView.getLastVisiblePosition() >= listView.getCount() - 1) {
                this.scrollListToLine(listView, listView.getLastVisiblePosition());
                return false;
            }
            if (listView.getFirstVisiblePosition() != listView.getLastVisiblePosition()) {
                this.scrollListToLine(listView, listView.getLastVisiblePosition());
            } else {
                this.scrollListToLine(listView, listView.getFirstVisiblePosition() + 1);
            }
        } else if (direction == 1) {
            if (listView.getFirstVisiblePosition() < 2) {
                this.scrollListToLine(listView, 0);
                return false;
            }
            int lines = listView.getLastVisiblePosition() - listView.getFirstVisiblePosition();
            int lineToScrollTo = listView.getFirstVisiblePosition() - lines;
            if (lineToScrollTo == listView.getLastVisiblePosition()) {
                --lineToScrollTo;
            }
            if (lineToScrollTo < 0) {
                lineToScrollTo = 0;
            }
            this.scrollListToLine(listView, lineToScrollTo);
        }
        this.sleeper.sleep();
        return true;
    }

    private <T extends AbsListView> void scrollListToLine(final T view, int line) {
        final int lineToMoveTo = view instanceof GridView ? line + 1 : line;
        this.inst.runOnMainSync(new Runnable(){

            public void run() {
                view.setSelection(lineToMoveTo);
            }
        });
    }

    public void scrollToSide(Side side) {
        int screenHeight = this.activityUtils.getCurrentActivity().getWindowManager().getDefaultDisplay().getHeight();
        int screenWidth = this.activityUtils.getCurrentActivity(false).getWindowManager().getDefaultDisplay().getWidth();
        float x = (float)screenWidth / 2.0f;
        float y = (float)screenHeight / 2.0f;
        if (side == Side.LEFT) {
            this.drag(0.0f, x, y, y, 40);
        } else if (side == Side.RIGHT) {
            this.drag(x, 0.0f, y, y, 40);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Side {
        LEFT,
        RIGHT;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Direction {
        UP,
        DOWN;

    }
}

