/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.android.robotium.solo;

import android.app.Instrumentation;
import android.view.View;
import com.jayway.android.robotium.solo.Sleeper;
import java.util.ArrayList;
import junit.framework.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class RobotiumUtils {
    private final Instrumentation inst;
    private final Sleeper sleeper;

    public RobotiumUtils(Instrumentation inst, Sleeper sleeper) {
        this.inst = inst;
        this.sleeper = sleeper;
    }

    public void goBack() {
        this.sleeper.sleep();
        try {
            this.inst.sendKeyDownUpSync(4);
            this.sleeper.sleep();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void sendKeyCode(int keycode) {
        this.sleeper.sleep();
        try {
            this.inst.sendCharacterSync(keycode);
        }
        catch (SecurityException e) {
            Assert.assertTrue((String)"Can not complete action!", (boolean)false);
        }
    }

    public static <T extends View> ArrayList<T> removeInvisibleViews(ArrayList<T> viewList) {
        ArrayList<View> tmpViewList = new ArrayList<View>(viewList.size());
        for (View view : viewList) {
            if (view == null || !view.isShown()) continue;
            tmpViewList.add(view);
        }
        return tmpViewList;
    }

    public static <T extends View> ArrayList<T> filterViews(Class<T> classToFilterBy, ArrayList<View> viewList) {
        ArrayList<T> filteredViews = new ArrayList<T>(viewList.size());
        for (View view : viewList) {
            if (view == null || !classToFilterBy.isAssignableFrom(view.getClass())) continue;
            filteredViews.add(classToFilterBy.cast(view));
        }
        viewList = null;
        return filteredViews;
    }
}

