/*
 * Decompiled with CFR 0.152.
 */
package net.droidsolutions.droidcharts.core.text;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import java.text.BreakIterator;
import net.droidsolutions.droidcharts.awt.Font;
import net.droidsolutions.droidcharts.awt.Rectangle;
import net.droidsolutions.droidcharts.awt.Rectangle2D;
import net.droidsolutions.droidcharts.awt.RectangularShape;
import net.droidsolutions.droidcharts.common.TextAnchor;
import net.droidsolutions.droidcharts.core.text.TextBlock;
import net.droidsolutions.droidcharts.core.text.TextMeasurer;

public abstract class TextUtilities {
    private static boolean useFontMetricsGetStringBounds = false;

    public static TextBlock createTextBlock(String text, Font font, Paint paint, float maxWidth, TextMeasurer measurer) {
        return TextUtilities.createTextBlock(text, font, paint, maxWidth, Integer.MAX_VALUE, measurer);
    }

    public static TextBlock createTextBlock(String text, Font font, Paint paint) {
        if (text == null) {
            throw new IllegalArgumentException("Null 'text' argument.");
        }
        TextBlock result = new TextBlock();
        String input = text;
        boolean moreInputToProcess = text.length() > 0;
        boolean start = false;
        while (moreInputToProcess) {
            int index = input.indexOf("\n");
            if (index > 0) {
                String line = input.substring(0, index);
                if (index < input.length() - 1) {
                    result.addLine(line, font, paint);
                    input = input.substring(index + 1);
                    continue;
                }
                moreInputToProcess = false;
                continue;
            }
            if (index == 0) {
                if (index < input.length() - 1) {
                    input = input.substring(index + 1);
                    continue;
                }
                moreInputToProcess = false;
                continue;
            }
            result.addLine(input, font, paint);
            moreInputToProcess = false;
        }
        return result;
    }

    public static TextBlock createTextBlock(String text, Font font, Paint paint, float maxWidth, int maxLines, TextMeasurer measurer) {
        TextBlock result = new TextBlock();
        BreakIterator iterator = BreakIterator.getLineInstance();
        iterator.setText(text);
        int current = 0;
        int lines = 0;
        int length = text.length();
        while (current < length && lines < maxLines) {
            int next = TextUtilities.nextLineBreak(text, current, maxWidth, iterator, measurer);
            if (next == -1) {
                result.addLine(text.substring(current), font, paint);
                return result;
            }
            result.addLine(text.substring(current, next), font, paint);
            ++lines;
            current = next;
        }
        return result;
    }

    private static int nextLineBreak(String text, int start, float width, BreakIterator iterator, TextMeasurer measurer) {
        int end;
        int current = start;
        float x = 0.0f;
        boolean firstWord = true;
        while ((end = iterator.next()) != -1) {
            if ((x += measurer.getStringWidth(text, current, end)) > width) {
                if (firstWord) {
                    while (measurer.getStringWidth(text, start, end) > width) {
                        --end;
                    }
                    return end;
                }
                end = iterator.previous();
                return end;
            }
            firstWord = false;
            current = end;
        }
        return -1;
    }

    public static Rectangle2D getTextBounds(String text, Paint fm) {
        Rect bounds = new Rect();
        fm.getTextBounds(text, 0, text.length(), bounds);
        return new Rectangle(bounds.width(), bounds.height());
    }

    public static boolean getUseFontMetricsGetStringBounds() {
        return useFontMetricsGetStringBounds;
    }

    public static void setUseFontMetricsGetStringBounds(boolean use) {
        useFontMetricsGetStringBounds = use;
    }

    public static void drawRotatedString(String text, Canvas g2, float x, float y, TextAnchor textAnchor, double angle, TextAnchor rotationAnchor, Paint paint) {
        if (text == null || text.equals("")) {
            return;
        }
        g2.save();
        if (angle == 0.0) {
            g2.drawText(text, x, y, paint);
        } else {
            g2.rotate((float)angle, x, y);
            g2.drawText(text, x, y, paint);
        }
        g2.restore();
    }

    public static Rectangle2D drawAlignedString(String text, Canvas g2, float x, float y, TextAnchor anchor, Paint paint) {
        Rectangle2D.Double textBounds = new Rectangle2D.Double();
        float[] adjust = TextUtilities.deriveTextBoundsAnchorOffsets(g2, text, anchor, textBounds, paint);
        ((Rectangle2D)textBounds).setRect(x + adjust[0], y + adjust[1] + adjust[2], ((RectangularShape)textBounds).getWidth(), ((RectangularShape)textBounds).getHeight());
        g2.drawText(text, x, y, paint);
        return textBounds;
    }

    private static float[] deriveTextBoundsAnchorOffsets(Canvas g2, String text, TextAnchor anchor, Rectangle2D textBounds, Paint paint) {
        float[] result = new float[3];
        Rectangle2D bounds = TextUtilities.getTextBounds(text, paint);
        float ascent = paint.ascent();
        result[2] = -ascent;
        float halfAscent = ascent / 2.0f;
        float descent = paint.descent();
        float xAdj = 0.0f;
        float yAdj = 0.0f;
        if (anchor == TextAnchor.TOP_CENTER || anchor == TextAnchor.CENTER || anchor == TextAnchor.BOTTOM_CENTER || anchor == TextAnchor.BASELINE_CENTER || anchor == TextAnchor.HALF_ASCENT_CENTER) {
            xAdj = (float)(-bounds.getWidth()) / 2.0f;
        } else if (anchor == TextAnchor.TOP_RIGHT || anchor == TextAnchor.CENTER_RIGHT || anchor == TextAnchor.BOTTOM_RIGHT || anchor == TextAnchor.BASELINE_RIGHT || anchor == TextAnchor.HALF_ASCENT_RIGHT) {
            xAdj = (float)(-bounds.getWidth());
        }
        if (anchor == TextAnchor.TOP_LEFT || anchor == TextAnchor.TOP_CENTER || anchor == TextAnchor.TOP_RIGHT) {
            yAdj = -descent + (float)bounds.getHeight();
        } else if (anchor == TextAnchor.HALF_ASCENT_LEFT || anchor == TextAnchor.HALF_ASCENT_CENTER || anchor == TextAnchor.HALF_ASCENT_RIGHT) {
            yAdj = halfAscent;
        } else if (anchor == TextAnchor.CENTER_LEFT || anchor == TextAnchor.CENTER || anchor == TextAnchor.CENTER_RIGHT) {
            yAdj = -descent + (float)(bounds.getHeight() / 2.0);
        } else if (anchor == TextAnchor.BASELINE_LEFT || anchor == TextAnchor.BASELINE_CENTER || anchor == TextAnchor.BASELINE_RIGHT) {
            yAdj = 0.0f;
        } else if (anchor == TextAnchor.BOTTOM_LEFT || anchor == TextAnchor.BOTTOM_CENTER || anchor == TextAnchor.BOTTOM_RIGHT) {
            yAdj = -paint.descent();
        }
        if (textBounds != null) {
            textBounds.setRect(bounds);
        }
        result[0] = xAdj;
        result[1] = yAdj;
        return result;
    }
}

