/*
 * Decompiled with CFR 0.152.
 */
package net.droidsolutions.droidcharts.core.renderer;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.drawable.GradientDrawable;
import java.io.Serializable;
import net.droidsolutions.droidcharts.awt.Rectangle2D;
import net.droidsolutions.droidcharts.awt.RectangularShape;
import net.droidsolutions.droidcharts.common.RectangleEdge;
import net.droidsolutions.droidcharts.core.renderer.BarPainter;
import net.droidsolutions.droidcharts.core.renderer.BarRenderer;

public class GradientBarPainter
implements BarPainter,
Serializable {
    protected double g1;
    protected double g2;
    protected double g3;

    public GradientBarPainter() {
        this(0.1, 0.2, 0.8);
    }

    public GradientBarPainter(double g1, double g2, double g3) {
        this.g1 = g1;
        this.g2 = g2;
        this.g3 = g3;
    }

    @Override
    public void paintBar(Canvas g2, BarRenderer renderer, int row, int column, RectangularShape bar, RectangleEdge base) {
        int[] color2;
        Rectangle2D[] regions;
        Paint itemPaint = renderer.getItemPaint(row, column);
        if (base == RectangleEdge.TOP || base == RectangleEdge.BOTTOM) {
            regions = this.splitVerticalBar(bar, this.g1, this.g2, this.g3);
            color2 = new int[]{itemPaint.getColor(), -1};
            GradientDrawable grad = new GradientDrawable(GradientDrawable.Orientation.TOP_BOTTOM, color2);
            grad.setSize((int)regions[0].getWidth(), (int)regions[0].getHeight());
            grad.setBounds((int)regions[0].getMinX(), (int)regions[0].getMinY(), (int)regions[0].getMaxX(), (int)regions[0].getMaxY());
            grad.draw(g2);
            grad = new GradientDrawable(GradientDrawable.Orientation.TOP_BOTTOM, color2);
            grad.setSize((int)regions[1].getWidth(), (int)regions[1].getHeight());
            grad.setBounds((int)regions[1].getMinX(), (int)regions[1].getMinY(), (int)regions[1].getMaxX(), (int)regions[1].getMaxY());
            grad.draw(g2);
            grad = new GradientDrawable(GradientDrawable.Orientation.TOP_BOTTOM, color2);
            grad.setSize((int)regions[2].getWidth(), (int)regions[2].getHeight());
            grad.setBounds((int)regions[2].getMinX(), (int)regions[2].getMinY(), (int)regions[2].getMaxX(), (int)regions[2].getMaxY());
            grad.draw(g2);
            grad = new GradientDrawable(GradientDrawable.Orientation.TOP_BOTTOM, color2);
            grad.setSize((int)regions[3].getWidth(), (int)regions[3].getHeight());
            grad.setBounds((int)regions[3].getMinX(), (int)regions[3].getMinY(), (int)regions[3].getMaxX(), (int)regions[3].getMaxY());
            grad.draw(g2);
        } else if (base == RectangleEdge.LEFT || base == RectangleEdge.RIGHT) {
            regions = this.splitHorizontalBar(bar, this.g1, this.g2, this.g3);
            color2 = new int[]{itemPaint.getColor(), -1};
            GradientDrawable grad = new GradientDrawable(GradientDrawable.Orientation.TOP_BOTTOM, color2);
            grad.setSize((int)regions[0].getWidth(), (int)regions[0].getHeight());
            grad.setBounds((int)regions[0].getMinX(), (int)regions[0].getMinY(), (int)regions[0].getMaxX(), (int)regions[0].getMaxY());
            grad.draw(g2);
            grad = new GradientDrawable(GradientDrawable.Orientation.TOP_BOTTOM, color2);
            grad.setSize((int)regions[1].getWidth(), (int)regions[1].getHeight());
            grad.setBounds((int)regions[1].getMinX(), (int)regions[1].getMinY(), (int)regions[1].getMaxX(), (int)regions[1].getMaxY());
            grad.draw(g2);
            grad = new GradientDrawable(GradientDrawable.Orientation.TOP_BOTTOM, color2);
            grad.setSize((int)regions[2].getWidth(), (int)regions[2].getHeight());
            grad.setBounds((int)regions[2].getMinX(), (int)regions[2].getMinY(), (int)regions[2].getMaxX(), (int)regions[2].getMaxY());
            grad.draw(g2);
            grad = new GradientDrawable(GradientDrawable.Orientation.TOP_BOTTOM, color2);
            grad.setSize((int)regions[3].getWidth(), (int)regions[3].getHeight());
            grad.setBounds((int)regions[3].getMinX(), (int)regions[3].getMinY(), (int)regions[3].getMaxX(), (int)regions[3].getMaxY());
            grad.draw(g2);
        }
        if (renderer.isDrawBarOutline()) {
            float stroke = renderer.getItemOutlineStroke(row, column).floatValue();
            Paint paint = renderer.getItemOutlinePaint(row, column);
            if (stroke != 0.0f && paint != null) {
                paint.setStyle(Paint.Style.STROKE);
                paint.setStrokeWidth(stroke);
                g2.drawRect((float)bar.getMinX(), (float)bar.getMinY(), (float)bar.getMaxX(), (float)bar.getMaxY(), paint);
            }
        }
    }

    @Override
    public void paintBarShadow(Canvas g2, BarRenderer renderer, int row, int column, RectangularShape bar, RectangleEdge base, boolean pegShadow) {
        Paint itemPaint = renderer.getItemPaint(row, column);
        if (itemPaint.getAlpha() == 0) {
            return;
        }
        Rectangle2D shadow = this.createShadow(bar, renderer.getShadowXOffset(), renderer.getShadowYOffset(), base, pegShadow);
        Paint p = renderer.getShadowPaint();
        p.setStyle(Paint.Style.FILL);
        g2.drawRect((float)shadow.getMinX(), (float)shadow.getMinY(), (float)shadow.getMaxX(), (float)shadow.getMaxY(), p);
    }

    private Rectangle2D createShadow(RectangularShape bar, double xOffset, double yOffset, RectangleEdge base, boolean pegShadow) {
        double x0 = bar.getMinX();
        double x1 = bar.getMaxX();
        double y0 = bar.getMinY();
        double y1 = bar.getMaxY();
        if (base == RectangleEdge.TOP) {
            x0 += xOffset;
            x1 += xOffset;
            if (!pegShadow) {
                y0 += yOffset;
            }
            y1 += yOffset;
        } else if (base == RectangleEdge.BOTTOM) {
            x0 += xOffset;
            x1 += xOffset;
            y0 += yOffset;
            if (!pegShadow) {
                y1 += yOffset;
            }
        } else if (base == RectangleEdge.LEFT) {
            if (!pegShadow) {
                x0 += xOffset;
            }
            x1 += xOffset;
            y0 += yOffset;
            y1 += yOffset;
        } else if (base == RectangleEdge.RIGHT) {
            x0 += xOffset;
            if (!pegShadow) {
                x1 += xOffset;
            }
            y0 += yOffset;
            y1 += yOffset;
        }
        return new Rectangle2D.Double(x0, y0, x1 - x0, y1 - y0);
    }

    protected Rectangle2D[] splitVerticalBar(RectangularShape bar, double a, double b, double c) {
        Rectangle2D[] result = new Rectangle2D[4];
        double x0 = bar.getMinX();
        double x1 = Math.rint(x0 + bar.getWidth() * a);
        double x2 = Math.rint(x0 + bar.getWidth() * b);
        double x3 = Math.rint(x0 + bar.getWidth() * c);
        result[0] = new Rectangle2D.Double(bar.getMinX(), bar.getMinY(), x1 - x0, bar.getHeight());
        result[1] = new Rectangle2D.Double(x1, bar.getMinY(), x2 - x1, bar.getHeight());
        result[2] = new Rectangle2D.Double(x2, bar.getMinY(), x3 - x2, bar.getHeight());
        result[3] = new Rectangle2D.Double(x3, bar.getMinY(), bar.getMaxX() - x3, bar.getHeight());
        return result;
    }

    protected Rectangle2D[] splitHorizontalBar(RectangularShape bar, double a, double b, double c) {
        Rectangle2D[] result = new Rectangle2D[4];
        double y0 = bar.getMinY();
        double y1 = Math.rint(y0 + bar.getHeight() * a);
        double y2 = Math.rint(y0 + bar.getHeight() * b);
        double y3 = Math.rint(y0 + bar.getHeight() * c);
        result[0] = new Rectangle2D.Double(bar.getMinX(), bar.getMinY(), bar.getWidth(), y1 - y0);
        result[1] = new Rectangle2D.Double(bar.getMinX(), y1, bar.getWidth(), y2 - y1);
        result[2] = new Rectangle2D.Double(bar.getMinX(), y2, bar.getWidth(), y3 - y2);
        result[3] = new Rectangle2D.Double(bar.getMinX(), y3, bar.getWidth(), bar.getMaxY() - y3);
        return result;
    }
}

