/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.tileprovider.tilesource;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import java.io.File;
import java.io.InputStream;
import java.util.Random;
import org.osmdroid.ResourceProxy;
import org.osmdroid.tileprovider.MapTile;
import org.osmdroid.tileprovider.constants.OpenStreetMapTileProviderConstants;
import org.osmdroid.tileprovider.tilesource.ITileSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BitmapTileSourceBase
implements ITileSource,
OpenStreetMapTileProviderConstants {
    private static final Logger logger = LoggerFactory.getLogger(BitmapTileSourceBase.class);
    private static int globalOrdinal = 0;
    private final int mMinimumZoomLevel;
    private final int mMaximumZoomLevel;
    private final int mOrdinal;
    protected final String mName;
    protected final String mImageFilenameEnding;
    protected final Random random = new Random();
    private final int mTileSizePixels;
    private final ResourceProxy.string mResourceId;

    public BitmapTileSourceBase(String aName, ResourceProxy.string aResourceId, int aZoomMinLevel, int aZoomMaxLevel, int aTileSizePixels, String aImageFilenameEnding) {
        this.mResourceId = aResourceId;
        this.mOrdinal = globalOrdinal++;
        this.mName = aName;
        this.mMinimumZoomLevel = aZoomMinLevel;
        this.mMaximumZoomLevel = aZoomMaxLevel;
        this.mTileSizePixels = aTileSizePixels;
        this.mImageFilenameEnding = aImageFilenameEnding;
    }

    @Override
    public int ordinal() {
        return this.mOrdinal;
    }

    @Override
    public String name() {
        return this.mName;
    }

    public String pathBase() {
        return this.mName;
    }

    public String imageFilenameEnding() {
        return this.mImageFilenameEnding;
    }

    @Override
    public int getMinimumZoomLevel() {
        return this.mMinimumZoomLevel;
    }

    @Override
    public int getMaximumZoomLevel() {
        return this.mMaximumZoomLevel;
    }

    @Override
    public int getTileSizePixels() {
        return this.mTileSizePixels;
    }

    @Override
    public String localizedName(ResourceProxy proxy) {
        return proxy.getString(this.mResourceId);
    }

    @Override
    public Drawable getDrawable(String aFilePath) {
        try {
            Bitmap bitmap2 = BitmapFactory.decodeFile((String)aFilePath);
            if (bitmap2 != null) {
                return new BitmapDrawable(bitmap2);
            }
            try {
                new File(aFilePath).delete();
            }
            catch (Throwable e) {
                logger.error("Error deleting invalid file: " + aFilePath, e);
            }
        }
        catch (OutOfMemoryError e) {
            logger.error("OutOfMemoryError loading bitmap: " + aFilePath);
            System.gc();
        }
        return null;
    }

    @Override
    public String getTileRelativeFilenameString(MapTile tile) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.pathBase());
        sb.append('/');
        sb.append(tile.getZoomLevel());
        sb.append('/');
        sb.append(tile.getX());
        sb.append('/');
        sb.append(tile.getY());
        sb.append(this.imageFilenameEnding());
        return sb.toString();
    }

    @Override
    public Drawable getDrawable(InputStream aFileInputStream) throws LowMemoryException {
        try {
            Bitmap bitmap2 = BitmapFactory.decodeStream((InputStream)aFileInputStream);
            if (bitmap2 != null) {
                return new BitmapDrawable(bitmap2);
            }
        }
        catch (OutOfMemoryError e) {
            logger.error("OutOfMemoryError loading bitmap");
            System.gc();
            throw new LowMemoryException((Throwable)e);
        }
        return null;
    }

    public final class LowMemoryException
    extends Exception {
        private static final long serialVersionUID = 146526524087765134L;

        public LowMemoryException(String pDetailMessage) {
            super(pDetailMessage);
        }

        public LowMemoryException(Throwable pThrowable) {
            super(pThrowable);
        }
    }
}

