/*
 * Decompiled with CFR 0.152.
 */
package com.androidplot.xy;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import com.androidplot.exception.PlotRenderException;
import com.androidplot.series.Series;
import com.androidplot.series.XYSeries;
import com.androidplot.util.ValPixConverter;
import com.androidplot.xy.BarFormatter;
import com.androidplot.xy.XYPlot;
import com.androidplot.xy.XYSeriesRenderer;
import java.util.Map;
import java.util.TreeMap;

public class BarRenderer
extends XYSeriesRenderer<BarFormatter> {
    private BarWidthStyle a = BarWidthStyle.FIXED_WIDTH;
    private float b = 5.0f;

    public BarRenderer(XYPlot xYPlot) {
        super(xYPlot);
    }

    public void setBarWidth(float f, BarWidthStyle barWidthStyle) {
        this.b = f;
    }

    @Override
    public void onRender(Canvas canvas, RectF rectF) throws PlotRenderException {
        int n;
        BarRenderer barRenderer = this;
        int n2 = 0;
        for (XYSeries xYSeries : ((XYPlot)((Object)barRenderer.getPlot())).getSeriesListForRenderer(barRenderer.getClass())) {
            n = xYSeries.size();
            if (n <= n2) continue;
            n2 = n;
        }
        int n3 = n2;
        if (n3 == 0) {
            return;
        }
        TreeMap<Number, XYSeries> treeMap = new TreeMap<Number, XYSeries>();
        for (n = 0; n < n3; ++n) {
            treeMap.clear();
            Object object = ((XYPlot)((Object)this.getPlot())).getSeriesListForRenderer(this.getClass());
            object = object.iterator();
            while (object.hasNext()) {
                XYSeries xYSeries = (XYSeries)object.next();
                if (n >= xYSeries.size()) continue;
                treeMap.put(xYSeries.getY(n), xYSeries);
            }
            this.a(canvas, rectF, treeMap, n);
        }
    }

    @Override
    public void doDrawLegendIcon(Canvas canvas, RectF rectF, String string, BarFormatter barFormatter) {
        canvas.drawRect(rectF, barFormatter.getFillPaint());
        canvas.drawRect(rectF, barFormatter.getBorderPaint());
    }

    private void a(Canvas canvas, RectF rectF, TreeMap<Number, XYSeries> objectArray, int n) {
        Object object = new Paint();
        object.setColor(-65536);
        objectArray = objectArray.entrySet().toArray();
        block3: for (int i = objectArray.length - 1; i >= 0; --i) {
            object = (Map.Entry)objectArray[i];
            BarFormatter barFormatter = (BarFormatter)this.getFormatter((Series)object.getValue());
            Number number = null;
            Number number2 = null;
            if (object.getValue() != null) {
                number = ((XYSeries)object.getValue()).getY(n);
                number2 = ((XYSeries)object.getValue()).getX(n);
            }
            if (number == null || number2 == null) continue;
            switch (this.a) {
                case FIXED_WIDTH: {
                    float f = this.b / 2.0f;
                    float f2 = ValPixConverter.valToPix(number2.doubleValue(), ((XYPlot)((Object)this.getPlot())).getCalculatedMinX().doubleValue(), ((XYPlot)((Object)this.getPlot())).getCalculatedMaxX().doubleValue(), rectF.width(), false) + rectF.left;
                    float f3 = ValPixConverter.valToPix(number.doubleValue(), ((XYPlot)((Object)this.getPlot())).getCalculatedMinY().doubleValue(), ((XYPlot)((Object)this.getPlot())).getCalculatedMaxY().doubleValue(), rectF.height(), true) + rectF.top;
                    canvas.drawRect(f2 - f, f3, f2 + f, rectF.bottom, barFormatter.getFillPaint());
                    canvas.drawRect(f2 - f, f3, f2 + f, rectF.bottom, barFormatter.getBorderPaint());
                    continue block3;
                }
                default: {
                    throw new UnsupportedOperationException("Not yet implemented.");
                }
            }
        }
    }

    public static enum BarWidthStyle {
        FIXED_WIDTH,
        FIXED_SPACING;

    }

    public static enum BarRenderStyle {
        STACKED,
        SIDE_BY_SIDE;

    }
}

