/*
 * Decompiled with CFR 0.152.
 */
package net.droidsolutions.droidcharts.core.label;

import java.io.Serializable;
import java.text.MessageFormat;
import net.droidsolutions.droidcharts.core.data.XYDataset;
import net.droidsolutions.droidcharts.core.label.XYSeriesLabelGenerator;

public class StandardXYSeriesLabelGenerator
implements XYSeriesLabelGenerator,
Cloneable,
Serializable {
    private static final long serialVersionUID = 1916017081848400024L;
    public static final String DEFAULT_LABEL_FORMAT = "{0}";
    private String formatPattern;

    public StandardXYSeriesLabelGenerator() {
        this(DEFAULT_LABEL_FORMAT);
    }

    public StandardXYSeriesLabelGenerator(String format) {
        if (format == null) {
            throw new IllegalArgumentException("Null 'format' argument.");
        }
        this.formatPattern = format;
    }

    @Override
    public String generateLabel(XYDataset dataset, int series) {
        if (dataset == null) {
            throw new IllegalArgumentException("Null 'dataset' argument.");
        }
        String label = MessageFormat.format(this.formatPattern, this.createItemArray(dataset, series));
        return label;
    }

    protected Object[] createItemArray(XYDataset dataset, int series) {
        Object[] result = new Object[]{dataset.getSeriesKey(series).toString()};
        return result;
    }
}

